/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：编辑工作流图形元素的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.graph.BlockActivity;
import com.ds.bpm.bpd.graph.Outflow;
import com.ds.bpm.bpd.graph.Subflow;

/**
 * Class that realizes <B>edit</B> action. Starts editing the first selected
 * cell.
 */
public class EditCell extends ActionBase {

	public EditCell(AbstractEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		AbstractGraph graph = BPD.getInstance().getActivedProcessEditor()
				.getGraph();
		Object cell = graph.getSelectionCell();
		if (!graph.isCellEditable(cell))
			return;
		Window parentW = graph.getEditor().getWindow();
		/*
		 * if (cell instanceof com.ds.bpm.bpd.graph.Process) {
		 * com.ds.bpm.bpd.graph.Process wf =
		 * (com.ds.bpm.bpd.graph.Process) cell; // updating L&F if needed
		 * if (wf.getImplementationEditor() != null) { ProcessEditor ae =
		 * wf.getImplementationEditor(); ae.refreshEditorConfiguration(); } if
		 * (wf.getImplementationEditor() != null &&
		 * (wf.getImplementationEditor().getGraph().getXMLPackage() !=
		 * BPD.getInstance().getRealXMLPackage() ||
		 * wf.getImplementationEditor().getGraph().getXMLPackage().isReadOnly())) {
		 * wf.getImplementationEditor().setButtonsEnabled(false); }
		 * wf.showProcess(); graph.repaint(); }
		 */
		if (cell instanceof Subflow) {
			Subflow sf = (Subflow) cell;
			sf.showSubflow(graph.getXMLPackage());
			// graph.repaint();
		}
		if (cell instanceof Outflow) {
			Outflow sf = (Outflow) cell;
			sf.showSubflow(graph.getXMLPackage());
			// graph.repaint();
		}
		if (cell instanceof BlockActivity) {
			BlockActivity ba = (BlockActivity) cell;
			if (ba.getImplementationEditor() != null) {
				ProcessEditor ae = ba.getImplementationEditor();
				ae.refreshEditorConfiguration();
			}
			if (ba.getImplementationEditor() != null
					&& (ba.getImplementationEditor().getGraph().getXMLPackage() != BPD
							.getInstance().getRealXMLPackage() || ba
							.getImplementationEditor().getGraph()
							.getXMLPackage().isReadOnly())) {
				// ba.getImplementationEditor().setButtonsEnabled(false);
			}
			ba.showBlockActivity();
			// after block activity graph is closed, set the proper workflow
			// manager
			graph
					.setPropertyObject((com.ds.bpm.bpd.xml.elements.WorkflowProcess) graph
							.getPropertyObject());
			graph.repaint();
		}
	}
}
