/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：删除图形元素的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.WorkflowManager;

import org.jgraph.graph.Port;

/**
 * Class that realizes <B>DeleteCell</B> action. Deletes selected cells and
 * their descendants.
 */
public class DeleteCell extends ActionBase {

	public DeleteCell(AbstractEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		if (BPD.getInstance().getActivedProcessEditor() instanceof ProcessEditor) {
			Object[] cells = BPD.getInstance().getActivedProcessEditor()
					.getGraph().getSelectionCells();
			WorkflowManager dm = BPD.getInstance().getActivedProcessEditor()
					.getGraph().getWorkflowManager();
			//Port cell=(Port) cells[0];
		
			dm.removeCellsAndArrangeParticipants(cells);
		} else {
			Object cell = BPD.getInstance().getActivedProcessEditor()
					.getGraph().getSelectionCell();
			if (cell != null && !(cell instanceof Port)) {
				com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = (com.ds.bpm.bpd.xml.elements.WorkflowProcess) ((DefaultMutableTreeNode) cell)
						.getUserObject();
				if (wp.getCollection().canRemoveElement(wp)) {
					WorkflowManager dm = BPD.getInstance()
							.getActivedProcessEditor().getGraph()
							.getWorkflowManager();
					
					dm.removeCellsAndArrangeParticipants(new Object[] { cell });
					
				} else {
					BPD
							.getInstance()
							.message(
									ResourceManager
											.getLanguageDependentString("WarningCannotDeleteProcessThatIsInUseBySomeSubflowActivity"),
									JOptionPane.WARNING_MESSAGE);
				}
			}
		}
	}

}
