/*
 * Created on 2004-3-11
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.WFApplication;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 改变应用配置操作类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-11 15:56:43
 * @version 1.0
 */
public class ChangeApplication extends ActionBase {

	/**
	 * Construct a ChangeApplication instance.
	 * 
	 * @param editor
	 */
	public ChangeApplication(AbstractEditor editor) {
		super(editor);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent arg0) {
		if (BPD.getInstance().getUserInfo() == null) {
			JOptionPane.showMessageDialog(editor.getWindow(), ResourceManager
					.getLanguageDependentString("WarningUserIsNotLogined"), BPD
					.getAppTitle(), JOptionPane.WARNING_MESSAGE);
			return;
		}
		com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = (com.ds.bpm.bpd.xml.elements.WorkflowProcess) BPD
				.getInstance().getActivedProcessEditor().getGraph()
				.getPropertyObject();
		if (wp.getAppName().equals("")) {
			WFApplication wfApp = new WFApplication();
			wfApp.setVisible("AccessLevel", false);
			XMLElementDialog ed = new XMLElementDialog((JFrame) editor
					.getWindow(), ResourceManager
					.getLanguageDependentString("Process.Application.title"));
			ed.editXMLElement(wfApp.getPanel(), true, false);
			boolean isNotApp = false;
			if (ed.isCanceled()) {
				isNotApp = true;
			} else {
				String systemCode = wfApp.get("SystemCode").toValue()
						.toString();
				if (!systemCode.equals("")) {
					wp.reConfigApplication(wfApp, systemCode);
				} else {
					isNotApp = true;
				}
			}
			if (isNotApp) {
				return;
			}
		}
	}
}
