/*
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.event.ActionEvent;

import javax.swing.JFrame;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Class that realizes <B>applications</B> action.
 */
public class Applications extends ActionBase {

	public Applications(AbstractEditor editor) {
		super(editor);
	}

	public void actionPerformed(ActionEvent e) {
		XMLPanel p;
		XMLElementDialog d;

		if (BPD.getInstance().getActivedProcessEditor() != null) {
			com.ds.bpm.bpd.xml.elements.WorkflowProcess wp = (com.ds.bpm.bpd.xml.elements.WorkflowProcess) BPD
					.getInstance().getActivedProcessEditor().getGraph()
					.getPropertyObject();
			p = wp.getPanel(5);
			d = new XMLElementDialog(
					(JFrame) editor.getWindow(),
					ResourceManager.getLanguageDependentString("ProcessKey")
							+ " '"
							+ wp.toString()
							+ "' - "
							+ ResourceManager
									.getLanguageDependentString("ApplicationsKey"));
		} else {
			PackageEditor pe = (PackageEditor) editor;
			if (!pe.isInitialized()) {
				pe.enterPackageID();
			}
			p = pe.getXMLPackage().getPanel(7);
			d = new XMLElementDialog((JFrame) pe.getWindow(), ResourceManager
					.getLanguageDependentString("PackageKey")
					+ " '"
					+ pe.getXMLPackage().get("Id").toString()
					+ "' - "
					+ ResourceManager
							.getLanguageDependentString("ApplicationsKey"));
		}
		d.editXMLElement(p, false, false);

	}
}
