/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：添加路由转折点的操作类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDMarqueeHandler;
import com.ds.bpm.bpd.PackageEditor;
import com.ds.bpm.bpd.graph.Transition;
import com.ds.bpm.bpd.graph.TransitionView;

import org.jgraph.graph.CellView;

/**
 * Class that realizes <B>AddPoint</B> action. "Breaking point" is added on
 * transition at the popup position.
 */
public class AddPoint extends ActionBase {

	public AddPoint(PackageEditor pe) {
		super(pe);
	}

	public void actionPerformed(ActionEvent e) {
		BPDMarqueeHandler pemh = (BPDMarqueeHandler) BPD.getInstance()
				.getActivedProcessEditor().getGraph().getMarqueeHandler();
		Point addAt = pemh.getPopupPoint();
		Object transition = BPD.getInstance().getActivedProcessEditor()
				.getGraph().getSelectionCell();
		if (transition instanceof Transition) {
			CellView view = BPD.getInstance().getActivedProcessEditor()
					.getGraph().getGraphLayoutCache().getMapping(transition,
							false);
			TransitionView tv = (TransitionView) view;
			tv.addPoint(addAt);
		}
	}
}
