/*
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：菜单和按钮的操作基类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.actions;

import javax.swing.AbstractAction;
import javax.swing.Action;

import com.ds.bpm.bpd.AbstractEditor;
import com.ds.bpm.bpd.Utils;

/**
 * The base class for BPD actions.
 */
public abstract class ActionBase extends AbstractAction {

	/**
	 * A reference to the editor class.
	 */
	protected AbstractEditor editor;

	/**
	 * The Abstract action uses unqualified class name as action name.
	 * 
	 * @param editor
	 *            The reference to the editor for this action
	 */
	public ActionBase(AbstractEditor editor) {
		this.editor = editor;
		putValue(Action.NAME, Utils.getUnqualifiedClassName(getClass()));
	}

	/**
	 * Constructor which accepts the action name.
	 * 
	 * @param editor
	 *            The reference to the editor for this action
	 * @param name
	 *            Name of this action
	 */

	public ActionBase(AbstractEditor editor, String name) {
		super(name);
		this.editor = editor;
	}

}
