/* XPDLPreview.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import com.ds.bpm.bpd.actions.Save;
import com.ds.bpm.bpd.xml.XMLElement;

import org.w3c.dom.Document;

/**
 * Shows the preview of XPDL that will be generated based on created graph.
 */
public class XPDLPreview extends JPanel {

   private AbstractEditor editor;

   private JScrollPane xpdlPreviewSP;
   private JTextArea xpdlPreviewTA;

   private JComboBox searchCB=new JComboBox();
   private Component searchPanel;

private static XPDLPreview xpdlPreview;

   
   public static XPDLPreview getInstance(AbstractEditor editor){
	   if (xpdlPreview==null){
		   xpdlPreview=new XPDLPreview(editor);
	   }
	   return xpdlPreview;
   }
   public XPDLPreview (AbstractEditor editor) {
      super(true);
      this.editor=editor;
      setBorder(BorderFactory.createEtchedBorder());
      setLayout(new BorderLayout());
      add(createCenterComponent(),BorderLayout.CENTER);
      searchPanel=createSearchPanel();
      add(searchPanel,BorderLayout.NORTH);
	  refreshView();
   }

   /**
    * Create the center component of this panel.
    */
   protected Component createCenterComponent() {
      // creating text area pane for xpdl preview
      xpdlPreviewTA=new JTextArea();
      xpdlPreviewTA.setLineWrap(false);
      xpdlPreviewTA.setWrapStyleWord(false);
      xpdlPreviewTA.setEditable(false);

      xpdlPreviewSP=new JScrollPane();
      xpdlPreviewSP.setViewportView(xpdlPreviewTA);
      JViewport port = xpdlPreviewSP.getViewport();
      port.setScrollMode(JViewport.SIMPLE_SCROLL_MODE);
	  
      return xpdlPreviewSP;
   }

   protected Component createSearchPanel () {
      JPanel sp=new JPanel();
      sp.setLayout(new BoxLayout(sp,BoxLayout.X_AXIS));

      Border emptyb=BorderFactory.createEmptyBorder(5,5,5,5);
      sp.setBorder(emptyb);

      JLabel jl=new JLabel(ResourceManager.getLanguageDependentString("XPDLPreview.SearchForKey.Name.display")+": ");
      jl.setAlignmentX(Component.LEFT_ALIGNMENT);
      jl.setAlignmentY(Component.BOTTOM_ALIGNMENT);
      jl.setHorizontalAlignment(SwingConstants.RIGHT);

      searchCB.setEditable(true);
      searchCB.setAlignmentX(Component.LEFT_ALIGNMENT);
      searchCB.setAlignmentY(Component.BOTTOM_ALIGNMENT);
      Dimension comboBoxDimension=new Dimension(200,20);
      searchCB.setMinimumSize(new Dimension(comboBoxDimension));
      searchCB.setMaximumSize(new Dimension(comboBoxDimension));
      searchCB.setPreferredSize(new Dimension(comboBoxDimension));

      JButton jb=new JButton("");
      java.net.URL u = ResourceManager.getResource("FindNext"+BPDConstants.IMAGE_SUFFIX);
      if (u!=null) {
         jb.setIcon(new ImageIcon(u));
      }
      jb.setToolTipText(ResourceManager.getLanguageDependentString("XPDLPreview.FindNextStringOccuranceKey.Name.display"));
      jb.setVerticalTextPosition(AbstractButton.CENTER);
      jb.setAlignmentX(Component.LEFT_ALIGNMENT);
      jb.setAlignmentY(Component.BOTTOM_ALIGNMENT);
      jb.setPreferredSize(new Dimension(25,25));

      sp.add(jl);
      sp.add(searchCB);
      sp.add(Box.createHorizontalStrut(5));
      sp.add(jb);

      jb.addActionListener(new ActionListener(){
         public void actionPerformed( ActionEvent ae ){
            findString();
         }
      });

      return sp;
   }
   public void refreshView () {
	   refreshView(null);
   }
   public void refreshView (XMLElement element) {
	    if (BPD.getInstance().getPackageEditor()==null){
	        xpdlPreviewTA.setText("");
	    	return ;
        }
    
	   try {
		 Document document = null;
         DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
         DocumentBuilder dbuilder = dbf.newDocumentBuilder();
         document = dbuilder.newDocument();
         ByteArrayOutputStream baos=new ByteArrayOutputStream();
		 com.ds.bpm.bpd.xml.elements.Package pkg=
               BPD.getInstance().getPackageEditor().getXMLPackage();
		 if (pkg==null){
			 pkg=BPD.getInstance().getPackageEditor().getRealXMLPackage();
		 }
         // The extended attributes for all package elements must
         // be updated if current package is not externally
         // referenced package.
		if ( pkg!=null ){
			  if ( pkg.equals(BPD.getInstance().getRealXMLPackage())) {
		            Save.updateExtendedAttributesForWorkflowProcesses(pkg);
		         }

		         // Here we get all document elements
		         //editor.getGraph().getXPDLObject().toXML(document);
				 if (element==null){
				 pkg.toXML(document);
				 }else{
					element.toXML(document); 
				 }

		         // Use a Transformer for output
		         TransformerFactory tFactory =
		             TransformerFactory.newInstance();
		         Transformer transformer = tFactory.newTransformer();
		         transformer.setOutputProperty("indent","yes");
		         transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount","4");
		         transformer.setOutputProperty("encoding",BPDConfig.getInstance().getEncoding());
		       //if (editor instanceof ProcessEditor) {
		           transformer.setOutputProperty("omit-xml-declaration","yes");
		       // }
		         DOMSource source = new DOMSource(document);
		         StreamResult result = new StreamResult(baos);
		         transformer.transform(source,result);

		         xpdlPreviewTA.setText(baos.toString(BPDConfig.getInstance().getEncoding()));
		         xpdlPreviewTA.setCaretPosition(0);
		         baos.close();
		}
       
      } catch (Exception ex) {
         ex.printStackTrace();
         xpdlPreviewTA.setText("");
      }
   }

   /**
    * Searches the XPDL context containd within text area to find wanted
    * string. Search starts from the current cursor location. When some
    * new text is entered into search box, it can be latter retrieved from
    * the box.
    */
   private void findString() {
      if (searchCB.getSelectedItem()==null) return;
      String searchingTxt=searchCB.getSelectedItem().toString();
      addItemToCombo(searchingTxt);
      String txt = xpdlPreviewTA.getText();
      try {
         int foundPos=xpdlPreviewTA.getCaretPosition();
         for(int i=foundPos;i<=(txt.length() - searchingTxt.length());i++) {
            if(txt.substring(i,i + searchingTxt.length()).equalsIgnoreCase(searchingTxt)) {
               xpdlPreviewTA.setCaretPosition(i);
               xpdlPreviewTA.getCaret().setSelectionVisible(true);
               xpdlPreviewTA.select(i,i+searchingTxt.length());
               foundPos = i+searchingTxt.length();
               return;
            }
         }
      } catch (Exception ex) {}
      JOptionPane.showMessageDialog(editor.getWindow(),
            ResourceManager.getLanguageDependentString("XPDLPreview.MessageBPDHasFinishedSearchingXPDL"),
            BPD.getAppTitle(),JOptionPane.INFORMATION_MESSAGE);
      xpdlPreviewTA.setCaretPosition(0);
      return;
   }

   /**
    * Adds a text into combo box if it hasn't been there previously.
    */
   private void addItemToCombo (String searchingTxt) {
      if (searchingTxt==null || searchingTxt.trim().length()==0) return;
      for (int i=0; i<searchCB.getItemCount(); i++) {
         if (searchCB.getItemAt(i).toString().equals(searchingTxt)) {
            return;
         }
      }
      searchCB.addItem(searchingTxt);
   }

   public void changeLanguage () {
      JLabel l=(JLabel)((JPanel)searchPanel).getComponent(0);
      JButton b=(JButton)((JPanel)searchPanel).getComponent(3);
      l.setText(ResourceManager.getLanguageDependentString("XPDLPreview.SearchForKey.Name.display")+": ");
      b.setToolTipText(ResourceManager.getLanguageDependentString("XPDLPreview.FindNextStringOccuranceKey.Name.display"));
   }

}

