/* WorkflowElement.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：工作流定义接口
 * Authors： wenzhang li
 * Company： 基督山BPM
 *  CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.Window;

import com.ds.bpm.bpd.xml.XMLElement;

public interface WorkflowElement {

	/**
	 * Shows a dialog for editing workflow element properties.
	 */
	public void showPropertyDialog(Window parentWindow, AbstractGraph graph);
	
	
	
	/**
	 * Gets a property object (DTDElement).
	 */
	public XMLElement getPropertyObject();

	/**
	 * Gets an userObject property which name is given in parameter what.
	 */
	public XMLElement get(String what);

	/**
	 * Sets an userObject property which name is given in parameter what to a
	 * value given in a parameter value.
	 */
	public void set(String what, Object value);

	/**
	 * Gets a tooltip text for element.
	 */
	public String getTooltip();

}

/* End of WorkflowElement.java */
