/* ProcessGraph.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：工作流图形界面构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

import javax.swing.tree.DefaultMutableTreeNode;

import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;

import com.ds.bpm.bpd.graph.Activity;
import com.ds.bpm.bpd.graph.ActivityView;
import com.ds.bpm.bpd.graph.AutoActivity;
import com.ds.bpm.bpd.graph.AutoActivityView;
import com.ds.bpm.bpd.graph.BlockActivity;
import com.ds.bpm.bpd.graph.BlockActivityView;
import com.ds.bpm.bpd.graph.DeviceActivity;
import com.ds.bpm.bpd.graph.DeviceActivityView;
import com.ds.bpm.bpd.graph.End;
import com.ds.bpm.bpd.graph.EndView;
import com.ds.bpm.bpd.graph.EventActivity;
import com.ds.bpm.bpd.graph.EventActivityView;
import com.ds.bpm.bpd.graph.Outflow;
import com.ds.bpm.bpd.graph.OutflowView;
import com.ds.bpm.bpd.graph.Participant;
import com.ds.bpm.bpd.graph.ParticipantView;
import com.ds.bpm.bpd.graph.ServiceActivity;
import com.ds.bpm.bpd.graph.ServiceActivityView;
import com.ds.bpm.bpd.graph.Start;
import com.ds.bpm.bpd.graph.StartView;
import com.ds.bpm.bpd.graph.Subflow;
import com.ds.bpm.bpd.graph.SubflowView;
import com.ds.bpm.bpd.graph.Transition;
import com.ds.bpm.bpd.graph.TransitionView;
import com.ds.bpm.bpd.xml.PackageValidator;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;

/**
 * BPD implementation of JGraph. Represents a process graph.
 */
public class ProcessGraph extends AbstractGraph {

	/**
	 * Constructs process graph based on a given model.
	 */
	public ProcessGraph(GraphModel model, AbstractEditor editor,
			ProcessEditor processEditor) {
		super(model, editor);
		this.processEditor = processEditor;
		setMarqueeHandler(new BPDMarqueeHandler(this));
	}

	public ProcessGraph(GraphModel model, GraphLayoutCache view,
			AbstractEditor editor, ProcessEditor processEditor) {
		super(model, view, editor);
		this.processEditor = processEditor;
		setMarqueeHandler(new BPDMarqueeHandler(this));
	}

	protected void initGraphBehavior() {
		super.initGraphBehavior();
		setMoveable(true);
		setDisconnectable(false);
		setDisconnectOnMove(false);
		selectionModel
				.setSelectionMode(GraphSelectionModel.MULTIPLE_GRAPH_SELECTION);

	}

	public com.ds.bpm.bpd.xml.elements.Package getXMLPackage() {
		return ((WorkflowProcess) xmlObject)
				.getPackage();
	}

	public void setPropertyObject(XMLComplexElement wp) {
		xmlObject = wp;
		// disable graph if this is an external package
		com.ds.bpm.bpd.xml.elements.Package myP = ((WorkflowProcess) xmlObject)
				.getPackage();
		if (myP != BPD.getInstance().getRealXMLPackage()) {
			super.initGraphBehavior();
		}
	}

	public void createWorkflowGraph(Window notInUse) {
		workflowManager
				.createWorkflowGraph((WorkflowProcess) xmlObject);
		editor.resetUndoManager();
	}

	/**
	 * Overrides Superclass method.
	 */
	public String convertValueToString(Object value) {
		if (value instanceof CellView) {
			value = ((CellView) value).getCell();
		}
		if (value instanceof DefaultMutableTreeNode
				&& !(value instanceof Transition) && !(value instanceof Start)
				&& !(value instanceof End)
				&& ((DefaultMutableTreeNode) value).getUserObject() != null) {
			return ((DefaultMutableTreeNode) value).getUserObject().toString();
		} else if (value != null) {
			return value.toString();
		}
		return null;
	}

	/**
	 * Override Superclass Method to Return Custom vertexView.
	 */
	 protected VertexView createVertexView(JGraph graph,CellMapper cm,Object cell) {//HM, JGraph3.4.1
	
		if (cell instanceof Participant) {
			return new ParticipantView(cell, this, cm);
		} else if (cell instanceof Subflow) {
			return new SubflowView(cell, this, cm);
		} else if (cell instanceof Outflow) {
			return new OutflowView(cell, this, cm);
		} else if (cell instanceof BlockActivity) {
			return new BlockActivityView(cell, this, cm);
		} else if (cell instanceof Start) {
			return new StartView(cell, this, cm);
		} else if (cell instanceof End) {
			return new EndView(cell, this, cm);
		} else if (cell instanceof AutoActivity) {
			return new AutoActivityView(cell, this, cm);
		} else if (cell instanceof ServiceActivity) {
			return new ServiceActivityView(cell, this, cm);
		} else if (cell instanceof DeviceActivity) {
			return new DeviceActivityView(cell, this, cm);
		} else if (cell instanceof EventActivity) {
			return new EventActivityView(cell, this, cm);
		} else if (cell instanceof Activity) {
			return new ActivityView(cell, this, cm);		
		} else {
			 return super.createVertexView(graph,cm,cell);//HM, JGraph3.4.1
		}
	}

	/**
	 * Override Superclass Method to Return Custom EdgeView.
	 */
	  protected EdgeView createEdgeView(JGraph graph, CellMapper cm,Object e) {//HM, JGraph3.4.1
		if (e instanceof Transition) {
			return new TransitionView(e, this, cm);
		} else {
			  return super.createEdgeView(graph,cm,e);//HM, JGraph3.4.1
		}
	}

	/**
	 * Override Superclass Method to Return Custom PortView.
	 */
	protected PortView createPortView(Port p, CellMapper cm) {
		return new BPDPortView(p, this, cm);
	}

	/**
	 * Finds the topmost Participant at specified location.
	 */
	public Object getFirstParticipantForLocation(int x, int y) {
		x /= scale;
		y /= scale; // FIX: Consistency with other methods?
		CellView[] cells = getOrderedAllSelectableCells();
		if (cells != null) {
			Rectangle r = new Rectangle(x - tolerance, y - tolerance,
					2 * tolerance, 2 * tolerance);
			// Iterate through cells and find first Participant at
			// if current is traversed. Cache first cell.
			CellView first = null;
			for (int i = 0; i < cells.length; i++) {
				if (cells[i] instanceof ParticipantView) {
					boolean intersects = cells[i].getBounds().intersects(r);
					if (intersects) {
						return cells[i].getCell();
					}
				}
			}
		}
		return null;
	}

	/**
	 * Modified from original to support all views
	 */
	public CellView getNextViewAt(CellView current, int x, int y) {
		CellView[] sel = getOrderedAllSelectableCells();
		CellView cell = getNextViewAt(sel, current, x, y);
		return cell;
	}

	/**
	 * Modified from original to suite our needs. This method makes a
	 * Participant to be selected only when it's name part is pressed, and to
	 * give it's tooltip only when you want to insert some cells in it.
	 */
	public CellView getNextViewAt(CellView[] cells, CellView c, int x, int y) {
		if (cells != null) {
			Rectangle r = new Rectangle(x - tolerance, y - tolerance,
					2 * tolerance, 2 * tolerance);
			// Iterate through cells and switch to active
			// if current is traversed. Cache first cell.
			CellView first = null;
			boolean active = (c == null);
			for (int i = 0; i < cells.length; i++) {
				boolean intersects = false;
				boolean wholeArea = true;
				if (((BPDMarqueeHandler) marquee).getSelectButton()
						.isSelected()
						|| ((BPDMarqueeHandler) marquee).getTransitionButton()
								.isSelected()
						|| ((BPDMarqueeHandler) marquee)
								.getSelfRoutedTransitionButton().isSelected()) {
					wholeArea = false;
				}
				if ((cells[i] instanceof ParticipantView) && wholeArea) {
					intersects = cells[i].getBounds().intersects(r);
				} else {
					intersects = cells[i].intersects(getGraphics(), r);
				}

				if (intersects) {
					if (active) {
						return cells[i];
					} else if (first == null) {
						first = cells[i];
					}
					active = active | (cells[i] == c);
				}
			}
			return first;
		}
		return null;
	}

	/**
	 * This method gets all selectable views and puts it in an order that suites
	 * to our needs (first comes activities and transitions(edges), and then
	 * Participants sorted by level - root Participants comes last)
	 */
	private CellView[] getOrderedAllSelectableCells() {
		// Get Roots in View Order
		CellView[] views = graphLayoutCache.getRoots();
		// Add Roots to Stack
		Stack s = new Stack();
		for (int i = 0; i < views.length; i++) {
			s.add(views[i]);
		}
		java.util.List result = new ArrayList();
		// Traverse All Children In View Order
		while (!s.isEmpty()) {
			CellView view = (CellView) s.pop();
			Object cell = view.getCell();
			// Add To List if it is not a port or forbidden object
			if (!(cell instanceof Port)) {// && !(cell instanceof
											// SubflowPort)) {
				result.add(view);
			}
			// Add Children to Stack
			CellView[] children = view.getChildViews();
			for (int i = 0; i < children.length; i++) {
				s.add(children[i]);
			}
		}
		// Order so that all activities comes first, after that Participants in
		// ordered view

		// first iteration - separating Participants and others
		java.util.List activitiesAndEdges = new ArrayList();
		java.util.List participants = new ArrayList();
		Iterator it = result.iterator();
		while (it.hasNext()) {
			CellView cv = (CellView) it.next();
			if (cv.getCell() instanceof Participant) {
				participants.add(cv);
			} else {
				activitiesAndEdges.add(cv);
			}
		}

		// second iteration - order, first adding activities & edges and then
		// Participants in reversed order: it must be done that way because the
		// child views of Participants (activities) that had focus more recently
		// has higher number and are placed closer to the begining of
		// activitiesAndEdges set, but on contrary, Participants that has higher
		// depth (and should have focus before their parents) are placed closer
		// to the end of Participants set
		int i = -1;
		int j = participants.size() + activitiesAndEdges.size();
		CellView[] tmp = new CellView[j];

		it = activitiesAndEdges.iterator();
		while (it.hasNext()) {
			tmp[++i] = (CellView) it.next();
		}

		it = participants.iterator();
		while (it.hasNext()) {
			tmp[--j] = (CellView) it.next();
		}

		return tmp;
	}

	/**
	 * Only for debugging purpose.
	 */
	public void printOrderedAllSelectables() {
		CellView[] sel = getOrderedAllSelectableCells();
		for (int i = 0; i < sel.length; i++)
			System.out.println("view" + i + "=" + sel[i].getCell());
	}

	/**
	 * Overrides <code>JComponent</code>'s <code>getToolTipText</code>
	 * method in order to allow the graph controller to create a tooltip for the
	 * topmost cell under the mousepointer. This differs from JTree where the
	 * renderers tooltip is used.
	 * <p>
	 * NOTE: For <code>JGraph</code> to properly display tooltips of its
	 * renderers, <code>JGraph</code> must be a registered component with the
	 * <code>ToolTipManager</code>. This can be done by invoking
	 * <code>ToolTipManager.sharedInstance().registerComponent(graph)</code>.
	 * This is not done automatically!
	 * 
	 * @param event
	 *            the <code>MouseEvent</code> that initiated the
	 *            <code>ToolTip</code> display
	 * @return a string containing the tooltip or <code>null</code> if
	 *         <code>event</code> is null
	 */
	public String getToolTipText(MouseEvent event) {
		if (event != null) {
			Object cell;
			// if activity or Participant is to be inserted, show
			// underlying Participant, else show other
			if (!(((BPDMarqueeHandler) marquee).getSelectButton().isSelected()
					|| ((BPDMarqueeHandler) marquee).getAutoActivityButton()
							.isSelected() || ((BPDMarqueeHandler) marquee)
					.getSelfRoutedTransitionButton().isSelected())) {
				cell = getFirstParticipantForLocation(event.getX(), event
						.getY());
			} else {
				cell = getFirstCellForLocation(event.getX(), event.getY());
			}
			if (cell != null && !(cell instanceof Participant)) {
				String s = convertValueToString(cell);
				if (cell instanceof WorkflowElement) {
					s = ((WorkflowElement) cell).getTooltip();
				}
				return s;
			}
		}
		return null;
	}

	public void setAdditionalKeyboardShortcuts() {
		super.setAdditionalKeyboardShortcuts();
		/*
		 * getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW)
		 * .put(KeyStroke.getKeyStroke(KeyEvent.VK_BACK_SPACE,
		 * InputEvent.ALT_DOWN_MASK, false),
		 * Utils.getUnqualifiedClassName(HideWindow.class));
		 * getActionMap().put(Utils.getUnqualifiedClassName(HideWindow.class),
		 * editor.getAction(Utils.getUnqualifiedClassName(HideWindow.class)));
		 */
	}

	// 验证工作流是否符合XPDL Schema
	public boolean validateAgainsXPDLSchema() {
		/*
		 * Save.updateExtendedAttributesForWorkflowProcesses(); PackageValidator
		 * pv=new PackageValidator(getXMLPackage(),true,true, false,true);
		 * boolean isValid=pv.validateAgainstXPDLSchema();
		 * xpdlSchemaValidationErrors=pv.getXPDLSchemaValidationErrors(); if
		 * (!isValid && xpdlSchemaValidationErrors.size()>0) {
		 * basicXpdlSchemaValidationError=ResourceManager.
		 * getLanguageDependentString("MessageThereAreSomeSchemaValidationErrors"); }
		 * else { basicXpdlSchemaValidationError=null; }
		 */return true;
	}

	public boolean checkConnections(boolean fullCheck) {
		updateXMLObjectsBeforeChecking();
		PackageValidator pv = new PackageValidator(getXMLPackage(), true, true,
				false, false);
		XMLCollectionElement wpOrAs = (XMLCollectionElement) getXPDLObject();
		boolean isGraphWellConnected = pv.checkGraphConnections(wpOrAs,
				fullCheck);
		basicGraphConnectionError = pv.getBasicGraphConnectionError(wpOrAs);
		graphConnectionErrors = pv.getGraphsConnectionErrors(wpOrAs);
		if (fullCheck || isGraphWellConnected) {
			isGraphWellConnected = checkStartEndEndsConnections(fullCheck)
					&& isGraphWellConnected;
		}
		return isGraphWellConnected;
	}

	protected boolean checkStartEndEndsConnections(boolean fullCheck) {
		boolean wellConnected = true;
		WorkflowProcess wp = (WorkflowProcess) getPropertyObject();
		if (graphConformanceErrors == null) {
			graphConformanceErrors = new HashMap();
		}

		// check start's and end's connections
		Set icStarts = getImproperlyConnectedStarts(fullCheck);
		if (icStarts.size() > 0) {
			wellConnected = false;
			basicGraphConnectionError = ResourceManager
					.getLanguageDependentString("InformationOneOrMoreElementsAreNotProperlyConnected");
			if (fullCheck) {
				for (Iterator i = icStarts.iterator(); i.hasNext();) {
					Start s = (Start) i.next();
					graphConnectionErrors
							.put(
									s,
									ResourceManager
											.getLanguageDependentString("ErrorOutgoingTransitionIsMissing")
											+ "; ");
				}
			}
		}

		if (fullCheck || wellConnected) {
			Set icEnds = getImproperlyConnectedEnds(fullCheck);
			if (icEnds.size() > 0) {
				wellConnected = false;
				basicGraphConnectionError = ResourceManager
						.getLanguageDependentString("InformationOneOrMoreElementsAreNotProperlyConnected");
				if (fullCheck) {
					for (Iterator i = icEnds.iterator(); i.hasNext();) {
						End e = (End) i.next();
						graphConnectionErrors
								.put(
										e,
										ResourceManager
												.getLanguageDependentString("ErrorIncomingTransitionIsMissing")
												+ "; ");
					}
				}
			}
		}

		if (fullCheck || wellConnected) {
			// find all block activities
			Set blockActs = workflowManager.getBlockActivities(true);
			Iterator itBas = blockActs.iterator();
			while (itBas.hasNext()) {
				BlockActivity ba = (BlockActivity) itBas.next();
				ProcessEditor bwe = ba.getImplementationEditor();
				if (bwe != null) {
					ProcessGraph bag = (ProcessGraph) bwe.getGraph();
					if (bag.getImproperlyConnectedStarts(false).size() > 0
							|| bag.getImproperlyConnectedEnds(false).size() > 0) {
						wellConnected = false;
						basicGraphConnectionError = ResourceManager
								.getLanguageDependentString("InformationOneOrMoreElementsAreNotProperlyConnected");
						if (!fullCheck) {
							break;
						}
						String m = ResourceManager
								.getLanguageDependentString("ErrorInnerTransitionError");
						String msg = (String) graphConnectionErrors.get(ba
								.getUserObject());
						if (msg == null) {
							graphConnectionErrors.put(ba, m);
						} else {
							if (msg.indexOf(m) != -1) {
								msg = msg + m;
							}
						}
					}

				}
			}
		}
		return wellConnected;
	}

	public Set getImproperlyConnectedStarts(boolean fullCheck) {
		Set icStarts = new HashSet();
		Set starts = workflowManager.getStarts();
		for (Iterator i = starts.iterator(); i.hasNext();) {
			Start s = (Start) i.next();
			if (s.getOutgoingTransitions().size() == 0) {
				icStarts.add(s);
				if (!fullCheck) {
					break;
				}
			}
		}
		return icStarts;
	}

	public Set getImproperlyConnectedEnds(boolean fullCheck) {
		Set icEnds = new HashSet();
		Set ends = workflowManager.getEnds();
		for (Iterator i = ends.iterator(); i.hasNext();) {
			End e = (End) i.next();
			if (e.getIncomingTransitions().size() == 0) {
				icEnds.add(e);
				if (!fullCheck) {
					break;
				}
			}
		}
		return icEnds;
	}

	protected void updateXMLObjectsBeforeChecking() {
		// first update extended attributes for start and end for all processes
		// gets all activities (processes)
		WorkflowProcess wp = (WorkflowProcess) getPropertyObject();
		wp.setStartDescriptions(Utils.getStartDescriptions(BPD.getInstance()
				.getActivedProcessEditor()));
		wp.setEndDescriptions(Utils.getEndDescriptions(BPD.getInstance()
				.getActivedProcessEditor()));
		// find all block activities
		Set blockActs = workflowManager.getBlockActivities(true);
		Iterator itBas = blockActs.iterator();
		while (itBas.hasNext()) {
			BlockActivity ba = (BlockActivity) itBas.next();
			ProcessEditor bwe = ba.getImplementationEditor();
			com.ds.bpm.bpd.xml.activity.Activity bap = (com.ds.bpm.bpd.xml.activity.Activity) ba
					.getUserObject();
			bap.setStartDescriptions(Utils.getStartDescriptions(bwe));
			bap.setEndDescriptions(Utils.getEndDescriptions(bwe));
		}
	}

	/**
	 * Checks if graph conforms to the given conformance class.
	 * 
	 * @return true if graph is conformant, false otherwise
	 */
	public boolean checkGraphConformance(boolean fullCheck) {
		PackageValidator pv = new PackageValidator(getXMLPackage(), true, true,
				false, false);
		XMLCollectionElement wpOrAs = (XMLCollectionElement) getXPDLObject();
		boolean areGraphsConformant = pv.checkGraphConformance(wpOrAs,
				fullCheck);
		basicGraphConformanceErrors = pv.getBasicGraphConformanceErrors(wpOrAs);
		graphConformanceErrors = pv.getGraphConformanceErrors(wpOrAs);
		return areGraphsConformant;
	}

	public boolean checkLogic(boolean fullCheck) {
		PackageValidator pv = new PackageValidator(getXMLPackage(), true, true,
				false, false);
		boolean isLogical = pv.checkWorkflowProcess(
				(WorkflowProcess) getXPDLObject(), fullCheck);
		basicLogicError = pv
				.getBasicLogicError((WorkflowProcess) getXPDLObject());
		logicErrors = pv.getLogicErrors((WorkflowProcess) getXPDLObject());
		return isLogical;
	}

	/**
	 * Reacts upon the XML element change by setting isModified flag of
	 * PackageEditor if needed.
	 */
	public void xmlElementChanged(XMLElement el) {
		if (el instanceof com.ds.bpm.bpd.xml.activity.Activity) {
			editor.getStatusBar().updateMessage();
		}
	}

	/**
	 * Gets an editor object.
	 */
	public ProcessEditor getProcessEditor() {
		return processEditor;
	}

	public void createWorkflowListGraph(Window pFrame) {
		com.ds.bpm.bpd.xml.elements.Package p = (com.ds.bpm.bpd.xml.elements.Package) xmlObject;
		com.ds.bpm.bpd.xml.elements.WorkflowProcesses wps = (com.ds.bpm.bpd.xml.elements.WorkflowProcesses) p
				.get("WorkflowProcesses");
		Iterator it = wps.toCollection().iterator();
		while (it.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) it
					.next();
			createWorkflowObject(pFrame, wp);
			// decrement ID of WPs
			wps.decrementID();
		}
	}

	public void createWorkflowObject(Window pFrame,
			WorkflowProcess wp) {
		com.ds.bpm.bpd.graph.Process pr = workflowManager.insertProcess(
				wp, true);
		pr.setUserObject(wp);
		pr.createWorkflowGraph(pFrame);
		paintImmediately(getBounds());
		((PackageEditor) editor).putProcessObjectMapping(wp, pr);
	}

	public void showWebEditor(Window parentWindow, AbstractGraph graph) {
		// TODO Auto-generated method stub
		
	}

}
