/* ProcessEditor.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：主界面UI的展现抽象类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import java.awt.BorderLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

import com.ds.bpm.bpd.actions.AddPoint;
import com.ds.bpm.bpd.actions.Copy;
import com.ds.bpm.bpd.actions.Cut;
import com.ds.bpm.bpd.actions.DeleteCell;
import com.ds.bpm.bpd.actions.EditProperties;
import com.ds.bpm.bpd.actions.FocusNearestCell;
import com.ds.bpm.bpd.actions.PasteAt;
import com.ds.bpm.bpd.actions.RemovePoint;
import com.ds.bpm.bpd.actions.SetNoRouting;
import com.ds.bpm.bpd.actions.SetSelfRouting;
import com.ds.bpm.bpd.graph.BlockActivityEditor;
import com.ds.bpm.bpd.graph.End;
import com.ds.bpm.bpd.graph.Start;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.WorkflowProcesses;

import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.graph.GraphUndoManager;

/**
 * 流程界面构造类
 */

public class ProcessEditor extends JPanel implements
org.jgraph.event.GraphModelListener,
org.jgraph.event.GraphSelectionListener, Observer {

	// 主界面构造类
	protected AbstractEditor parentEditor;

	// 撤销操作管理类
	protected GraphUndoManager undo;

	protected UndoHandler undoHandler;

	// 工作流程图形界面
	protected AbstractGraph graph;

	protected JScrollPane graphScrollPane;

	// 工作流配置有改变的标志
	protected boolean processModified;

	// 流程是本地还是远程的标识
	private String processFlag;

	/**
	 * 撤销、重复操作的实现 undo and redo action implementations
	 */
	// --- action implementations -----------------------------------
	// protected Undo undoAction = new Undo(parentEditor);
	// protected Redo redoAction = new Redo(parentEditor);
	protected XMLElementDialog elementEditingDialog = null;

	/**
	 * 获得流程元素对话框
	 * 
	 * @return XMLElementDialog
	 */
	public XMLElementDialog getElementEditingDialog() {
		if (elementEditingDialog == null || !elementEditingDialog.isShowing()) {
			elementEditingDialog = new XMLElementDialog((JFrame) parentEditor
					.getWindow(), "", false);
			setALTCursorKeyboardShortcuts(elementEditingDialog.getRootPane());
		}
		return elementEditingDialog;
	}

	/**
	 * Creates instance of ProcessEditor class.
	 */
	public ProcessEditor(WorkflowProcess wp,
			AbstractEditor parentEditor) {
		super(true);
		this.parentEditor = parentEditor;

		// setBorder(BorderFactory.createLoweredBevelBorder());
		setLayout(new BorderLayout());

		// creating undo manager 撤销操作管理
		undoHandler = new UndoHandler(parentEditor, true);
		undo = new GraphUndoManager();

		// create the processGraph 创建工作流图形
		graph = createGraph();
		// registers graph's tooltip listener 注册图形鼠标提示
		ToolTipManager.sharedInstance().registerComponent(graph);
		// registers graph' listener 注册图形
		registerListeners(graph);
		// Add this as a listener for undoable edits. 为撤销操作创建侦听器
		graph.getModel().addUndoableEditListener(parentEditor.undoHandler);
		graph.setAdditionalKeyboardShortcuts();
		// 为工作流图形界面与画图按钮建立关联
		graph.getMarqueeHandler();
		// seting property object of graph 设置工作流图形属性对象
		graph.setPropertyObject(wp);
		// 将加了滚动条的工作流图形界面，置于JPanel中
		graphScrollPane = new JScrollPane(graph);
		
		graphScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
		JViewport port = graphScrollPane.getViewport();
		port.setScrollMode(JViewport.BLIT_SCROLL_MODE);
		add(BorderLayout.CENTER, graphScrollPane);
		processModified = false;

		// valueChanged(null);

	}

	/**
	 * 创建工作流图形界面 Create an graph to represent the given document.
	 */
	protected AbstractGraph createGraph() {
		BPDGraphModel model = new BPDGraphModel();
		graph = new ProcessGraph(model, parentEditor, this);
		return graph;
	}

	// *********************** GRAPH SELECTION LISTENER INTERFACE
	// ******************
	/** Enables and disables various actions depending of cell selection */
	public void valueChanged(GraphSelectionEvent e) {
		// enable/disable actions
		
		boolean enabled = !graph.isSelectionEmpty();
		try {
			Object cell = graph.getSelectionCell();
			/*
			 * parentEditor.getAction(Utils.getUnqualifiedClassName(EditCell.class)).setEnabled(enabled &&
			 * ((cell instanceof Subflow) || (cell instanceof BlockActivity)));8
			 * parentEditor.getAction(Utils.getUnqualifiedClassName(EditProperties.class)).setEnabled(enabled);
			 * parentEditor.getAction(BPDConstants.REFERRED_DOCUMENT).setEnabled(enabled &&
			 * cell instanceof Activity && !(cell instanceof Start) && !(cell
			 * instanceof End));
			 */

			if (!graph.getXMLPackage().isReadOnly()) {
				parentEditor
						.getAction(Utils.getUnqualifiedClassName(Cut.class))
						.setEnabled(enabled);
				parentEditor.getAction(
						Utils.getUnqualifiedClassName(Copy.class)).setEnabled(
						enabled);
				parentEditor.getAction(
						Utils.getUnqualifiedClassName(PasteAt.class))
						.setEnabled(true);
				parentEditor.getAction(
						Utils.getUnqualifiedClassName(DeleteCell.class))
						.setEnabled(enabled);
			}
			if (enabled && cell != null && !(cell instanceof Start)
					&& !(cell instanceof End)
					&& this.elementEditingDialog != null
					&& this.elementEditingDialog.isShowing()) {
				if (this.elementEditingDialog.getEditingPanel().getOwner() != ((WorkflowElement) cell)
						.getPropertyObject()) {
					parentEditor
							.getAction(
									Utils
											.getUnqualifiedClassName(EditProperties.class))
							.actionPerformed(null);
				} else {
				}
				
			}
			if (this.elementEditingDialog != null
					&& this.elementEditingDialog.isShowing()) {
				this.elementEditingDialog.requestFocus();
			}
		} catch (Exception ex) {
			System.out
					.println("ProcessEditor Class--valueChanged(GraphSelectionEvent e) Method Error!");
		}
		update();
	}

	public void setButtonsEnabled(boolean enable) {
		try {
			// other
			parentEditor.undoAction.setEnabled(enable);
			parentEditor.redoAction.setEnabled(enable);
			parentEditor.getAction(Utils.getUnqualifiedClassName(Cut.class))
					.setEnabled(enable);
			parentEditor.getAction(Utils.getUnqualifiedClassName(Copy.class))
					.setEnabled(enable);
			// parentEditor.getAction(Utils.getUnqualifiedClassName(Paste.class)).setEnabled(enable);
			parentEditor
					.getAction(Utils.getUnqualifiedClassName(PasteAt.class))
					.setEnabled(enable);
			parentEditor.getAction(
					Utils.getUnqualifiedClassName(DeleteCell.class))
					.setEnabled(enable);
			parentEditor.getAction(
					Utils.getUnqualifiedClassName(AddPoint.class)).setEnabled(
					enable);
			parentEditor.getAction(
					Utils.getUnqualifiedClassName(RemovePoint.class))
					.setEnabled(enable);
			parentEditor.getAction(
					Utils.getUnqualifiedClassName(SetNoRouting.class))
					.setEnabled(enable);
			parentEditor.getAction(
					Utils.getUnqualifiedClassName(SetSelfRouting.class))
					.setEnabled(enable);
			// when opening file
		} catch (Exception ex) {
			System.out
					.println("ProcessEditor Class--setButtonsEnabled() Method Error!");
		}
	}

	/**
	 * Gets a title.
	 */
	public String getProcessTitle() {
		String title = "";
		if (processFlag == null) {
			title = ResourceManager.getLanguageDependentString("NewProcessKey");
		} else {
			if (processFlag.equals(BPDConstants.PROCESS_LOCAL)) {
				title = ResourceManager
						.getLanguageDependentString("LocalProcessKey");
			} else if (processFlag.equals(BPDConstants.PROCESS_REMOTE)) {
				title = ResourceManager
						.getLanguageDependentString("RemoteProcessKey");
			}
		}
		String versionName = ResourceManager
				.getLanguageDependentString("PackageTreePanel.RemoteProcessVersionNode.Name.display")
				+ "."
				+ ((WorkflowProcess) graph.getPropertyObject())
						.getVersionNumber();
		title += ResourceManager.getLanguageDependentString("ProcessKey")
				+ "-'" + graph.getPropertyObject().toString() + "("
				+ versionName + ")'";
		return title;
	}

	/**
	 * Returns string of toolbars for load.
	 */
	public String toolbarToLoad() {
		return "Toolbars";
	}

	public String buttongroupToLoad() {
		return "ProcessToolBox";
	}

	/**
	 * Returns string of menubar for load.
	 */
	public String menubarToLoad() {
		return "Menubar";
	}

	/**
	 * 此方法获得主界面的状态栏 Get the statusBar
	 */
	public BPDStatusBar getStatusBar() {
		return parentEditor.statusBar;
	}

	/**
	 * 获得主界面的对象 Gets parentEditor.
	 */
	public AbstractEditor getParentEditor() {
		return parentEditor;
	}

	/**
	 * Invoked after the selection or the model has changed.
	 */
	public void update() {
		// FIX: Test Multi-View Undo
		// Remove View-Observer (cannot listen to other views)
		parentEditor.undoAction.update();
		parentEditor.redoAction.update();
		// FIX: End of Test
		try {
			// 验证编辑面板是否已经添加到JTabPanel中，没有的话暂时不刷新
			int selectedIndex = parentEditor.contentTabbedPane
					.indexOfComponent(this);
			if (selectedIndex != -1) {
				if (this instanceof BlockActivityEditor) {
					BlockActivityEditor blockActivityEditor = (BlockActivityEditor) this;
					parentEditor.contentTabbedPane.setTitleAt(selectedIndex,
							blockActivityEditor.getBlockActivityTitle());
				} else {
					parentEditor.contentTabbedPane.setTitleAt(selectedIndex,
							getProcessTitle());
				}
				//parentEditor.getStatusBar().updateMessage();
				//JPanel jpanel=BPD.getInstance().getErrTablePanel().getTablePanel();
				//BPD.getInstance().getPackageEditor().errPanel=jpanel;
				//BPD.getInstance().getPackageEditor().graphMainsplitPane.setBottomComponent(jpanel);
			}
			parentEditor.valueChanged(null);
		} catch (Exception ex) {
		}
	}

	/**
	 * 刷新界面
	 */
	public void refreshEditorConfiguration() {
		SwingUtilities.updateComponentTreeUI(this);
		// BUG WITH Java 1.4.2 -> must set back Rollover property of toolbars
		try {
			JToolBar toolbar = (JToolBar) parentEditor.mainPanel
					.getComponent(0);
			toolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
			toolbar.updateUI();
		} catch (Exception ex) {
		}
		parentEditor.statusBar.setVisible(BPDConfig.getInstance()
				.getStatusBarStatus());
		parentEditor.statusBar.updateMessage();
		//JPanel jpanel=BPD.getInstance().getErrTablePanel().getTablePanel();
		//BPD.getInstance().getPackageEditor().errPanel=jpanel;
		//BPD.getInstance().getPackageEditor().graphMainsplitPane.setBottomComponent(jpanel);
		graph.refreshGraphConfiguration();
	}

	/**
	 * 刷新集合
	 * 
	 * @param s1
	 * @param s2
	 */
	public void refreshCollections(Set s1, Set s2) {
		Set toAdd = new HashSet();
		Set toRemove = new HashSet();
		if (s1 != null) {
			toRemove.addAll(s1);
			if (s2 != null) {
				toRemove.removeAll(s2);
			}
		}
		if (s2 != null) {
			toAdd.addAll(s2);
			if (s1 != null) {
				toAdd.removeAll(s1);
			}
		}
		graph.getWorkflowManager().refreshCollections(toAdd.toArray(), true);
		graph.getWorkflowManager()
				.refreshCollections(toRemove.toArray(), false);
	}

	// ********************* REGISTRATION AND REMOVAL OF LISTENERS
	// *****************
	/* Add this documents listeners to the specified graph. */
	protected void registerListeners(JGraph graph) {
		graph.getSelectionModel().addGraphSelectionListener(this);
		graph.getModel().addGraphModelListener(this);
		graph.getGraphLayoutCache().addObserver(this);
	}

	/* Remove this documents listeners from the specified graph. */
	protected void unregisterListeners(JGraph graph) {
		graph.getSelectionModel().removeGraphSelectionListener(this);
		graph.getModel().removeGraphModelListener(this);
	}

	// ***************** END OF REGISTRATION AND REMOVAL OF LISTENERS
	// **************

	// ***************************** GRAPH MODEL LISTENER INTERFACE
	// ****************
	/**
	 * @param e
	 */
	public void graphChanged(GraphModelEvent e) {
		BPD.getInstance().setModified(true);
		processModified = true;
		update();
	}

	// ************************* END OF GRAPH MODEL LISTENER INTERFACE
	// *************

	// ****************************** OBSERVER INTERFACE
	// ***************************
	public void update(Observable obs, Object arg) {
		BPD.getInstance().setModified(true);
		processModified = true;
		update();
	}

	// ************************** END OF OBSERVER INTERFACE
	// ************************

	protected void setALTCursorKeyboardShortcuts(JComponent jc) {
		String focusUp = "focusUp";
		String focusDown = "focusDown";
		String focusLeft = "focusLeft";
		String focusRight = "focusRight";
		jc.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_UP,
						InputEvent.ALT_DOWN_MASK, false), focusUp);
		jc.getActionMap().put(focusUp,
				new FocusNearestCell(parentEditor, FocusNearestCell.FOCUS_UP));
		jc.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,
						InputEvent.ALT_DOWN_MASK, false), focusDown);
		jc.getActionMap()
				.put(
						focusDown,
						new FocusNearestCell(parentEditor,
								FocusNearestCell.FOCUS_DOWN));
		jc.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_LEFT,
						InputEvent.ALT_DOWN_MASK, false), focusLeft);
		jc.getActionMap()
				.put(
						focusLeft,
						new FocusNearestCell(parentEditor,
								FocusNearestCell.FOCUS_LEFT));
		jc.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT,
						InputEvent.ALT_DOWN_MASK, false), focusRight);
		jc.getActionMap()
				.put(
						focusRight,
						new FocusNearestCell(parentEditor,
								FocusNearestCell.FOCUS_RIGHT));
	}

	/** Sets the value of scale for zooming. */
	public void setScale(double scale) {
		scale = Math.max(Math.min(scale, 2), 0.1);
		graph.setScale(scale);
	}

	/**
	 * 获得工作流图形对象
	 */
	public AbstractGraph getGraph() {
		return graph;
	}

	// 获得工作流是否有改变
	public boolean getProcessModified() {
		return processModified;
	}

	// 设置工作流是否有改变
	public void setProcessModified(boolean processModified) {
		this.processModified = processModified;
	}

	/*
	 * Method for closing document. Returns true if the user really wants to
	 * close. Gives chance to save work.
	 */
	public boolean closeProcess() {
		if (getProcessModified()) {
			// 关闭时，选择当前编辑流程

			parentEditor.getContentTabbedPane().setSelectedComponent(this);

			WorkflowProcess pe = (WorkflowProcess) BPD.getInstance()
					.getActivedProcessEditor().getGraph().getPropertyObject();
			if (!pe.isSubFlow()) {
				parentEditor.getAction("Save").actionPerformed(null);
			}
		}
		return true;
	}

	/**
	 * 获得流程属于本地还是远程的标识
	 * 
	 * @return processFlag
	 */
	public String getProcessFlag() {
		if (processFlag==null){
			processFlag=BPDConstants.PROCESS_REMOTE;
		}
		
		return processFlag;
	}

	/**
	 * 设置流程的标识
	 * 
	 * @param processFlag
	 */
	public void setProcessFlag(String processFlag) {
		this.processFlag = processFlag;
	}

	/**
	 * 得到撤销对象
	 */
	public GraphUndoManager getUndoManager() {
		return undo;
	}

	/**
	 * 重新设置撤销操作 Resets UndoManager.
	 */
	public void resetUndoManager() {
		undo.discardAllEdits();
		parentEditor.undoAction.update();
		parentEditor.redoAction.update();
	}

	/**
	 * 登录后，指定流程的编辑用户
	 */
	public void setLoginedUserForProcess() {
		// 编辑界面所编辑的流程对象
		Iterator wpCln = ((WorkflowProcesses) getGraph().getXMLPackage().get(
				"WorkflowProcesses")).toCollection().iterator();
		if (wpCln.hasNext()) {
			WorkflowProcess wp = (WorkflowProcess) wpCln.next();
			if (processFlag == null) {
				wp.setCreator(BPD.getInstance().getUserInfo());
			} else {
				wp.setModifier(BPD.getInstance().getUserInfo());
			}
		}
	}
}
