/* PackageEditor.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：主界面UI的展现抽象类的扩展类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 */

package com.ds.bpm.bpd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import com.ds.bpm.bpd.actions.*;
import com.ds.bpm.bpd.graph.BlockActivityEditor;
import com.ds.bpm.bpd.misc.PackageTreePanel;
import com.ds.bpm.bpd.misc.TextTreePanel;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.elements.ConformanceClass;
import com.ds.bpm.bpd.xml.elements.WFApplication;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.enums.process.ProcessDefAccess;

import org.jgraph.event.GraphSelectionEvent;

/**
 * PackageEditor class is the main class of application. It creates toolbars and
 * menubar as given in property file. It Implements GraphModel listener to
 * listen to changes of workflow model, GraphSelectionListener to listen to
 * selection changes in workflow, and is Observer to catch the changes in view
 * model of workflow. It also realizes Undo support.
 * <p>
 * All
 */

public class PackageEditor extends AbstractEditor {

	// private PackageGraph realGraph;
	private Map pkgIdToGraph;

	private Map processToProcessObject;

	private com.ds.bpm.bpd.xml.elements.Package realXMLPackage;

	private com.ds.bpm.bpd.xml.elements.Package xmlPackage;

	// indicates if an XML package doesn't have ID
	private boolean isInitialized = false;

	private PackageTreePanel packageTreePanel;

	private PackageTreePanel remotepackageTreePanel;


	private JPanel packrightPanel;


	private TextTreePanel textTreePanel;

	public PackageEditor() {
		super();
		
	}

	
	/*
	 * public boolean isPackageGraphCreated(String pkgId) { if (pkgIdToGraph ==
	 * null) { pkgIdToGraph = new Hashtable(); } return
	 * pkgIdToGraph.containsKey(pkgId); }
	 */

	public boolean isProcessObjectCreated(WorkflowProcess wp) {
		if (processToProcessObject == null) {
			processToProcessObject = new Hashtable();
		}
		return processToProcessObject.containsKey(wp);
	}

	/*
	 * public PackageGraph getPackageGraph(String pkgId) { if (pkgIdToGraph ==
	 * null) { pkgIdToGraph = new Hashtable(); } return (PackageGraph)
	 * pkgIdToGraph.get(pkgId); }
	 */

	/*
	 * public void putPackageGraphMapping(String pkgId, PackageGraph peg) { if
	 * (pkgIdToGraph == null) { pkgIdToGraph = new Hashtable(); }
	 * pkgIdToGraph.put(pkgId, peg); }
	 */

	public Map getPkgIdToGraphMap() {
		if (pkgIdToGraph == null) {
			pkgIdToGraph = new Hashtable();
		}
		return Collections.unmodifiableMap(pkgIdToGraph);
	}

	public void removePackageGraphMapping(String pkgId) {
		if (pkgIdToGraph == null) {
			pkgIdToGraph = new Hashtable();
		}
		pkgIdToGraph.remove(pkgId);
	}

	public void clearPackageGraphMap() {
		if (pkgIdToGraph == null) {
			pkgIdToGraph = new Hashtable();
		}
		pkgIdToGraph.clear();
	}

	public com.ds.bpm.bpd.graph.Process getProcessObject(
			WorkflowProcess wp) {
		if (processToProcessObject == null) {
			processToProcessObject = new Hashtable();
		}
		return (com.ds.bpm.bpd.graph.Process) processToProcessObject
				.get(wp);
	}

	public void putProcessObjectMapping(WorkflowProcess wp,
			com.ds.bpm.bpd.graph.Process pr) {
		if (processToProcessObject == null) {
			processToProcessObject = new Hashtable();
		}
		processToProcessObject.put(wp, pr);
	}

	public void removeProcessObjectMapping(WorkflowProcess wp) {
		if (processToProcessObject == null) {
			processToProcessObject = new Hashtable();
		}
		processToProcessObject.remove(wp);
	}

	public void clearProcessObjectMap() {
		if (processToProcessObject == null) {
			processToProcessObject = new Hashtable();
		}
		processToProcessObject.clear();
	}

	/**
	 * Create an editor to represent the given document.
	 */
	/*
	 * protected AbstractGraph createGraph() { realGraph = new PackageGraph(new
	 * BPDGraphModel(), this); return realGraph; }
	 */

	protected void createActions() {
		defaultActions = new Action[] {
		// Create File Menu Action
				new Login(this), new Logout(this), new New(this),
				new OpenLocal(this), new OpenRemote(this), new Save(this),
				new SaveAll(this), new SaveAs(this), new SaveToServer(this),
				new DeleteRemote(this), new ChangeLanguage(this),
				new Config(this), new Exit(this),

				// Create Process Menu Action
				// new com.ds.bpm.bpd.actions.Namespaces(this),
				new CheckValidity(this), new ChangeApplication(this),
				new Commission(this), new ProcessProperties(this),
				new ExternalPackages(this),
				 new ProcessRelevantProperties(this),
				// new UserDefinedProperties(this),
				new SaveAsJPG(this),
				new SaveAsSVG(this),

				// Create Edit Menu Action
				undoAction, redoAction, new Cut(this), new Copy(this),
				//ew Paste(this),
				new PasteAt(this), new DeleteCell(this),

				// Create View Menu Action
				new ActualSize(this), new ZoomIn(this), new ZoomOut(this),
				new ShowOverview(this), new ActivitySetsOverview(this),
				new ActivitiesOverview(this), new TransitionsOverview(this),

				// Create Help Menu Action
				new HelpTutorial(this), new DirectHelp(this),
				new HelpAbout(this),

				// Create Popup Menu Action
				new EditCell(this), new EditProperties(this),
				new AddPoint(this), new RemovePoint(this),
				new SetSelfRouting(this), new SetNoRouting(this),
				new Close(this), new CloseAll(this), new SelectAllCell(this) };
	}

	// *********************** GRAPH SELECTION LISTENER INTERFACE
	/** Enables and disables various actions depending of cell selection */
	public void valueChanged(GraphSelectionEvent e) {
		// enable/disable actions
		boolean enable = false;
		try {
			
			getAction(Utils.getUnqualifiedClassName(Login.class)).setEnabled(
					!BPD.getInstance().isLogined());
			getAction(Utils.getUnqualifiedClassName(Logout.class)).setEnabled(
					BPD.getInstance().isLogined());
			getAction(Utils.getUnqualifiedClassName(OpenRemote.class))
					.setEnabled(BPD.getInstance().isLogined());
			if (contentTabbedPane.getTabCount() > 0) {
				enable = true;
			}
			getAction(Utils.getUnqualifiedClassName(CheckValidity.class))
					.setEnabled(enable);
			boolean changeAppFlag = false;
			boolean commissionFlag = false;
			if (BPD.getInstance().getActivedProcessEditor() != null) {
				// 流程保存标志
				String processFlag = BPD.getInstance()
						.getActivedProcessEditor().getProcessFlag();
				commissionFlag = (processFlag != null)
						&& processFlag.equals(BPDConstants.PROCESS_REMOTE);
				WorkflowProcess wp = (WorkflowProcess) BPD
						.getInstance().getActivedProcessEditor().getGraph()
						.getPropertyObject();
				if (wp.getAppName().equals("")) {
					changeAppFlag = true;
				} else {
					changeAppFlag = false;
				}
			} else {
				changeAppFlag = false;
			}
			getAction(Utils.getUnqualifiedClassName(ChangeApplication.class))
					.setEnabled(changeAppFlag);
			getAction(Utils.getUnqualifiedClassName(Commission.class))
					.setEnabled(commissionFlag);
			getAction(Utils.getUnqualifiedClassName(ProcessProperties.class))
					.setEnabled(enable);
			// getAction(Utils.getUnqualifiedClassName(Applications.class)).setEnabled(enable);
			// getAction(Utils.getUnqualifiedClassName(ProcessRelevantProperties.class)).setEnabled(enable);
			// getAction(Utils.getUnqualifiedClassName(UserDefinedProperties.class)).setEnabled(enable);
			getAction(Utils.getUnqualifiedClassName(SaveAsJPG.class))
					.setEnabled(enable);

			getAction(Utils.getUnqualifiedClassName(ActualSize.class))
					.setEnabled(enable);
			getAction(Utils.getUnqualifiedClassName(ZoomIn.class)).setEnabled(
					enable);
			getAction(Utils.getUnqualifiedClassName(ZoomOut.class)).setEnabled(
					enable);
			getAction(Utils.getUnqualifiedClassName(ShowOverview.class))
					.setEnabled(enable);
			getAction(Utils.getUnqualifiedClassName(Close.class)).setEnabled(
					enable);
			getAction(Utils.getUnqualifiedClassName(SaveAll.class)).setEnabled(
					false);
			getAction(Utils.getUnqualifiedClassName(CloseAll.class))
					.setEnabled(false);
			undoAction.setEnabled(enable);
			redoAction.setEnabled(enable);
			getAction(Utils.getUnqualifiedClassName(Save.class)).setEnabled(
					enable);
			getAction(Utils.getUnqualifiedClassName(SaveAs.class)).setEnabled(
					enable);
			// 当打开两个以上流程时，“保存所有流程”和“关闭所有流程”才可用
			
			if (contentTabbedPane.getTabCount() > 1) {
				getAction(Utils.getUnqualifiedClassName(SaveAll.class))
						.setEnabled(enable);
				getAction(Utils.getUnqualifiedClassName(CloseAll.class))
						.setEnabled(enable);
				if ((BPD.getInstance().getActivedProcessEditor() instanceof BlockActivityEditor)) {
					getAction(Utils.getUnqualifiedClassName(SaveAll.class))
							.setEnabled(false);
					getAction(Utils.getUnqualifiedClassName(CloseAll.class))
							.setEnabled(false);
					getAction(Utils.getUnqualifiedClassName(Save.class))
							.setEnabled(false);
					getAction(Utils.getUnqualifiedClassName(SaveAs.class))
					.setEnabled(false);
					return;
				}
				if (BPD.getInstance().getActivedProcessEditor() instanceof ProcessEditor) {
					WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
							.getActivedProcessEditor().getGraph()
							.getPropertyObject();
					if (wp.isSubFlow()) {
						getAction(Utils.getUnqualifiedClassName(SaveAll.class))
								.setEnabled(false);
						getAction(Utils.getUnqualifiedClassName(CloseAll.class))
								.setEnabled(false);
						getAction(Utils.getUnqualifiedClassName(Save.class))
								.setEnabled(false);
						getAction(Utils.getUnqualifiedClassName(SaveAs.class))
								.setEnabled(false);
					}
				}
			}

			// 当前一个流程都没打开时，图形元素编辑操作为不可用
			if (contentTabbedPane.getTabCount() == 0) {
				getAction(Utils.getUnqualifiedClassName(Cut.class)).setEnabled(
						enable);
				getAction(Utils.getUnqualifiedClassName(Copy.class))
						.setEnabled(enable);
				getAction(Utils.getUnqualifiedClassName(PasteAt.class))
						.setEnabled(enable);
				getAction(Utils.getUnqualifiedClassName(DeleteCell.class))
						.setEnabled(enable);
				getAction(Utils.getUnqualifiedClassName(SaveAs.class))
				.setEnabled(false);
			}

			

		} catch (Exception ex) {
			ex.printStackTrace();
		}
		try {
			String fileName = null;
			if (BPD.getInstance().getActivedProcessEditor() != null
					&& BPD.getInstance().getActivedProcessEditor()
							.getProcessFlag() != null
					&& BPD.getInstance().getActivedProcessEditor()
							.getProcessFlag()
							.equals(BPDConstants.PROCESS_LOCAL)) {
				String versionId = ((WorkflowProcess) BPD.getInstance()
						.getActivedProcessEditor().getGraph().getXPDLObject())
						.getVersionID();
				fileName = (String) BPD.getInstance().getXpdlFilePathMap().get(
						versionId);
				// XML.getAbsoluteFilePath(BPD.getInstance().getActivedProcessEditor().getGraph().getXMLPackage());
			} else {
				fileName = null;
			}
			BPD.getInstance().setFilename(fileName);
			update();

			// 刷新流程列表
			if (packageTreePanel!=null){
				 packageTreePanel.refreshPackageTreePanel();
			}
			if (this.remotepackageTreePanel!=null){
				remotepackageTreePanel.refreshPackageTreePanel();
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	// ******************* END OF GRAPH SELECTION LISTENER INTERFACE
	// ***************

	/**
	 * Gets a XML package object currently viewed within editor's graph.
	 */
	public com.ds.bpm.bpd.xml.elements.Package getXMLPackage() {
		 //return graph.getXMLPackage();
		if (xmlPackage==null){
			xmlPackage=this.getRealXMLPackage();
		}
		return xmlPackage;
	}

	/**
	 * Sets a XML package object
	 */
	public void setXMLPackage(
			com.ds.bpm.bpd.xml.elements.Package xmlPackage) {
		this.xmlPackage = xmlPackage;
	}

	/**
	 * Gets a real XML package object (the one of the main XML file).
	 */
	public com.ds.bpm.bpd.xml.elements.Package getRealXMLPackage() {
		return realXMLPackage;
	}

	public void enterPackageID() {
		String msg = ResourceManager
				.getLanguageDependentString("InformationNotAllowedToDoEnythingBeforeEnteringPackageID");
		BPD.getInstance().message(msg, JOptionPane.INFORMATION_MESSAGE);
		XMLElement ID = realXMLPackage.get("Id");
		ID.setReadOnly(false);

		// setting mandatory conformance class if it is specified and it exists
		String mcl = BPD.getInstance().getMandatoryConformanceClass();
		int mct = XMLUtil.getConformanceClassNo(mcl);
		if (mct > 0) {
			ConformanceClass cc = (ConformanceClass) getXMLPackage().get(
					"ConformanceClass");
			// cc.set("GraphConformance",ResourceManager.getLanguageDependentString(mcl+"Key"));
			cc.set("GraphConformance", ResourceManager
					.getLanguageDependentString("FULL_BLOCKEDKey"));
			cc.setReadOnly(true);
		}
		XMLPanel p = getXMLPackage().getPanel(1);
		String message;
		XMLElementDialog d = new XMLElementDialog((JFrame) getWindow(),
				ResourceManager.getLanguageDependentString("PackageKey")
						+ " '"
						+ getXMLPackage().get("Id").toString()
						+ "' - "
						+ ResourceManager
								.getLanguageDependentString("PropertiesKey"));
		d.editXMLElement(p, false, true);
		getXMLPackage().setIDPrefixForCollections();
		ID.setReadOnly(true);
		isInitialized = true;
		BPD.getInstance().getXMLInterface().register(realXMLPackage);

		// now, put an instance of PE to hashtable
		// putPackageGraphMapping(ID.toString(), (PackageGraph) graph);

		// getToolbarComponent(BPDConstants.PROCESS_ACTIVITY_TOOL).setEnabled(true);

		super.leftSplitPane.remove(packageTreePanel);
		super.leftSplitPane.setRightComponent(packageTreePanel);

		// displayPackage(realXMLPackage);

		update();
	}

	/*
	 * public void displayPackage(com.ds.bpm.bpd.xml.elements.Package pkg) {
	 * graph.getSelectionModel().removeGraphSelectionListener(this); graph =
	 * getPackageGraph(pkg.get("Id").toString()); if (graph == null ||
	 * getXMLPackage() != pkg) { graph = realGraph; }
	 * graph.refreshGraphConfiguration();
	 * graph.getSelectionModel().addGraphSelectionListener(this);
	 * getAction(Utils.getUnqualifiedClassName(ImportExternalProcess.class)).setEnabled(graph ==
	 * realGraph);
	 * //getAction(Utils.getUnqualifiedClassName(ImportExternalParticipants.class)).setEnabled(graph==realGraph);
	 * graphScrollPane.setViewportView(graph); valueChanged(null);
	 * statusBar.updateMessage(); }
	 */

	/**
	 * Indicates whether the package is under test or not.
	 * 
	 * @return <tt>true</tt> if package is under test, <tt>false</tt>
	 *         otherwise.
	 */
	public boolean isUnderTest() {
		// boolean isUnderTest = true;
		// RedefinableHeader rh = (RedefinableHeader)
		// getXMLPackage().get("RedefinableHeader");
		// String pStatus = rh.get("PublicationStatus").toValue().toString();
		// if (!pStatus.equals("UNDER_TEST")) {
		// isUnderTest = false;
		// }
		// return isUnderTest;
		return true;
	}

	/**
	 * Shows the specified process. If nothing is specified, creates the new
	 * process.
	 */
	public WorkflowProcess showProcess(WorkflowProcess wp, String processID) {
		return showProcess(wp,processID,null);
	}
	public WorkflowProcess showProcess(WorkflowProcess wp, String processID,String attrSystemCode) {
		com.ds.bpm.bpd.graph.Process pr;
		if (wp == null) {
			
			WFApplication wfApp = new WFApplication();
			wfApp.set("AccessLevel",ProcessDefAccess.Private.getType());
			if (attrSystemCode==null){
				WorkflowProcess cwp = (WorkflowProcess) BPD.getInstance()
						.getActivedProcessEditor().getGraph()
						.getPropertyObject();
				attrSystemCode = cwp.getSystemCode();
			}
			wfApp.set("SystemCode",attrSystemCode);
			
			
			
			pr = (new WorkflowManager(null, this)).newSubProcess(wfApp,processID);
			
			wp = (WorkflowProcess) pr.getUserObject();	
		  
			if (createWorkflowProcess(wp)){			
			putProcessObjectMapping(wp, pr);
			pr.showProcess();
			// 当前工作流的图形界面与图形按钮进行绑定
			ProcessGraph processGraph = (ProcessGraph) pr
					.getImplementationEditor().getGraph();
			processGraph.setMarqueeHandler(new BPDMarqueeHandler(processGraph));
			BPD.getInstance().setActivedProcessEditor(pr.getProcessEditor());
			// 创建缺省的画图背景
			processGraph
					.getWorkflowManager()
					.insertParticipantAndArrangeParticipants(
							new Point(processGraph.getX(), processGraph.getY()),
							null);
			}
		} else {
			pr = getProcessObject(wp);
			ProcessEditor pe = pr.getImplementationEditor();
			pe.refreshEditorConfiguration();
			if (wp.getPackage() != realXMLPackage
					|| wp.getPackage().isReadOnly()) {
				pe.setButtonsEnabled(false);
			}
			pr.showProcess();
			// 当前工作流的图形界面与图形按钮进行绑定
			ProcessGraph processGraph = (ProcessGraph) pr
					.getImplementationEditor().getGraph();
			processGraph.setMarqueeHandler(new BPDMarqueeHandler(processGraph));
			BPD.getInstance().setActivedProcessEditor(pr.getProcessEditor());
		}
		return wp;
	}

	/**
	 * Gets a title.
	 */
	public String getTitle() {
		String title = ResourceManager.getLanguageDependentString("Title")
				+ " - ";
		if (BPD.getInstance().getFilename() != null) {
			title += BPD.getInstance().getFilename();
		} else {
			if (BPD.getInstance().getActivedProcessEditor() == null
					|| BPD.getInstance().getActivedProcessEditor()
							.getProcessFlag() == null) {
				title += ResourceManager
						.getLanguageDependentString("Sys.Unnamed");
			} else {
				title += BPD.getInstance().getActivedProcessEditor()
						.getProcessTitle();
			}
		}
		if (BPD.getInstance().getActivedProcessEditor() != null) {
			if (BPD.getInstance().getActivedProcessEditor()
					.getProcessModified()) {
				title += "*";
			}
		}
		return title;
	}

	/**
	 * Returns string of toolbars for load.
	 */
	public String toolbarToLoad() {
		return "Toolbars";
	}

	/**
	 * Returns string of buttongroup for load.
	 */
	public String buttongroupToLoad() {
		return "ProcessToolBox";
	}

	public String graphbars() {
		return "Graphbars";
	}

	/**
	 * Returns string of menubar for load.
	 */
	public String menubarToLoad() {
		return "Menubar";
	}

	/**
	 * Used to open new document when some other document is beeing edited
	 * (called from New and OpenLocal actions).
	 */
	public void setNewPackage(com.ds.bpm.bpd.xml.elements.Package pkg,
			boolean clearOtherPackages) {
		if (clearOtherPackages) {
			clearPackageGraphMap();
			// clearProcessObjectMap();
		}
		/*
		 * if (pkg != null) { putPackageGraphMapping(pkg.get("Id").toString(),
		 * (PackageGraph) graph); }
		 */
		realXMLPackage = pkg;
		//this.xmlPackage=pkg;

		/*
		 * graph.setPropertyObject(pkg); // set graph graph.clearSelection();
		 * graph.paintImmediately(graph.getBounds());
		 * graph.getModel().removeGraphModelListener(this);
		 * graph.getModel().removeUndoableEditListener(undoHandler);
		 * graph.setModel(new BPDGraphModel());
		 */

		// disable ccp,..
		valueChanged(null);
		// The !clearOtherPackages is checked, and if it is false, we consider
		// that the package was opened through the network, so we allow
		// creation of graphs (this is the case of using BPD within our
		// workflow admin. application)
		if (BPD.getInstance().getFilename() != null
				&& (new File(BPD.getInstance().getFilename()).exists() || !clearOtherPackages)) {
			isInitialized = true;
			// Window w = getWindow();
			// graph.createWorkflowGraph(w);
			// Create graphs for all external packages
			// createGraphsForExternalPackages(realXMLPackage);
		} else {
			isInitialized = false;
		}

		/*
		 * if (super.splitPane != null) {
		 * super.splitPane.remove(packageTreePanel); packageTreePanel = new
		 * PackageTreePanel(this,
		 * ResourceManager.getLanguageDependentString("PackageTreePanel.Name.display"),
		 * false); super.splitPane.setRightComponent(packageTreePanel); }
		 */

		/*
		 * try { displayPackage(realXMLPackage); } catch (Exception ex) { }
		 */

		// BPD.getInstance().setModified(false);
		/*
		 * graph.getModel().addGraphModelListener(this);
		 * graph.getModel().addUndoableEditListener(undoHandler);
		 */

		/*
		 * if (BPD.getInstance().getActivedProcessEditor() != null) {
		 * resetUndoManager(); }
		 */

		try {
			getWindow().requestFocus();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * Creates the graph for all external packages of given package. This also
	 * creates the graphs for all processes contained in these external
	 * packages.
	 */
	/*
	 * public void createGraphsForExternalPackages(
	 * com.ds.bpm.bpd.xml.elements.Package pkg) { Set ems =
	 * pkg.getAllExternalPackages(); com.ds.bpm.bpd.xml.elements.Package
	 * ep; Iterator it = ems.iterator(); while (it.hasNext()) { ep =
	 * (com.ds.bpm.bpd.xml.elements.Package) it.next();
	 * createGraphForPackage(ep, true); } }
	 */

	/**
	 * Creates the graph for the model and all of it's processes.
	 */
	/*
	 * public void createGraphForPackage(
	 * com.ds.bpm.bpd.xml.elements.Package pkg, boolean isReadOnly) {
	 * Window w = getWindow(); if
	 * (!isPackageGraphCreated(pkg.get("Id").toString())) { // THE POSTION OF
	 * THE NEXT LINE CHANGED 19.02.03 - IMPORTANT // FOR EXTERNAL PACKAGES -
	 * WORKFLOW MANAGER DOESN'T ADD THE // GRAPH REFERENCES TO THE PARTICIPANTS
	 * THAT ARE DISPLAYED // WITHIN READ-ONLY PACKAGE, SO THIS LINE MUST COME
	 * FIRST pkg.setReadOnly(isReadOnly); PackageGraph peg = new
	 * PackageGraph(new BPDGraphModel(), this); // registers graph's tooltip
	 * listener ToolTipManager.sharedInstance().registerComponent(peg);
	 * peg.setPropertyObject(pkg); peg.setAdditionalKeyboardShortcuts();
	 * peg.createWorkflowGraph(w);
	 * //putPackageGraphMapping(pkg.get("Id").toString(), peg); } }
	 */
	
	
	
	

	/**
	 * 子主面板分为左、中、右三部分，此方法是创建子主面板的右边组件，
	 * 重载AbstractEditor的createRightComponent()的方法 Create the right of component
	 * of this submainpanel. add by wenzhang 将列表分为本地流程和远程流程两个选项
	 */

	protected Component createLeftComponent() {
		// creating the process tree panel of rightpanel 添加的右边面板为流程树形式
		this.packrightPanel = new JPanel();		
		MainLeftDownPanel mldp=MainLeftDownPanel.getInstance(this);
		mldp.refreshView();		
		packrightPanel.add(mldp, BorderLayout.CENTER);
		return mldp;
	}

	/**
	 * 新建一个新流程时，添加一个TabbedPane
	 * 
	 * @param processEditor
	 *            工作流图形界面
	 */
	public void addProcessToTabbedPane(String title, ProcessEditor processEditor) {
		// 工作流图标
		URL url = ResourceManager.getResource("ProcessTabbedPane"
				+ BPDConstants.IMAGE_SUFFIX);
		contentTabbedPane.addTab(title, new ImageIcon(url), processEditor);
		contentTabbedPane.setFont(BPDConfig.getInstance().getFont());
		contentTabbedPane.setSelectedComponent(processEditor);

		// 将新创建的流程，设为当前激活的流程
		BPD.getInstance().setActivedProcessEditor(processEditor);
		
	}

	// ---------------------The below code was written by

	/**
	 * 创建一个新的流程，展示流程基本属性页面
	 */
	public boolean createWorkflowProcess(WorkflowProcess wp) {
		XMLPanel p = wp.getPanel();
		String wpLabelName = ResourceManager
				.getLanguageDependentString("Sys.Unnamed");
		XMLElementDialog d = new XMLElementDialog((JFrame) getWindow(),
				ResourceManager.getLanguageDependentString("ProcessKey")
						+ " \""
						+ wpLabelName
						+ "\" - "
						+ ResourceManager
								.getLanguageDependentString("PropertiesKey"),false);
		d.editXMLElement(p, true, false);
		
		initialize();
		return !d.isCanceled();
	}

	/**
	 * 初始化Package
	 */
	public void initialize() {
		this.isInitialized = true;
	}
	 /**
	    * Creates the graph for the model and all of it's processes.
	    */

	protected AbstractGraph createGraph() {
		this.graph=new PackageGraph(null,this);
		return graph;
	}


	public boolean isInitialized() {
		
		return this.isInitialized;
	}
	  

	

	// ---------------------The above code was written by
	// Huchm-------------------

}
