package com.ds.bpm.bpd;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

import com.ds.bpm.bpd.wfxml.DefInfos;
import com.ds.bpm.bpd.wfxml.WfXMLControlPanel;
import com.ds.bpm.bpd.wfxml.WfXMLPanel;
import com.ds.bpm.bpd.xml.panels.ErrTablePanel;
import com.ds.bpm.bpd.xml.panels.NewXMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.NewXMLPanel;
import com.ds.bpm.bpd.xml.panels.TabbedPanel;

public class MainCenterDownPanel extends JPanel {

	private AbstractEditor editor;

	private ErrTablePanel errTablePanel;

	private static MainCenterDownPanel mcdp;

	public JTabbedPane mainDownTaBedPanel;

	private XPDLPreview xpdlPanel;

	private TextPreview textPreview;

	public static MainCenterDownPanel getInstance(AbstractEditor editor) {
		
		if (mcdp == null || editor==null) {
			mcdp = new MainCenterDownPanel(editor);
		}
		
		return mcdp;
	}

	public void refreshView() {
	
		if (errTablePanel==null||errTablePanel.getProcessEditor()==null
				||BPD.getInstance().getActivedProcessEditor()==null
				){
		    mainDownTaBedPanel.remove(errTablePanel);
			errTablePanel=this.getNewErrTablePanel();	
			
		try{	
		init();
		}catch(Exception e){
			
		}
		}else{
			errTablePanel=this.getErrTablePanel();
			errTablePanel.refreshView();		
			errTablePanel.repaint();
			init();
		}
		if (mainDownTaBedPanel.getSelectedComponent().equals(xpdlPanel)){
			xpdlPanel.refreshView();		
		}
		if (mainDownTaBedPanel.getSelectedComponent().equals(textPreview)){
			textPreview.refreshView();
		}
	
	}
	public void closeView(){
		
	}


	public MainCenterDownPanel(AbstractEditor editor) {
		this.editor = editor;
		this.setLayout(new BorderLayout());
		this.setMinimumSize(new Dimension(50, 100));
	
		this.mainDownTaBedPanel = new TabbedPanel(JTabbedPane.TOP);
		mainDownTaBedPanel.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent ev) {
				if (ev.getClickCount()>1 && !SwingUtilities.isRightMouseButton(ev)){
					if (BPD.getInstance().getPackageEditor().leftSplitPane.getLeftComponent().isShowing()){
						BPD.getInstance().getPackageEditor().leftSplitPane.getLeftComponent().hide();
						}else {
							BPD.getInstance().getPackageEditor().leftSplitPane.getLeftComponent().show(true);
							//MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).refreshOverview();
						}
					if (BPD.getInstance().getPackageEditor().graphMainsplitPane.getTopComponent().isShowing()){
					BPD.getInstance().getPackageEditor().graphMainsplitPane.getTopComponent().hide();
					}else {
						BPD.getInstance().getPackageEditor().graphMainsplitPane.getTopComponent().show(true);						
					}			
					
					MainLeftDownPanel mldp=MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor());
					mldp.refreshView();		
					BPD.getInstance().getPackageEditor().leftSplitPane.setLeftComponent(mldp);
					
					MainCenterDownPanel mcdp=(MainCenterDownPanel.getInstance(BPD.getInstance().getPackageEditor()));
					mcdp.refreshView();
					BPD.getInstance().getPackageEditor().graphMainsplitPane.setBottomComponent(mcdp);
						BPD.getInstance().getPackageEditor().refreshEditorConfiguration();					
				}
			}
		});
		init();
	}

	private void init() {
		mainDownTaBedPanel
		.add(
				ResourceManager
						.getLanguageDependentString("MainCenterDownPanel.TextPreview.TableName.display"),
				this.getNewTextPreviewPanel());		
	
				
				mainDownTaBedPanel
				.add(
						ResourceManager
								.getLanguageDependentString("MainCenterDownPanel.ErrTablePanel.TableName.display"),
						this.getNewErrTablePanel());
				mainDownTaBedPanel
				.add(
						ResourceManager
								.getLanguageDependentString("MainCenterDownPanel.XPDLPreview.TableName.display"),
						this.getNewXPDLPanel());
				
				//mainDownTaBedPanel.add("编辑器",JDSEditor.getInstance().getEditor());
				
		this.add(mainDownTaBedPanel);
		
		
	}

	public ErrTablePanel getNewErrTablePanel() {
		//if (this.errTablePanel==null){
		errTablePanel =ErrTablePanel.getInstance();		
		
		//errTablePanel.refreshView();
		//};
		return this.errTablePanel;
	}
	public ErrTablePanel getErrTablePanel() {
		if (this.errTablePanel==null){		
		errTablePanel = ErrTablePanel.getInstance();			
		};
		return this.errTablePanel;
	}
	
	

	public JPanel getNewXPDLPanel() {
		this.xpdlPanel = XPDLPreview.getInstance(editor);
		xpdlPanel.refreshView();
		return xpdlPanel;
	}

	public JPanel getXPDLPanel() {
		if (xpdlPanel==null){
		this.xpdlPanel = XPDLPreview.getInstance(editor);
		}
		return xpdlPanel;
	}
	
	public TextPreview getNewTextPreviewPanel() {		
		this.textPreview = TextPreview.getInstance(editor);	
		return textPreview;
	}

	public JPanel getTextPreviewPanel() {
		if (textPreview==null){
		this.textPreview = TextPreview.getInstance(editor);
		}
		return textPreview;
	}


	public JPanel getProperty() {
		JPanel packPanel = new JPanel();
		DefInfos dis = new DefInfos();
		String t = ("ProcessDefinitionListKey");
		dis.setLabelName(t);
		WfXMLPanel p1 = new WfXMLPanel(dis);
		WfXMLControlPanel p2 = new WfXMLControlPanel(dis, p1, "", false, false);
		NewXMLGroupPanel gp = new NewXMLGroupPanel(dis, new NewXMLPanel[] { p1,
				p2 }, "", NewXMLPanel.BOX_LAYOUT, true, false);
		packPanel.add(gp);
		return packPanel;
	}

}
