/* BPD.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：主界面状态栏构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import com.ds.bpm.bpd.graph.BlockActivityEditor;
import com.ds.common.JDSException;
import com.ds.config.UserBean;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.context.MinServerActionContextImpl;
import com.ds.engine.ConnectInfo;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.org.Person;
import com.ds.org.PersonNotFoundException;
import com.ds.server.JDSClientService;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;

import javax.swing.*;
import java.awt.*;


/**
 * Status bar to show the information of graphs (in)validity.
 */
public class BPDStatusBar extends JPanel {

    private AbstractEditor editor;

    private JLabel message;

    public BPDStatusBar(AbstractEditor editor) {
        super();
        this.editor = editor;
        setLayout(new BorderLayout());
        message = new JLabel("  ");
        message.setBorder(BorderFactory.createLoweredBevelBorder());
        add(message, BorderLayout.CENTER);
    }

    public void updateMessage() {


        BPD.getInstance().fillUser();

        ((MainLeftDownPanel) MainLeftDownPanel.getInstance(editor)).refreshView();

        ((MainCenterDownPanel) editor.graphMainsplitPane.getBottomComponent()).refreshView();

        if (!BPDConfig.getInstance().getStatusBarStatus()) {
            return;
        }
        if (!BPDConfig.getInstance().getValidationStatus()) {
            message
                    .setText(ResourceManager
                            .getLanguageDependentString("MessageValidationIsTurnedOff"));
            return;
        }
        if (BPD.getInstance().getActivedProcessEditor() != null) {
            boolean isSchemaValidationError = !BPD.getInstance()
                    .getActivedProcessEditor().getGraph()
                    .validateAgainsXPDLSchema();
            boolean isConnectionError = false;
            boolean isGraphConformanceError = false;
            boolean isLogicError = false;
            if (!isSchemaValidationError) {
                isConnectionError = !BPD.getInstance()
                        .getActivedProcessEditor().getGraph().checkConnections(
                                false);
            }
            if (!isConnectionError) {
                isGraphConformanceError = !BPD.getInstance()
                        .getActivedProcessEditor().getGraph()
                        .checkGraphConformance(false);
            }
            if (!(isConnectionError || isGraphConformanceError)) {
                isLogicError = !BPD.getInstance().getActivedProcessEditor()
                        .getGraph().checkLogic(false);
            }
            boolean isModelOK = !(isSchemaValidationError || isConnectionError
                    || isGraphConformanceError || isLogicError);
            String msg = "";
            /*
             * if (editor instanceof PackageEditor) { if (isModelOK) {
             * msg=ResourceManager.getLanguageDependentString("InformationPackageIsValid"); }
             * else { if (isSchemaValidationError) {
             * msg=BPD.getInstance().getActivedProcessEditor().getGraph().getBasicXPDLSchemaValidationErrorMessage(); }
             * else if (isConnectionError) {
             * msg=BPD.getInstance().getActivedProcessEditor().getGraph().getBasicConnectionErrorMessage(); }
             * else if (isGraphConformanceError) {
             * msg=BPD.getInstance().getActivedProcessEditor().getGraph().getBasicGraphConformanceErrorMessages().get(0).toString();
             * if (msg.length()==0) { msg="SWR1"; } } else {
             * msg=BPD.getInstance().getActivedProcessEditor().getGraph().getBasicLogicErrorMessage(); } } }
             * else {
             */
            if (isModelOK) {
                if (BPD.getInstance().getActivedProcessEditor() instanceof BlockActivityEditor) {
                    msg = ResourceManager
                            .getLanguageDependentString("InformationBlockIsValid");
                } else {
                    msg = ResourceManager
                            .getLanguageDependentString("InformationProcessIsValid");
                }
            } else {
                if (isSchemaValidationError) {
                    msg = BPD.getInstance().getActivedProcessEditor()
                            .getGraph()
                            .getBasicXPDLSchemaValidationErrorMessage();
                } else if (isConnectionError) {
                    msg = BPD.getInstance().getActivedProcessEditor()
                            .getGraph().getBasicConnectionErrorMessage();
                } else if (isGraphConformanceError) {
                    msg = BPD.getInstance().getActivedProcessEditor()
                            .getGraph().getBasicGraphConformanceErrorMessages()
                            .get(0).toString();
                    if (msg.length() == 0) {
                        msg = "SWR2";
                    }
                } else {
                    msg = BPD.getInstance().getActivedProcessEditor()
                            .getGraph().getBasicLogicErrorMessage();
                }
            }
            // }
            message.setText(msg);
        }
    }

    /**
     * Returns the statusbar message.
     */
    public String getMessage() {
        return message.getText();
    }

    /**
     * Sets the statusbar message.
     */
    public void setMessage(String message) {
        this.message.setText(message);
    }
}
