/* PEMarqueeHandler.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：JGraph图形BasicMarqueeHandler扩展类，图形按钮操作定义
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */
package com.ds.bpm.bpd;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

import com.ds.bpm.bpd.actions.AddPoint;
import com.ds.bpm.bpd.actions.Copy;
import com.ds.bpm.bpd.actions.Cut;
import com.ds.bpm.bpd.actions.DeleteCell;
import com.ds.bpm.bpd.actions.EditCell;
import com.ds.bpm.bpd.actions.EditProperties;
import com.ds.bpm.bpd.actions.PasteAt;
import com.ds.bpm.bpd.actions.ProcessProperties;
import com.ds.bpm.bpd.actions.RemovePoint;
import com.ds.bpm.bpd.actions.SelectAllCell;
import com.ds.bpm.bpd.actions.SetNoRouting;
import com.ds.bpm.bpd.actions.SetSelfRouting;
import com.ds.bpm.bpd.graph.Activity;
import com.ds.bpm.bpd.graph.BlockActivity;
import com.ds.bpm.bpd.graph.End;
import com.ds.bpm.bpd.graph.Linkable;
import com.ds.bpm.bpd.graph.Outflow;
import com.ds.bpm.bpd.graph.OutflowRenderer;
import com.ds.bpm.bpd.graph.Participant;
import com.ds.bpm.bpd.graph.ParticipantView;
import com.ds.bpm.bpd.graph.Start;
import com.ds.bpm.bpd.graph.Subflow;
import com.ds.bpm.bpd.graph.Transition;

import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

// import java.io.*;
/**
 * Implementation of a marquee handler for Process Editor. This is also a place
 * where (after mouse click or release) participants, activities (normal,
 * subflows, block activities) and transitions are inserted, where persistent
 * mode is achived and where mouse cursors are changing, and where popup menubar is
 * implemented. When inserting cells it calls WorkflowManager.
 */
public class BPDMarqueeHandler extends BasicMarqueeHandler { // implements
	// Serializable
	// {
	/** JGraph reference */
	private transient AbstractGraph graph = null;

	/** Editor reference */
	private transient AbstractEditor ED = null;

	private transient ProcessEditor processEditor = null;

	/** WorkflowManager reference */
	private transient WorkflowManager workflowManager = null;

	/** Signifies the persistent mode. */
	private boolean persistent = false;

	/** Button for selecting. */
	private transient JToggleButton selectButton;

	/** Button for inserting process activity. */
	private transient JToggleButton processButton = new JToggleButton();

	/** Button for inserting participant. */
	// private transient JToggleButton participantButton;
	/** Button for inserting subflow activity. */
	private transient JToggleButton subflowActivityButton;

	private transient JToggleButton outflowActivityButton;

	/** Button for inserting block activity. */
	private transient JToggleButton blockActivityButton;

	/** Button for inserting start. */
	private transient JToggleButton startButton;

	/** Button for inserting end. */
	private transient JToggleButton endButton;

	/** Button for inserting manual activity. */
	private transient JToggleButton manualActivityButton;

	/** Button for inserting auto activity. */
	private transient JToggleButton autoActivityButton;
	
	private transient JToggleButton serviceActivityButton;
	
	private transient JToggleButton eventActivityButton;
	
	
	private transient JToggleButton deviceActivityButton;


	/** Button for inserting transition. */
	private transient JToggleButton transitionButton;

	/** Button for inserting selfRoutedTransition. */
	private transient JToggleButton selfRoutedTransitionButton;

	// cursors
	/** Mouse cursor for participant */
	// private transient Cursor participantCursor;
	/** Mouse cursor for process activity */
	private transient Cursor processCursor;

	/** Mouse cursor for subflow activity */
	private transient Cursor subflowActivityCursor;

	private transient Cursor outflowActivityCursor;

	/** Mouse cursor for block activity */
	private transient Cursor blockActivityCursor;

	/** Mouse cursor for start. */
	private transient Cursor startCursor;

	/** Mouse cursor for end. */
	private transient Cursor endCursor;

	/** Mouse cursor for manual activity */
	private transient Cursor manualActivityCursor;

	/** Mouse cursor for auto activity */
	private transient Cursor autoActivityCursor;
	
	/** Mouse cursor for service activity */
	private transient Cursor serviceActivityCursor;
	

	/** Mouse cursor for service activity */
	private transient Cursor deviceActivityCursor;


	/** Mouse cursor for service activity */
	private transient Cursor eventActivityCursor;

	/** Mouse cursor for transition */
	private transient Cursor transitionCursor;

	/** Mouse cursor for selfRoutedTransition */
	private transient Cursor selfRoutedTransitionCursor;

	/** Mouse listener (implements persistent mode). */
	private transient ML ml = new ML();

	/** Activity listener (implements mouse cursor change). */
	private transient AL al = new AL();

	/** Key listener (implements mouse cursor change). */
	private transient KL kl = new KL();

	/** Starting point (where mouse was pressed). */
	protected Point start;

	/** Current point (where mouse was dragged). */
	protected Point current;

	/** Current port (when mouse was pressed). */
	protected PortView port;

	/** First port (when mouse was pressed). */
	protected PortView firstPort;

	/** Last port (when mouse was draged). */
	protected PortView lastPort;

	/** A point where popup window has been created last time. */
	protected Point popupPoint;

	/** mouse listener to achieve persistent mode if button is doubleclicked. */
	class ML extends MouseAdapter { // implements Serializable {
		public void mousePressed(MouseEvent ev) {
			if (ev.getClickCount() == 2) {
				persistent = true;
			} else {
				persistent = false;
			}
		}
	}

	/** Key listener to achieve persistent mode if Key is pressed. */
	class KL extends KeyAdapter { // implements Serializable {
		public void keyPressed(KeyEvent ke) {
			if (KeyEvent.getKeyText(ke.getKeyCode()).equals("Alt")) {
				persistent = true;
			}
		}

		public void keyReleased(KeyEvent ke) {
			if (KeyEvent.getKeyText(ke.getKeyCode()).equals("Alt")) {
				persistent = false;
				selectButton.doClick();
			}
		}
	}

	/** Action listener for changing cursors. */
	class AL implements ActionListener { // , Serializable {
		public void actionPerformed(ActionEvent ev) {
			JToggleButton source = (JToggleButton) ev.getSource();
			/*
			 * if (source.equals(participantButton)) {
			 * graph.setCursor(participantCursor); }
			 */
			/*
			 * else if (source.equals(processButton)) {
			 * graph.setCursor(processCursor); }
			 */
			if (source.equals(outflowActivityButton)) {
				graph.setCursor(outflowActivityCursor);
			} else if (source.equals(subflowActivityButton)) {
				graph.setCursor(subflowActivityCursor);
			} else if (source.equals(blockActivityButton)) {
				graph.setCursor(blockActivityCursor);
			} else if (source.equals(startButton)) {
				graph.setCursor(startCursor);
			} else if (source.equals(endButton)) {
				graph.setCursor(endCursor);
			} else if (source.equals(manualActivityButton)) {
				graph.setCursor(manualActivityCursor);
			} else if (source.equals(autoActivityButton)) {
				graph.setCursor(autoActivityCursor);
			} else if (source.equals(serviceActivityButton)) {
				graph.setCursor(serviceActivityCursor);
			} else if (source.equals(deviceActivityButton)) {
				graph.setCursor(deviceActivityCursor);
			} else if (source.equals(eventActivityButton)) {
				graph.setCursor(eventActivityCursor);
			} else if (source.equals(transitionButton)) {
				graph.setCursor(transitionCursor);
			} else if (source.equals(selfRoutedTransitionButton)) {
				graph.setCursor(selfRoutedTransitionCursor);

			} else if (source.equals(processButton)) {
				graph.setCursor(processCursor);

			} else {
				graph.setCursor(Cursor.getDefaultCursor());
			}
		}
	}

	/**
	 * Creates custom marquee handler.
	 */
	public BPDMarqueeHandler(AbstractGraph graph) {
		// setting PEGraph reference
		this.graph = graph;
		// getting editor reference
		ED = graph.getEditor();
		// getting processEditor reference
		processEditor = graph.getProcessEditor();
		// setting workflowManager reference
		workflowManager = graph.getWorkflowManager();
		selectButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.SELECT_TOOL);
		// participantButton =
		// (JToggleButton)ED.getSpecialButtonGroup().get(BPDConstants.PARTICIPANT_TOOL);
		subflowActivityButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.SUBFLOW_ACTIVITY_TOOL);
		outflowActivityButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.OUTFLOW_ACTIVITY_TOOL);
		blockActivityButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.BLOCK_ACTIVITY_TOOL);
		startButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.START_TOOL);
		endButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.END_TOOL);
		manualActivityButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.MANUAL_ACTIVITY_TOOL);
		autoActivityButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.AUTO_ACTIVITY_TOOL);
		serviceActivityButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.AUTO_ACTIVITY_SERVICE);
		deviceActivityButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.AUTO_ACTIVITY_DEVICE);
		eventActivityButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.AUTO_ACTIVITY_EVENT);
		transitionButton = (JToggleButton) ED.getSpecialButtonGroup().get(
				BPDConstants.TRANSITION_TOOL);
		selfRoutedTransitionButton = (JToggleButton) ED.getSpecialButtonGroup()
				.get(BPDConstants.SELF_ROUTED_TRANSITION_TOOL);
		// Activate SpecialButtonGroup
		ED.getBarFactory().activateSpecialButtonGroup(true);
		// cursors icon
		ImageIcon curIc;
		// cursors hot spot
		Point hotSpot;
		// cursors image
		Image curIm;
		// get icons, crete images and create cursors
		/*
		 * try { curIc=new
		 * ImageIcon(ResourceManager.getResource(BPDConstants.PARTICIPANT_TOOL+BPDConstants.IMAGE_SUFFIX));
		 * hotSpot=new Point(curIc.getIconWidth()/2,curIc.getIconHeight()/2);
		 * curIm = curIc.getImage();
		 * participantCursor=graph.getToolkit().createCustomCursor(curIm,hotSpot,
		 * "participant20x20"); } catch (Exception e) {
		 * System.err.println("Missing participant cursor in property file !"); }
		 */
		/*
		 * try { curIc=new
		 * ImageIcon(ResourceManager.getResource(BPDConstants.PROCESS_ACTIVITY_TOOL+BPDConstants.IMAGE_SUFFIX));
		 * hotSpot=new Point(curIc.getIconWidth()/2,curIc.getIconHeight()/2);
		 * curIm = curIc.getImage();
		 * processCursor=graph.getToolkit().createCustomCursor(curIm,hotSpot,
		 * "process20x20"); } catch (Exception e) { System.err.println("Missing
		 * process cursor in property file !"); }
		 */

		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.PROCESS_ACTIVITY_TOOL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			processCursor = graph.getToolkit().createCustomCursor(curIm,
					hotSpot, "process20x20");
		} catch (Exception e) {
			System.err.println("Missing process cursor in property file !");
		}

		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.SUBFLOW_ACTIVITY_TOOL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			subflowActivityCursor = graph.getToolkit().createCustomCursor(
					curIm, hotSpot, "subflowActivity20x20");
		} catch (Exception e) {
			System.err
					.println("Missing subflow activity cursor in property file !");
		}
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.OUTFLOW_ACTIVITY_TOOL
							+ BPDConstants.IMAGE_SUFFIX));
			
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			
			
			
			outflowActivityCursor = graph.getToolkit().createCustomCursor(
					curIm, hotSpot, "outflowActivity20x20");
		} catch (Exception e) {
			System.err
					.println("Missing subflow activity cursor in property file !");
		}

		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.BLOCK_ACTIVITY_TOOL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			blockActivityCursor = graph.getToolkit().createCustomCursor(curIm,
					hotSpot, "blockActivity20x20");
		} catch (Exception e) {
			System.err
					.println("Missing block activity cursor in property file !");
		}
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.START_TOOL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			startCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot,
					"start20x20");
		} catch (Exception e) {
			System.err.println("Missing start cursor in property file !");
		}
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.END_TOOL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			endCursor = graph.getToolkit().createCustomCursor(curIm, hotSpot,
					"end20x20");
		} catch (Exception e) {
			System.err.println("Missing end cursor in property file !");
		}
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.MANUAL_ACTIVITY_TOOL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			manualActivityCursor = graph.getToolkit().createCustomCursor(curIm,
					hotSpot, "manualActivity20x20");
		} catch (Exception e) {
			System.err
					.println("Missing manual activity cursor in property file !");
		}
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.AUTO_ACTIVITY_TOOL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			autoActivityCursor = graph.getToolkit().createCustomCursor(curIm,
					hotSpot, "autoActivity20x20");
		} catch (Exception e) {
			System.err
					.println("Missing auto activity cursor in property file !");
		}
		
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.AUTO_ACTIVITY_SERVICE
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			serviceActivityCursor = graph.getToolkit().createCustomCursor(curIm,
					hotSpot, "serviceActivity20x20");
		} catch (Exception e) {
			System.err
					.println("Missing service activity cursor in property file !");
		}
		
		
		
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.AUTO_ACTIVITY_DEVICE
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			deviceActivityCursor = graph.getToolkit().createCustomCursor(curIm,
					hotSpot, "deviceActivity20x20");
		} catch (Exception e) {
			System.err
					.println("Missing device activity cursor in property file !");
		}

		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.AUTO_ACTIVITY_EVENT
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			eventActivityCursor = graph.getToolkit().createCustomCursor(curIm,
					hotSpot, "eventActivity20x20");
		} catch (Exception e) {
			System.err
					.println("Missing event activity cursor in property file !");
		}
		
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.TRANSITION_TOOL_SMALL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			transitionCursor = graph.getToolkit().createCustomCursor(curIm,
					hotSpot, "transition20x20");
		} catch (Exception e) {
			System.err.println("Missing transition cursor in property file !");
		}
		try {
			curIc = new ImageIcon(ResourceManager
					.getResource(BPDConstants.SELF_ROUTED_TRANSITION_TOOL_SMALL
							+ BPDConstants.IMAGE_SUFFIX));
			hotSpot = new Point(curIc.getIconWidth() / 2,
					curIc.getIconHeight() / 2);
			curIm = curIc.getImage();
			selfRoutedTransitionCursor = graph.getToolkit().createCustomCursor(
					curIm, hotSpot, "selfRoutedTransition20x20");
		} catch (Exception e) {
			System.err
					.println("Missing selfRoutedTransition cursor in property file !");
		}
		// add mouse listener to buttons (used to determine persistent mode)
		selectButton.addMouseListener(ml);
		// participantButton.addMouseListener(ml);
		processButton.addMouseListener(ml);
		subflowActivityButton.addMouseListener(ml);
		if (outflowActivityButton != null) {
			outflowActivityButton.addMouseListener(ml);
		}
		if (blockActivityButton != null) {
			blockActivityButton.addMouseListener(ml);
		}
		startButton.addMouseListener(ml);
		endButton.addMouseListener(ml);
		manualActivityButton.addMouseListener(ml);
		autoActivityButton.addMouseListener(ml);
		serviceActivityButton.addMouseListener(ml);
		deviceActivityButton.addMouseListener(ml);
		eventActivityButton.addMouseListener(ml);
		transitionButton.addMouseListener(ml);
		selfRoutedTransitionButton.addMouseListener(ml);
		// add action listeners to buttons (used to set appropriate mouse
		// cursor)
		selectButton.addActionListener(al);
		// participantButton.addActionListener(al);
		processButton.addActionListener(al);
		subflowActivityButton.addActionListener(al);
		if (outflowActivityButton != null) {
			outflowActivityButton.addActionListener(al);
		}
		if (blockActivityButton != null) {
			blockActivityButton.addActionListener(al);
		}
		startButton.addActionListener(al);
		endButton.addActionListener(al);
		manualActivityButton.addActionListener(al);
		autoActivityButton.addActionListener(al);
		serviceActivityButton.addActionListener(al);
		deviceActivityButton.addActionListener(al);
		eventActivityButton.addActionListener(al);
		transitionButton.addActionListener(al);
		selfRoutedTransitionButton.addActionListener(al);
		// add Key listeners to buttons (used to set appropriate mouse cursor)
		// selectButton.addKeyListener(kl);
		// participantButton.addActionListener(al);
		processButton.addActionListener(al);
		subflowActivityButton.addKeyListener(kl);
		if (outflowActivityButton != null) {
			outflowActivityButton.addKeyListener(kl);
		}
		if (blockActivityButton != null) {
			blockActivityButton.addKeyListener(kl);
		}
		startButton.addKeyListener(kl);
		endButton.addKeyListener(kl);
		manualActivityButton.addKeyListener(kl);
		autoActivityButton.addKeyListener(kl);
		serviceActivityButton.addKeyListener(kl);
		deviceActivityButton.addKeyListener(kl);
		eventActivityButton.addKeyListener(kl);
		transitionButton.addKeyListener(kl);
		selfRoutedTransitionButton.addKeyListener(kl);
		graph.addKeyListener(kl);
		ButtonGroup group = new ButtonGroup();
		group.add(selectButton);
		group.add(processButton);
		// group.add(participantButton);
		group.add(subflowActivityButton);
		 group.add(outflowActivityButton);
		 group.add(blockActivityButton);
		group.add(startButton);
		group.add(endButton);
		group.add(manualActivityButton);
		group.add(autoActivityButton);
		group.add(serviceActivityButton);
		group.add(deviceActivityButton);
		group.add(eventActivityButton);
		group.add(transitionButton);
		group.add(selfRoutedTransitionButton);
	}

	/** Return true if this handler should be preferred over other handlers. */
	public boolean isForceMarqueeEvent(MouseEvent e) {
		return ((selectButton.isSelected() && SwingUtilities
				.isRightMouseButton(e))
				|| !selectButton.isSelected() || super.isForceMarqueeEvent(e));
	}

	public void mousePressed(MouseEvent ev) {
		if (SwingUtilities.isRightMouseButton(ev)) {
			// Find Cell in Model Coordinates
			Object cell = graph.getFirstCellForLocation(ev.getX(), ev.getY());
			// Create PopupMenu for the Cell (Scale From Screen to Model)
			popupPoint = (Point) graph.fromScreen(new Point(ev.getPoint()));// HM,
																			// JGraph3.4.1
			JPopupMenu menu = createPopupMenu(cell);
			// Display PopupMenu
			menu.show(graph, ev.getX(), ev.getY());
		} else if (!ev.isConsumed() && !selectButton.isSelected()) {

			start = (Point) graph.snap(ev.getPoint());// HM, JGraph3.4.1
			firstPort = port;

			// if transition is selected
			if ((transitionButton.isSelected() || selfRoutedTransitionButton
					.isSelected())
					&& firstPort != null) {
				double scale = graph.getScale();
				start = firstPort.getBounds().getBounds().getLocation();// HM,
																		// JGraph3.4.1
				start.x += BPDPortView.getPortSize() / 2;
				start.y += BPDPortView.getPortSize() / 2;
				start = new Point((int) (start.getX() * scale), (int) (start
						.getY() * scale));
				// start the transition only if start is valid
				if (acceptsSourceOrTarget(firstPort, true, null, false)) {
					ev.consume();
				} else {
					firstPort = null;
					port = null;
					start = null;
					current = null;
				}
				return;
			}
			// if participant is selected
			/*
			 * if (participantButton.isSelected()) {
			 * workflowManager.insertParticipantAndArrangeParticipants(start,null); }
			 */
			// if process is selected
			if (processButton.isSelected()) {
//				com.ds.bpm.bpd.graph.Process pr = workflowManager
//						.insertProcess();
//				((PackageEditor) ED).putProcessObjectMapping(
//						(com.ds.bpm.bpd.xml.elements.WorkflowProcess) pr
//								.getUserObject(), pr);
			}

			// if subflow is selected
			if (subflowActivityButton.isSelected()) {
				workflowManager.insertSubflowAndArrangeParticipants(start);
			}
			if (outflowActivityButton != null
					&& outflowActivityButton.isSelected()) {
				workflowManager.insertOutflowAndArrangeParticipants(start);
			}
			// if block activity is selected
			if (blockActivityButton != null && blockActivityButton.isSelected()) {
				workflowManager
						.insertBlockActivityAndArrangeParticipants(start);
			}
			// if start is selected
			if (startButton.isSelected()) {
				Set starts = workflowManager.getStarts();
				if (starts.size() >= 1) {
					JOptionPane
							.showMessageDialog(
									ED.getWindow(),
									ResourceManager
											.getLanguageDependentString("ErrorCanNotHaveMoreThenOneStartActivity"),
									BPD.getAppTitle(),
									JOptionPane.ERROR_MESSAGE);
				} else {
					workflowManager.insertStartAndArrangeParticipants(start);
				}
			}
			// if end is selected
			if (endButton.isSelected()) {
				workflowManager.insertEndAndArrangeParticipants(start);
			}
			// if manual activity is selected
			if (manualActivityButton.isSelected()) {
				workflowManager.insertActivityAndArrangeParticipants(start);
			}
			// if route activity is selected
			if (autoActivityButton.isSelected()) {
				workflowManager.insertAutoActivityAndArrangeParticipants(start);
			}
			if (serviceActivityButton.isSelected()) {
				workflowManager.insertServiceActivityAndArrangeParticipants(start);
			}
			if (deviceActivityButton.isSelected()) {
				workflowManager.insertDeviceActivityAndArrangeParticipants(start);
			}
			if (eventActivityButton.isSelected()) {
				workflowManager.insertEventActivityAndArrangeParticipants(start);
			}
			ev.consume();
			if (!persistent)
				selectButton.doClick();
			firstPort = null;
			port = null;
			start = null;
			current = null;
		}
		if (!SwingUtilities.isRightMouseButton(ev)) {
			super.mousePressed(ev);
		}
		// System.out.println("RealXMLPackage=="+BPD.getInstance().saveWFToString(BPD.getInstance().getPackageEditor().getRealXMLPackage()));
		// System.out.println("GraghXMLPackage=="+BPD.getInstance().saveWFToString(BPD.getInstance().getActivedProcessEditor().getGraph().getXMLPackage()));
	}

	public void mouseDragged(MouseEvent ev) {
		if (!ev.isConsumed()
				&& (transitionButton.isSelected() || selfRoutedTransitionButton
						.isSelected()) && (firstPort != null)
				&& !SwingUtilities.isRightMouseButton(ev)) {
			Graphics g = graph.getGraphics();
			Color bg = graph.getBackground();
			Color fg = Utils.getColor(BPDConfig.getInstance()
					.getTransitionColor());
			g.setColor(fg);
			g.setXORMode(bg);
			overlay(g);
			current = (Point) graph.snap(ev.getPoint());// HM, JGraph3.4.1
			double scale = graph.getScale();
			port = graph.getPortViewAt((int) (ev.getX() / scale), (int) (ev
					.getY() / scale));
			if (port != null) {
				current = port.getBounds().getBounds().getLocation();// HM,
																		// JGraph3.4.1
				current = new Point((int) (current.x * scale),
						(int) (current.y * scale));
			}
			g.setColor(bg);
			g.setXORMode(fg);
			overlay(g);
			ev.consume();
		}
		super.mouseDragged(ev);
	}

	public void mouseReleased(MouseEvent ev) {
		if (ev != null
				&& !ev.isConsumed()
				&& (transitionButton.isSelected() || selfRoutedTransitionButton
						.isSelected())
				&& !SwingUtilities.isRightMouseButton(ev)) {
			// finish a transition and create it if end is valid
			// and it is not the same as begining one
			if (acceptsSourceOrTarget(port, false, firstPort, false)
					&& port != firstPort) {
				workflowManager.insertTransition(start, current, firstPort,
						port, selfRoutedTransitionButton.isSelected(), true);
			} else {
				Graphics g = graph.getGraphics();
				Color bg = graph.getBackground();
				Color fg = Utils.getColor(BPDConfig.getInstance()
						.getTransitionColor());
				g.setColor(fg);
				g.setXORMode(bg);
				port = firstPort;
				overlay(g);
			}
			ev.consume();
		}
		if (!persistent)
			selectButton.doClick();
		firstPort = null;
		port = null;
		start = null;
		current = null;
		// modified original method
		try {
			if (ev != null && !ev.isConsumed() && marqueeBounds != null
					&& !SwingUtilities.isRightMouseButton(ev)) {
				Rectangle2D bounds = graph.fromScreen(marqueeBounds);// HM,
																		// JGraph3.4.1
				CellView[] rootViews = graph.getGraphLayoutCache().getRoots(
						bounds);
				// added - getting all views in model (except forbidden objects)
				CellView[] views = AbstractCellView
						.getDescendantViews(rootViews);
				ArrayList wholeList = new ArrayList();
				ArrayList participantList = new ArrayList();
				ArrayList otherList = new ArrayList();
				for (int i = 0; i < views.length; i++) {
					if (bounds.contains(views[i].getBounds())) {
						if (!(views[i] instanceof ParticipantView)) {
							otherList.add(views[i].getCell());
						} else {
							participantList.add(views[i].getCell());
						}
						// if (!(views[i].getCell() instanceof SubflowPort)) {
						wholeList.add(views[i].getCell());
						// }
					}
				}
				/*
				 * if (participantList.size()>0) cells =
				 * participantList.toArray(); else cells = otherList.toArray();
				 */
				Object[] cells = wholeList.toArray();
				graph.getUI().selectCellsForEvent(graph, cells, ev);
				graph.setCursor(new Cursor(Cursor.DEFAULT_CURSOR));
				Rectangle dirty = marqueeBounds.getBounds();// HM, JGraph3.4.1
				dirty.width++;
				dirty.height++;// HM, JGraph3.4.1
				graph.repaint(dirty);
				ev.consume();
			}
		} finally {
			currentPoint = null;
			startPoint = null;
			marqueeBounds = null;
		}
	}

	public void mouseMoved(MouseEvent ev) {
		if (!ev.isConsumed() && !selectButton.isSelected()) {
			ev.consume();
			if (transitionButton.isSelected()
					|| selfRoutedTransitionButton.isSelected()) {
				PortView oldPort = port;
				double scale = graph.getScale();
				PortView newPort = graph.getPortViewAt(
						(int) (ev.getX() / scale), (int) (ev.getY() / scale));
				// PortView newPort = graph.getPortViewAt(ev.getX(), ev.getY());
				if (oldPort != newPort) {
					Graphics g = graph.getGraphics();
					Color bg = graph.getBackground();
					Color fg = graph.getMarqueeColor();
					g.setColor(fg);
					g.setXORMode(bg);
					overlay(g);
					port = newPort;
					g.setColor(bg);
					g.setXORMode(fg);
					overlay(g);
				}
			}
		}
		super.mouseMoved(ev);
	}

	public void overlay(Graphics g) {
		super.overlay(g);
		paintPort(graph.getGraphics());
		if (start != null) {
			if ((transitionButton.isSelected() || selfRoutedTransitionButton
					.isSelected())
					&& current != null) {
				g.drawLine(start.x, start.y, current.x, current.y);
			}
		}
	}

	protected void paintPort(Graphics g) {
		if (port != null) {
			boolean offset = (GraphConstants.getOffset(port.getAttributes()) != null);
			Rectangle r = (offset) ? port.getBounds().getBounds()// HM,
																	// JGraph3.4.1
					: port.getParentView().getBounds().getBounds();// HM,
																	// JGraph3.4.1
			r = (Rectangle) graph.toScreen(new Rectangle(r));// HM,
																// JGraph3.4.1
			int s = 3;
			r.translate(-s, -s);
			r.setSize(r.width + 2 * s, r.height + 2 * s);
			BPDGraphUI ui = (BPDGraphUI) graph.getUI();
			ui.paintCell(g, port, r, true);
		}
	}

	//
	// PopupMenu
	//
	/**
	 * Creates popup menubar and adds a various actions (depending of where mouse
	 * was pressed - which cell(s) is/are selected). 创建流程元素（活动和路由）的右键菜单
	 */
	protected JPopupMenu createPopupMenu(final Object cell) {
		JPopupMenu menu = new JPopupMenu();
		BarFactory jbf = new BarFactory(ED);
		JMenuItem mi;
		if (((cell == null) || (!(cell instanceof Participant)
				&& !(cell instanceof BlockActivity)
				&& !(cell instanceof Transition) && !(cell instanceof Start) && !(cell instanceof End)))) {
			// adding cut action
			menu.add(jbf.createMenuItem(Utils
					.getUnqualifiedClassName(Cut.class), false));
			// adding copy action
			menu.add(jbf.createMenuItem(Utils
					.getUnqualifiedClassName(Copy.class), false));
			// adding pasteAt action
			menu.add(jbf.createMenuItem(Utils
					.getUnqualifiedClassName(PasteAt.class), false));
			menu.addSeparator();
			if (cell == null) {
				menu.add(jbf.createMenuItem(Utils
						.getUnqualifiedClassName(SelectAllCell.class), false));
				menu.addSeparator();
				// adding ProcessProperties action
				menu.add(jbf.createMenuItem(Utils
						.getUnqualifiedClassName(ProcessProperties.class),
						false));
			}
			/*
			 * if (!graph.isSelectionEmpty() && cell != null) {
			 * menubar.addSeparator(); }
			 */
		}
		// adding delete action
		if (!graph.isSelectionEmpty() && cell != null
				&& !(cell instanceof Participant)) {
			menu.add(jbf.createMenuItem(Utils
					.getUnqualifiedClassName(DeleteCell.class), false));
			menu.addSeparator();
		}
		// adding properties action
		if ((cell != null) && !(cell instanceof Participant)
				&& !(cell instanceof Start) && !(cell instanceof End)) {
			if (cell instanceof Transition) {
				Transition t = (Transition) cell;
				boolean isRouting = Utils
						.isRoutingTransition(t.getAttributes());
				if (t.getSourceActivity() instanceof Start
						|| t.getTargetActivity() instanceof End) {
					if (!isRouting) {
						menu.add(jbf.createMenuItem(Utils
								.getUnqualifiedClassName(SetSelfRouting.class),
								false));
					} else {
						menu.add(jbf.createMenuItem(Utils
								.getUnqualifiedClassName(SetNoRouting.class),
								false));
					}
				} else {
					menu.add(jbf.createMenuItem(Utils
							.getUnqualifiedClassName(EditProperties.class),
							false));
					if (!isRouting) {
						menu
								.add(jbf
										.createMenuItem(
												Utils
														.getUnqualifiedClassName(AddPoint.class),
												false));
						menu.add(jbf.createMenuItem(Utils
								.getUnqualifiedClassName(RemovePoint.class),
								false));
						menu.addSeparator();
						menu.add(jbf.createMenuItem(Utils
								.getUnqualifiedClassName(SetSelfRouting.class),
								false));
					} else {
						menu.add(jbf.createMenuItem(Utils
								.getUnqualifiedClassName(SetNoRouting.class),
								false));
					}
				}
			} else {
				menu.add(jbf.createMenuItem(Utils
						.getUnqualifiedClassName(EditProperties.class), false));
			}
			// adding edit action for processes, subflows, block activities
			//if (cell instanceof Subflow || cell instanceof BlockActivity||cell instanceof Outflow) {
			if (cell instanceof Subflow || cell instanceof BlockActivity) {
				menu.add(jbf.createMenuItem(Utils
						.getUnqualifiedClassName(EditCell.class), false));
			}
		}
		return menu;
	}

	/**
	 * Gets the point of last popup menubar creation.
	 */
	public Point getPopupPoint() {
		return popupPoint;
	}

	/**
	 * Returns <code>true</code> if parent cell of given port accepts source
	 * or target, depending on <code>source</code> parameter.
	 */
	public boolean acceptsSourceOrTarget(PortView port, boolean source,
			PortView firstPort, boolean circularTransition) {
		// if port is a valid
		if (port != null && port.getCell() != null
		// and it is a port
				&& (port.getCell() instanceof DefaultPort)) {
			// and it's parent is instance of Linkable
			// return if it accepts to be a source or a target
			Object p = ((DefaultPort) port.getCell()).getParent();
			if ((p instanceof Linkable)) {
				boolean usingBubbles = BPDConfig.getInstance()
						.getUseBubblesStatus();
				if (source) {
					if (!((Linkable) p).acceptsSource())
						return false;
					// if bubbles are used, do not allow last activity to have
					// an
					// outgoing transitions, except exceptional or circular ones
					if (usingBubbles) {
						// if (p instanceof Activity) {
						// Activity act=(Activity)p;
						// if (Utils.hasConnectedEndBubble(act) &&
						// !circularTransition) {
						// JOptionPane.showMessageDialog(ED.getWindow(),
						// ResourceManager.getLanguageDependentString(
						// "ErrorLastActivityCannotHaveOutgoingTransitions"),
						// BPD.getAppTitle(),JOptionPane.ERROR_MESSAGE);
						// return false;
						//
						// }
						// }
					}
					return true;
				} else {
					if (!((Linkable) p).acceptsTarget())
						return false;
					Object srcCell = ((DefaultPort) firstPort.getCell())
							.getParent();
					// if bubbles are used, do not allow start-end connection
					if (usingBubbles && (p instanceof End)
							&& (srcCell instanceof Start)) {
						JOptionPane
								.showMessageDialog(
										ED.getWindow(),
										ResourceManager
												.getLanguageDependentString("ErrorCannotConnectStartAndEnd"),
										BPD.getAppTitle(),
										JOptionPane.ERROR_MESSAGE);
						return false;
					}
					if (p instanceof Activity) {
						Activity act = (Activity) p;
						Set trns = act.getIncomingTransitions();
						// if bubbles are used, do not allow that first activity
						// has incoming transitions,
						// or that last activity has outgoing transitions except
						// circular one
						if (usingBubbles) {
							if (trns.size() == 1 || trns.size() == 2) {
								Object[] trnsArr = trns.toArray();
								if ((((Transition) trnsArr[0])
										.getSourceActivity() instanceof Start)
										|| (trns.size() == 2 && ((Transition) trnsArr[1])
												.getSourceActivity() instanceof Start)) {
									if (!circularTransition) {
										JOptionPane
												.showMessageDialog(
														ED.getWindow(),
														ResourceManager
																.getLanguageDependentString("ErrorFirstActivityCannotHaveIncomingTransitions"),
														BPD.getAppTitle(),
														JOptionPane.ERROR_MESSAGE);
										return false;
									}
								}
							}
							if ((trns.size() > 0) && (srcCell instanceof Start)) {
								if (trns.size() > 1
										|| (trns.size() == 1 && !Utils
												.hasCircularTransitions(trns))) {
									JOptionPane
											.showMessageDialog(
													ED.getWindow(),
													ResourceManager
															.getLanguageDependentString("ErrorFirstActivityCannotHaveIncomingTransitions"),
													BPD.getAppTitle(),
													JOptionPane.ERROR_MESSAGE);
									return false;
								}
							}

							// 暂时屏蔽掉中国式流程应该更灵活
							// if (act instanceof End) {
							// Set
							// saNETrns=((Activity)srcCell).getNonExceptionalOutgoingTransitions();
							// if (saNETrns.size()>1 || (saNETrns.size()==1 &&
							// !Utils.hasCircularTransitions(saNETrns))) {
							// JOptionPane.showMessageDialog(ED.getWindow(),
							// ResourceManager.getLanguageDependentString(
							// "ErrorLastActivityCannotHaveOutgoingTransitions"),
							// BPD.getAppTitle(),JOptionPane.ERROR_MESSAGE);
							// return false;
							// }
							// }
						}
						// Do not allow activity to have more than one
						// transition
						// from the same activity
						if (trns.size() > 0) {
							Iterator it = trns.iterator();
							while (it.hasNext()) {
								Object src = ((Transition) it.next())
										.getSourceActivity();
								if (src.equals(srcCell)) {
									JOptionPane
											.showMessageDialog(
													ED.getWindow(),
													ResourceManager
															.getLanguageDependentString("ErrorActivityCannotHaveMoreThenOneIncomingOutgoingTransitionFromToTheSameActivity"),
													BPD.getAppTitle(),
													JOptionPane.ERROR_MESSAGE);
									return false;
								}
							}
						}
					}
					return true;
				}
			}
		}
		// return false otherwise
		return false;
	}

	/**
	 * Adds buttons created in PEMarqueHandler class to the group. This is a
	 * place to add special things.
	 */
	public Hashtable getSpecialButtons() {
		Hashtable buttons = new Hashtable();
		ButtonGroup group = new ButtonGroup();
		// ---------------------- buttongroup ----------------------------
		buttons.put(BPDConstants.SELECT_TOOL, selectButton);
		// buttons.put(BPDConstants.PARTICIPANT_TOOL, participantButton);
		 buttons.put(BPDConstants.PROCESS_ACTIVITY_TOOL,processButton);
		buttons.put(BPDConstants.SUBFLOW_ACTIVITY_TOOL, subflowActivityButton);
		buttons.put(BPDConstants.BLOCK_ACTIVITY_TOOL, blockActivityButton);
		buttons.put(BPDConstants.START_TOOL, startButton);
		buttons.put(BPDConstants.END_TOOL, endButton);
		buttons.put(BPDConstants.MANUAL_ACTIVITY_TOOL, manualActivityButton);
		buttons.put(BPDConstants.AUTO_ACTIVITY_TOOL, autoActivityButton);
		buttons.put(BPDConstants.AUTO_ACTIVITY_SERVICE, serviceActivityButton);
		buttons.put(BPDConstants.AUTO_ACTIVITY_DEVICE, deviceActivityButton);
		buttons.put(BPDConstants.AUTO_ACTIVITY_EVENT, eventActivityButton);
		buttons.put(BPDConstants.TRANSITION_TOOL, transitionButton);
		buttons.put(BPDConstants.SELF_ROUTED_TRANSITION_TOOL,
				selfRoutedTransitionButton);
		selectButton.doClick();
		return buttons;
	}

	public JToggleButton getSelectButton() {
		return selectButton;
	}


	  public JToggleButton getProcessButton () { return processButton; }
	 
	/*
	 * public JToggleButton getParticipantButton () { return participantButton; }
	 */
	public JToggleButton getSubflowActivityButton() {
		return subflowActivityButton;
	}

	public JToggleButton getBlockActivityButton() {
		return blockActivityButton;
	}

	public JToggleButton getStartButton() {
		return startButton;
	}

	public JToggleButton getEndButton() {
		return endButton;
	}

	public JToggleButton getManualActivityButton() {
		return manualActivityButton;
	}

	public JToggleButton getAutoActivityButton() {
		return autoActivityButton;
	}

	public JToggleButton getServiceActivityButton() {
		return serviceActivityButton;
	}

	public JToggleButton getTransitionButton() {
		return transitionButton;
	}

	public JToggleButton getDeviceActivityButton() {
		return deviceActivityButton;
	}
	public JToggleButton getEventActivityButton() {
		return eventActivityButton;
	}
	

	public JToggleButton getSelfRoutedTransitionButton() {
		return selfRoutedTransitionButton;
	}
}
