/**
 * $RCSfile: BPDLogFactory.java,v $
 * $Revision: 1.1 $
 * $Date: 2014/08/07 08:30:36 $
 *
 * Copyright (C) 2005 itjds, Inc. All rights reserved.
 *
 * This software is the proprietary information of itjds, Inc.
 * Use is subject to license terms.
 */
package com.ds.bpm.bpd;

import java.util.HashMap;
import java.util.Map;

import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;

/**
 * <p>
 * Title: BPM工作流图形定义工具BPD
 * </p>
 * <p>
 * Description: 日志工厂类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2005
 * </p>
 * <p>
 * Company: 基督山BPM
 * </p>
 * 
 * @author Andy
 * @version 1.0
 */
public class BPDLogFactory {

	private static Map logMap = new HashMap();

	/**
	 * 取得相应类的日志类
	 * 
	 * @param cls
	 *            要记录日志的类
	 * @return 日志类
	 */
	public static Log getLog(Class cls) {
		Log logger = (Log) logMap.get(cls);
		if (logger == null) {
			logger = LogFactory.getLog(BPDConstants.APPLICATION_NAME, cls);
			if (logger != null) {
				logMap.put(cls, logger);
			}
		}

		return logger;
	}

}
