/* PEGraphSelectionModel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：JGraph图形DefaultGraphSelectionModel扩展类，工作流工具图形的选择模型类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 */

package com.ds.bpm.bpd;

import java.util.HashSet;
import java.util.Set;

import org.jgraph.JGraph;
import org.jgraph.graph.DefaultGraphSelectionModel;

/**
 * BPD implementation of selection model.
 */
public class BPDGraphSelectionModel extends DefaultGraphSelectionModel {

	/** Constructs a DefaultGraphSelectionModel for the specified graph. */
	public BPDGraphSelectionModel(JGraph graph) {
		super(graph);
	}

	/**
	 * Modifies original method to avoid selection of in/out of subflow.
	 */
	public void setSelectionCells(Object[] cells) {
		super.setSelectionCells(removeForbiddenCells(cells));
	}

	/**
	 * Modifies original method to avoid selection of in/out of subflow.
	 */
	public void addSelectionCells(Object[] cells) {
		super.addSelectionCells(removeForbiddenCells(cells));
	}

	/**
	 * Modifies original method to avoid deselection of in/out of subflow.
	 */
	public void removeSelectionCells(Object[] cells) {
		super.removeSelectionCells(removeForbiddenCells(cells));
	}

	/**
	 * Removes forbiden objects from selection.
	 */
	private Object[] removeForbiddenCells(Object[] cells) {
		return cells;
	}

	// NOTE: FOLLOWING METHOD IS NEVER CALLED BECAUSE PEJGRAPH IMPLEMENTS
	// IT'S OWN METHOD TO DO THIS. IT COULD BE CHANGED.
	/**
	 * Returns the cells that are currently selectable.
	 */
	public Object[] getSelectables() {
		Object[] selectables = super.getSelectables();

		if (selectables != null && selectables.length > 0) {
			Set removedForbiddenElements = new HashSet();
			for (int i = 0; i < selectables.length; i++) {
				removedForbiddenElements.add(selectables[i]);
			}
			selectables = removedForbiddenElements.toArray();
		}
		return selectables;
	}

}

/* End of PEGraphSelectionModel.java */
