/* BPD.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：主界面UI的展现抽象类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd;

import com.ds.bpm.bpd.actions.Save;
import com.ds.bpm.bpd.graph.End;
import com.ds.bpm.bpd.graph.Start;
import com.ds.bpm.bpd.misc.ExternalProcesses;
import com.ds.bpm.bpd.misc.PFLocale;
import com.ds.bpm.bpd.misc.PackageTreePanel;
import com.ds.bpm.bpd.misc.ValidationErrorDisplay;
import com.ds.bpm.bpd.plugin.PluginManager;
import com.ds.bpm.bpd.server.panels.LoginDialog;
import com.ds.bpm.bpd.service.BPDService;
import com.ds.bpm.bpd.service.CtBPDService;
import com.ds.bpm.bpd.service.CtBPDServiceImpl;
import com.ds.bpm.bpd.xml.*;
import com.ds.bpm.bpd.xml.activity.*;
import com.ds.bpm.bpd.xml.activity.Event;
import com.ds.bpm.bpd.xml.elements.*;
import com.ds.bpm.bpd.xml.elements.Package;
import com.ds.bpm.bpd.xml.panels.ErrTablePanel;
import com.ds.bpm.client.ProcessDef;
import com.ds.bpm.client.ProcessDefVersion;
import com.ds.bpm.engine.BPMException;
import com.ds.common.JDSException;
import com.ds.common.util.DateUtility;
import com.ds.common.util.IOUtility;
import com.ds.config.UserBean;
import com.ds.context.JDSActionContext;
import com.ds.context.JDSContext;
import com.ds.context.MinServerActionContextImpl;
import com.ds.esb.util.EsbFactory;
import com.ds.iot.json.UserInfo;
import com.ds.jds.core.User;
import com.ds.jds.core.esb.EsbUtil;
import com.ds.server.JDSServer;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.w3c.dom.Document;

import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.*;
import javax.swing.Icon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.*;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.*;
import java.util.List;

/**
 * 主界面初始化类 This is the main class of application. It is made singleton, and it's
 * main funcionality is to provide some methods to access the process editor
 * class.
 */
public final class BPD implements XMLElementChangeListener {

    private static DateUtility timer = new DateUtility();

    private static XMLInterface xmlInterface = new XML();
    /**
     * The one and only instance of BPD.
     */
    private static BPD bpd;

    private static BPDSplash splash;

    // Application Icon. From resource file.
    public static ImageIcon appIcon;

    // Application Icon. From resource file.
    private static ImageIcon logoIcon;

    // Application Title and other stuff. From resource file.
    private static String appTitle;

    private static String mandatoryConformanceClass = BPDConfig.getInstance().getMandatoryConformanceClass();

    private static final int recentFileListSize = BPDConfig.getInstance().getRecentFileListSize();

    // 当前激活的工作流编辑面板
    private ProcessEditor activedProcessEditor;

    // 是否登录服务器的标志位
    private boolean isLogin = false;

    // 当前登陆用户信息,索引0为用户ID，1为用户帐号，2为用户名称
    private UserInfo userinfo;

    // 帮助相关变量
    private HelpSet hs;

    private HelpBroker hb;

    // 打开过的本地流程路径集合，xpdlFilePathMap对象
    private Map<String, String> xpdlFilePathMap = new HashMap();

    // 打开过的本地流程集合，localEditingProcessMap对象
    private Map<String, ProcessDef> localEditingProcessMap = new HashMap();

    // 打开过的远程流程集合，remoteProcessMap对象
    private Map<String, ProcessDef> remoteProcessMap = new HashMap();
    // 正在编辑的远程流程集合，remoteEditingProcessMap对象
    private Map<String, ProcessEditor> remoteEditingProcessMap = new HashMap<String, ProcessEditor>();

    PackageTreePanel packageTreePanel;


    // 保存活动Id和对应活动clone的Map
    private Map actMap = new HashMap();

    static {
        try {
            String vers = System.getProperty("java.version");

            if (vers.compareTo("1.5") < 0) {
                System.out.println("!!!WARNING: BPD must be run with a " + "1.5 or higher version JVM!!!");
                System.exit(1);
            }

            // application title
            appTitle = ResourceManager.getLanguageDependentString("Title");

            // Logo
            URL url = ResourceManager.getResource("Logo");
            if (url != null)
                logoIcon = new ImageIcon(url);

            // Icon
            url = ResourceManager.getResource("Icon");
            if (url != null)
                appIcon = new ImageIcon(url);
            // setting the port view sizes similar to activities
            BPDPortView.setPortSize(Math.min(BPDConfig.getInstance().getActivityWidth(),
                    BPDConfig.getInstance().getActivityHeight()) - 10);
            // creating USER_HOME/.BPD directory if it doesn't exist
            File ujdir = new File(BPDConstants.BPD_USER_HOME);
            if (!ujdir.exists()) {
                try {
                    ujdir.mkdir();
                } catch (Exception exc) {
                }
                ;
            }
        } catch (Throwable t) {
            System.err.println("uncaught exception: " + t);
            t.printStackTrace();
        }

    }


    /**
     * The main frame of application.
     */
    private JFrame mainFrame;

    /**
     * The instance of process editor. It is the only instance, because this is a
     * single-document application.
     */
    private PackageEditor packageEditor;

    /* Filename for the current document. Null if never saved or opened. */
    private String filename;

    /* True if document was modified since last save. */
    private boolean modified = false;

    // private Action saveAll;

    private Action closeAll;

    private Action exit;

    private JMenu recentFilesMenu;

    // 所有已打开的工作流集合

    private Map workflowProsessMap;

    private Map romveWorkflowProsessMap;

    private ErrTablePanel errTablePanel;

    private List<ProcessDef> processDefList;

    private CtBPDServiceImpl ctService;

    public String projectName;

    public static BPD getInstance() {
        return getInstance(false);
    }

    /**
     * Returns one and only instance of BPD.
     *
     * @return The instance of BPD class.
     */
    static BPD getInstance(boolean ifram) {
        if (bpd == null) {
            // ynchronized (BPD.THREAD_LOCK) {
            if (bpd == null) {
                BPD.bpd = new BPD();
                BPD.bpd.init(false);
            }
            // }
        }

        return bpd;
    }

    /**
     * Returns the application title.
     */
    public static String getAppTitle() {
        return appTitle;
    }

    /**
     * Set the application title.
     *
     * @return
     */
    public void setAppTitle(String title) {
        appTitle = title;
    }

    /**
     * Returns the logo icon.
     */
    public static ImageIcon getLogoIcon() {
        return logoIcon;
    }

    /**
     * Returns the application icon.
     */
    public static ImageIcon getAppIcon() {
        return appIcon;
    }

    /**
     * Construct BPD.
     */
    private BPD() {

        // 设置BPD的默认字体
        UIManager.put("Label.font", BPDConfig.getInstance().getFont());
        UIManager.put("Button.font", BPDConfig.getInstance().getFont());
        UIManager.put("TextField.font", BPDConfig.getInstance().getFont());
        UIManager.put("PasswordField.font", BPDConfig.getInstance().getFont());
        UIManager.put("TextArea.font", BPDConfig.getInstance().getFont());
        UIManager.put("Menu.font", BPDConfig.getInstance().getFont());
        UIManager.put("MenuItem.font", BPDConfig.getInstance().getFont());
        UIManager.put("PopupMenu.font", BPDConfig.getInstance().getFont());
        UIManager.put("List.font", BPDConfig.getInstance().getFont());
        UIManager.put("CheckBox.font", BPDConfig.getInstance().getFont());
        UIManager.put("RadioButton.font", BPDConfig.getInstance().getFont());
        UIManager.put("ComboBox.font", BPDConfig.getInstance().getFont());
        UIManager.put("Panel.font", BPDConfig.getInstance().getFont());
        UIManager.put("TabbedPane.font", BPDConfig.getInstance().getFont());
        UIManager.put("Tree.font", BPDConfig.getInstance().getFont());
        UIManager.put("Table.font", BPDConfig.getInstance().getFont());
        UIManager.put("TableHeader.font", BPDConfig.getInstance().getFont());
        UIManager.put("TitledBorder.font", BPDConfig.getInstance().getFont());
        UIManager.put("FileChooser.font", BPDConfig.getInstance().getFont());
        UIManager.put("ToolTip.font", BPDConfig.getInstance().getFont());
        UIManager.put("OptionPane.messageFont", BPDConfig.getInstance().getFont());
        UIManager.put("OptionPane.buttonFont", BPDConfig.getInstance().getFont());

    }

    public void autoLogin(User user) {
        UserInfo userinfo = new UserInfo();
        userinfo.setAccount(user.getAccount());
        userinfo.setId(user.getId());
        userinfo.setSessionId(user.getSessionId());
        userinfo.setSystemCode(user.getSystemCode());
        userinfo.setUdpIP(user.getUdpIP());
        userinfo.setUdpPort(user.getUdpPort());
        bpd.getPackageEditor().showWindow(bpd.getPackageEditor().getTitle());

        if (userinfo != null) {

            this.fillUser();
            BPD.getInstance().setUserInfo(userinfo);

            BPD.getInstance().setLoginFlag(true);
            // 指定所有打开流程的登录编辑用户
            BPD.getInstance().setLoginedUserForOpenedProcesses();
            BPD.getInstance().setRemoteProcessMap(BPD.getInstance().getRemoteProcessDefList(true));

            MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor()).getRemotePackageTreePanel().refreshPackageTreePanel();

            // 刷新界面
            BPD.getInstance().getPackageEditor().valueChanged(null);
            // 当登录成功后将树形选择为远程目录树
            MainLeftDownPanel mainLeftDownPanel = BPD.getInstance().getMainLeftDownPanel();
            mainLeftDownPanel.getMainLeftDownPanel().setSelectedComponent(mainLeftDownPanel.getRemotePackageTreePanel());

        }
    }


    public void init(boolean isFrame) {


        try {
            EsbFactory.initBus();
        } catch (Exception e1) {
            e1.printStackTrace();
        }


        this.filename = null;
        if (splash != null) {
            splash.showStatus(ResourceManager.getLanguageDependentString("SplashScreen.PrepareData.Start"), 60);
        }

        packageEditor = new PackageEditor();

        if (isFrame) {
            mainFrame = new JFrame();
            mainFrame.setBackground(Color.lightGray);
            mainFrame.getContentPane().setLayout(new BorderLayout());
            mainFrame.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
            if (appIcon != null)
                mainFrame.setIconImage(appIcon.getImage());
            XMLUtil.setApplicationWindow(mainFrame);
            // adding to xml element change listener collection
            XMLElementDialog.addXMLElementChangedListener(this);

            mainFrame.getContentPane().add(packageEditor, BorderLayout.CENTER);

            mainFrame.addWindowListener(createAppCloser());
            mainFrame.pack();
            // set default location to be centered and size to be almost maximized
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            int xMinus = 50, yMinus = 100;
            mainFrame.setBounds(xMinus / 2, yMinus / 2, screenSize.width - xMinus, screenSize.height - yMinus);
            initHelpSystem(mainFrame);
        }

        if (splash != null) {
            splash.showStatus(ResourceManager.getLanguageDependentString("SplashScreen.PrepareData.PackageEditor"), 80);
        }

        // saveAll = packageEditor.getAction("SaveAll");
        closeAll = packageEditor.getAction("CloseAll");
        exit = packageEditor.getAction("Exit");
        // recentFiles menubar receives a special treatment, since
        // we need the reference to that menubar available to the
        // addToRecentFiles method
        recentFilesMenu = (JMenu) packageEditor.getMenuItem("RecentFiles");
        // now fill in recent files menubar from storage file
        initRecentFileMenu();

        ToolTipManager.sharedInstance().setEnabled(BPDConfig.getInstance().getTooltipStatus());
        if (splash != null) {
            splash.showStatus(ResourceManager.getLanguageDependentString("SplashScreen.PrepareData.InitWebservice"),
                    97);
        }

        // ==========初始化帮助系统=========

        // ==========初始化应用配置文件======
        createDefaultConfigFile();
    }

    /**
     * Gets the filename of current document.
     */
    public String getFilename() {
        return filename;
    }

    /**
     * Sets the filename of current document.
     */
    public void setFilename(String filename) {
        this.filename = filename;
    }

    /**
     * Creates AppCloser object.
     */
    protected WindowAdapter createAppCloser() {
        return new AppCloser();
    }

    // ************** APPCLOSER CLASS FOR CLOSING APPLICATION WINDOW
    // ***************

    /**
     * To shutdown when run as an application.
     */
    private final class AppCloser extends WindowAdapter {

        public void windowClosing(WindowEvent e) {
            exit.actionPerformed(null);
        }
    }

    // **** END OF CREATING APPLICATION CLOSER COMPONENT FOR APPLICATION WINDOW
    // ****

    public JMenu getRecentFilesMenu() {
        return recentFilesMenu;
    }

    private void initRecentFileMenu() {
        String rfl = XMLUtil.fileToString(BPDConstants.BPD_USER_HOME + BPDConstants.RFL_FILENAME);
        if (rfl != null) {
            for (StringTokenizer st = new StringTokenizer(rfl, "\n"); st.hasMoreTokens(); ) {
                addToRecentFiles(st.nextToken());
            }
        }
    }

    public void open(String dir) throws IOException {
        if (dir != null) {
            if (!dir.matches("[\u4e00-\u9fa5]+")) {

                dir = java.net.URLDecoder.decode(dir);

            }
        }

        File file = new File(dir);
        //Desktop.getDesktop().open(file);
    }

    /**
     * 添加最近打开过的本地文件
     */
    public void addToRecentFiles(String filename) {
        JMenuItem mItem;
        for (int i = 0; i < recentFilesMenu.getItemCount(); ++i) {
            mItem = (JMenuItem) recentFilesMenu.getMenuComponent(i);
            if (mItem.getText() != null && mItem.getText().length() > 2) {
                if (filename.equals(mItem.getText().substring(2))) {
                    recentFilesMenu.remove(i);
                }
            }
        }
        if (recentFilesMenu.getItemCount() == recentFileListSize) {
            recentFilesMenu.remove(recentFileListSize - 1);
        }
        mItem = new JMenuItem("1." + filename);
        mItem.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                String filename = e.getActionCommand().substring(2);
                // if (BPD.getInstance().close()) {
                checkNameAndOpenDocumentIfPossible(filename);
                // }
            }
        });
        recentFilesMenu.insert(mItem, 0);
        // changing mnemonics to correspond to the ordinal number of items
        for (int i = 0; i < recentFilesMenu.getItemCount(); ++i) {
            mItem = (JMenuItem) recentFilesMenu.getMenuComponent(i);
            String oldText = mItem.getText();
            String ordNo = String.valueOf(i + 1);
            String mnemonic = ordNo.substring(ordNo.length() - 1, ordNo.length());
            if (mItem.getText() != null && mItem.getText().length() > 2) {
                mItem.setText(mnemonic + " " + oldText.substring(2));
            }
            BarFactory.setMnemonic(mItem, mnemonic);
        }
    }

    /*
     * Method for closing document. Returns true if the user really wants to close.
     * Gives chance to save work.
     */
    public boolean close() {
        int r = JOptionPane.showConfirmDialog(mainFrame, ResourceManager.getLanguageDependentString("IsExitDialog"),
                appTitle, JOptionPane.OK_CANCEL_OPTION);
        if (r == JOptionPane.OK_OPTION) {
            // saveAll.actionPerformed(null);
            closeAll.actionPerformed(null);
            if (isModified()) {
                r = JOptionPane.CANCEL_OPTION;
            }
        }
        if (r == JOptionPane.CANCEL_OPTION) {
            // this.getPackageEditor().getWindow().dispose();
            return false;
        }
        if (r == JOptionPane.CLOSED_OPTION) {
            return false;
        }
        return true;
    }

    /**
     * Returns the instance of package editor that maintains current package.
     */
    public PackageEditor getPackageEditor() {
        return packageEditor;
    }

    /**
     * Gets the main package representing opened XML file.
     */
    public Package getRealXMLPackage() {
        return packageEditor.getRealXMLPackage();
    }

    /**
     * Sets the indication if document is modified.
     */
    public void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
        }
    }

    /**
     * Returns if the document is modified.
     */
    public boolean isModified() {
        return modified;
    }

    /**
     * 获取当前主窗体的左下窗口
     *
     * @return
     */

    public MainLeftDownPanel getMainLeftDownPanel() {
        MainLeftDownPanel mainLeftDownPanel = MainLeftDownPanel.getInstance(this.getPackageEditor());
        return mainLeftDownPanel;
    }

    /**
     * 获取当前主窗体的中下窗口
     *
     * @return
     */
    public MainCenterDownPanel getMainCenterDownPanel() {
        MainCenterDownPanel mainCenterDownPanel = MainCenterDownPanel.getInstance(this.getPackageEditor());
        return mainCenterDownPanel;
    }

    /**
     * @param name
     */
    public void checkNameAndOpenDocumentIfPossible(String name) {
        if (name != null && new File(name).exists()) {

            // packageEditor.displayPackage(packageEditor.getRealXMLPackage());
            Package pkg = openDocument(name, false, false);
            packageEditor.setNewPackage(pkg, true);
            // openWorkflow(pkg);
            // 将打开流程添加到最近打开文件的集合中
            addToRecentFiles(name);
            // check if there is mandatory conformance class
            processConformanceClassAttribute(pkg);
            // 注册流程包
            xmlInterface.registerPackageFilename(name, pkg);
            // 如果流程有效才打开
            // if (validateWorkflowProcess(pkg)) {
            WorkflowProcesses wps = (WorkflowProcesses) pkg.get("WorkflowProcesses");
            Iterator wpCln = wps.toCollection().iterator();
            for (int k = 0; wpCln.hasNext(); k++) {
                WorkflowProcess wp = (WorkflowProcess) wpCln.next();
                String processDefVersionId = wp.getVersionID();
                if (isProcessOpenedAfresh(BPDConstants.PROCESS_LOCAL, processDefVersionId)) {
                    this.getWorkflowProcessMap().put(processDefVersionId, wp);
                    if (wp.isSubFlow()) {
                        openWorkflow(processDefVersionId, false);
                        // 将打开的本地流程路径存入本地流程路径集合
                        BPD.getInstance().getXpdlFilePathMap().put(processDefVersionId, name);
                    }
                }
            }
            // 重新打开主流程
            WorkflowProcess mainProcess = (WorkflowProcess) (wps.getMainProceList()).get(0);
            String mainProcessDefVersionId = mainProcess.getVersionID();
            openWorkflow(mainProcessDefVersionId, true);
            // 将打开的本地流程路径存入本地流程路径集合
            BPD.getInstance().getXpdlFilePathMap().put(mainProcessDefVersionId, name);
        } else {
            message(ResourceManager.getLanguageDependentString("InformationErrorWhileOpeningFile"),
                    JOptionPane.INFORMATION_MESSAGE);
        }
    }

    public Map getWorkflowProcessMap() {

        if (this.workflowProsessMap == null) {
            this.workflowProsessMap = new HashMap();
        }
        return this.workflowProsessMap;
    }

    public Map getRomveWorkflowProcessMap() {

        if (this.romveWorkflowProsessMap == null) {
            this.romveWorkflowProsessMap = new HashMap();
        }
        return this.romveWorkflowProsessMap;
    }

    public void openWorkflow(String processDefVersionId) {
        if (isProcessOpenedAfresh(BPDConstants.PROCESS_LOCAL, processDefVersionId)) {
            openWorkflow(processDefVersionId, true);
        }
    }

    public void openWorkflow(String processDefVersionId, boolean show) {
        WorkflowProcess wp = (WorkflowProcess) this.getWorkflowProcessMap().get(processDefVersionId);
        // wp.getPackage().toXML(wp.getPackage());
        BPD.getInstance().setActivedProcessEditor(null);
        wp.setNew(false);
        WorkflowManager workflowManager = new WorkflowManager(null, packageEditor);
        com.ds.bpm.bpd.graph.Process pr = workflowManager.insertProcess(wp, false);
        pr.setUserObject(wp);
        pr.createWorkflowGraph(packageEditor.getWindow());
        packageEditor.putProcessObjectMapping(wp, pr);

        if (show) {
            pr.showProcess();
            // 当前工作流的图形界面与图形按钮进行绑定
            ProcessGraph processGraph = (ProcessGraph) pr.getImplementationEditor().getGraph();
            processGraph.setMarqueeHandler(new BPDMarqueeHandler(processGraph));

            // 修改主界面状态栏信息
            packageEditor.getStatusBar().updateMessage();
            processGraph.paintImmediately(processGraph.getBounds());
            processGraph.refreshTransitionGraph();

            // 设置流程标识为保存在本地
            BPD.getInstance().getActivedProcessEditor().setProcessFlag(BPDConstants.PROCESS_LOCAL);
            // 将工作流图形设置为没有改变
            BPD.getInstance().getActivedProcessEditor().setProcessModified(false);
            ProcessEditor processEditor = BPD.getInstance().getActivedProcessEditor();

            // 将打开流程存入本地正在编辑流程集合
            BPD.getInstance().getLocalEditingProcessMap().put(processDefVersionId, processEditor);

            // 刷新流程树列表

            // packageEditor.getPackageTreePanel().refreshPackageTreePanel();
            // 刷新打开流程编辑界面
            BPD.getInstance().getActivedProcessEditor().valueChanged(null);
            // packageEditor.reOverview();
            BPD.getInstance().getPackageEditor().graphMainsplitPane.getTopComponent().show(true);

        }
    }

    public void openRomveWorkflow(String processDefVersionId) {
        if (isProcessOpenedAfresh(BPDConstants.PROCESS_LOCAL, processDefVersionId)) {
            openRomveWorkflow(processDefVersionId, true);
        }
    }

    public void openRomveWorkflow(String processDefVersionId, boolean show) {
        WorkflowProcess wp = (WorkflowProcess) this.getRomveWorkflowProcessMap().get(processDefVersionId);
        BPD.getInstance().setActivedProcessEditor(null);
        wp.setNew(false);

        WorkflowManager workflowManager = new WorkflowManager(null, packageEditor);
        com.ds.bpm.bpd.graph.Process pr = workflowManager.insertProcess(wp, false);
        pr.setUserObject(wp);
        pr.createWorkflowGraph(packageEditor.getWindow());
        packageEditor.putProcessObjectMapping(wp, pr);
        if (show) {
            if (isProcessOpenedAfresh(BPDConstants.PROCESS_REMOTE, processDefVersionId)) {
                pr.showProcess();
                // 当前工作流的图形界面与图形按钮进行绑定
                ProcessGraph processGraph = (ProcessGraph) pr.getImplementationEditor().getGraph();
                processGraph.setMarqueeHandler(new BPDMarqueeHandler(processGraph));
                // 修改主界面状态栏信息
                packageEditor.getStatusBar().updateMessage();
                processGraph.paintImmediately(processGraph.getBounds());
                processGraph.refreshTransitionGraph();

                // 设置流程标识为保存在远程
                BPD.getInstance().getActivedProcessEditor().setProcessFlag(BPDConstants.PROCESS_REMOTE);
                // 将工作流图形设置为没有改变
                BPD.getInstance().getActivedProcessEditor().setProcessModified(false);
                ProcessEditor processEditor = BPD.getInstance().getActivedProcessEditor();

                // 将打开流程存入远程正在编辑流程集合
                BPD.getInstance().getRemoteEditingProcessMap().put(processDefVersionId, processEditor);

                // 刷新流程树列表
                // packageEditor.getRemotePackageTreePanel()
                // .refreshPackageTreePanel();
                // 刷新打开流程编辑界面
                // packageEditor.reOverview();
                BPD.getInstance().getActivedProcessEditor().valueChanged(null);
                // packageEditor.reOverview();

            }

        }

    }

    private void openWorkflow(Package pkg) {

        packageEditor.setNewPackage(pkg, true);
        // 创建工作流节点
        WorkflowManager workflowManager = new WorkflowManager(null, packageEditor);
        WorkflowProcesses wps = (WorkflowProcesses) pkg.get("WorkflowProcesses");
        Iterator it = wps.toCollection().iterator();
        com.ds.bpm.bpd.graph.Process mainpr = null;
        for (; it.hasNext(); ) {
            // 创建新的工作流之前，设置当前激活工作流为null
            BPD.getInstance().setActivedProcessEditor(null);
            WorkflowProcess wp = (WorkflowProcess) it.next();
            wp.setNew(false);
            com.ds.bpm.bpd.graph.Process pr = workflowManager.insertProcess(wp, false);
            pr.setUserObject(wp);
            pr.createWorkflowGraph(packageEditor.getWindow());
            packageEditor.putProcessObjectMapping(wp, pr);
            String processDefVersionId = wp.getVersionID();
            this.getRomveWorkflowProcessMap().put(processDefVersionId, wp);
            if (!wp.isSubFlow()) {
                mainpr = pr;
            }
            mainpr.showProcess();
            // 当前工作流的图形界面与图形按钮进行绑定
            ProcessGraph processGraph = (ProcessGraph) mainpr.getImplementationEditor().getGraph();
            processGraph.setMarqueeHandler(new BPDMarqueeHandler(processGraph));
            // 修改主界面状态栏信息
            packageEditor.getStatusBar().updateMessage();
            processGraph.paintImmediately(processGraph.getBounds());
            processGraph.refreshTransitionGraph();
        }

    }

    // 验证流程的合法性
    public boolean validateWorkflowProcess(Package pkg) {
        ValidationErrorDisplay ved = null;
        boolean validationStatus = BPDConfig.getInstance().getValidationStatus();
        PackageValidator pv = new PackageValidator(pkg, false, true, true, true);
        if (validationStatus && !pv.validateAll(true)) {
            Map xpdlSchemaValidationErrors = pv.getXPDLSchemaValidationErrors();
            Map connectionErrors = pv.getGraphsConnectionErrors(pkg);
            List basicGraphConformanceErrors = pv.getBasicGraphConformanceErrors(pkg);
            Map graphConformanceErrors = pv.getGraphConformanceErrors(pkg);
            Map logicErrors = pv.getLogicErrors(pkg);

            // Prints connection error messages contained in a given Hashtable.
            // Hashtable has activity elements as a keys and it's error
            // connection messages as a values.
            String title = ResourceManager.getLanguageDependentString("DialogValidationReport");
            ved = new ValidationErrorDisplay(xpdlSchemaValidationErrors, connectionErrors, basicGraphConformanceErrors,
                    graphConformanceErrors, logicErrors, mainFrame, title, true);
        }
        if (ved == null || !ved.hasBeenStoped()) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Used to open new document when some other document is beeing edited (called
     * from New and OpenLocal actions). 打开本地文件，构建Package类，如果没有打开本地文件，则新建Package类
     */
    public Package openDocument(String filename, boolean clearOtherPackages,
                                boolean openFromStream) {
        this.filename = filename;
        Package pkg = null;
        if (clearOtherPackages) {
            xmlInterface.closeAllPackages();
        }
        if (filename != null) {
            pkg = xmlInterface.openPackage(filename, openFromStream);
        }
        if (pkg == null) {
            pkg = new Package(xmlInterface);
        }
        return pkg;
    }

    // ********************************** DIALOGS
    // *********************************

    /**
     * Show a file open dialog and return the filename.
     * 打开文件选择框，返回选择文件的文件名称，用于打开或者保存文件
     */
    public String openDialog(String message) {
        return XMLUtil.dialog(mainFrame, message, 0, 0, null);
    }

    public String addForm(String path) {

        String fileName = XMLUtil.dialog(mainFrame, "选择表单", 0, 4, null);
        if (fileName != null) {
            String formcontent = readFile(fileName, "UTF-8");

            Form form = Form.form();


            String server = BPDConfig.getInstance().getServerName();
            String port = BPDConfig.getInstance().getServerPort();
            String serverUrl = "http://" + server + ":" + port + "/fdt/formeditor/bpdposteddata.jsp";

            //PostMethod post = new PostMethod(serverUrl +);

            Map paramsMap = new HashMap();
            File file = new File(fileName);

            String formName = file.getName();
            paramsMap.put("formcontent", java.net.URLEncoder.encode(formcontent));
            paramsMap.put("path", path);
            final WorkflowProcess process = (WorkflowProcess) this.getActivedProcessEditor().getGraph()
                    .getPropertyObject();
            paramsMap.put(JDSContext.SYSCODE, process.getSystemCode());
            paramsMap.put("personId", this.getUserInfo().getId());
            paramsMap.put("formName", java.net.URLEncoder.encode(formName));

            for (Iterator<String> it = paramsMap.keySet().iterator(); it.hasNext(); ) {

                String key = it.next();


                form.add(key, paramsMap.get(key).toString());
            }


            Request request = Request.Post(serverUrl).bodyForm(form.build(), Charset.forName("utf-8"));

        }
        return fileName;

    }

    public String readFile(String filePathAndName, String encoding) {

        encoding = encoding.trim();
        StringBuffer str = new StringBuffer("");
        String st = "";
        FileInputStream fs = null;
        InputStreamReader isr = null;
        try {
            fs = new FileInputStream(filePathAndName);
            if (encoding.equals("")) {
                isr = new InputStreamReader(fs);
            } else {
                isr = new InputStreamReader(fs, encoding);
            }
            st = IOUtility.toString(isr);
        } catch (IOException es) {
            st = "";
        } finally {
            IOUtility.shutdownStream(fs);
            if (isr != null) {
                try {
                    isr.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return st;
    }

    /* Show a file save dialog and return the filename. */
    public String saveDialog(String message, int filteringMode, String initialName) {
        return XMLUtil.dialog(mainFrame, message, 1, filteringMode, initialName);
    }

    /* Show a dialog with the given error message. */
    public void message(String message, int type) {
        JOptionPane.showMessageDialog(mainFrame, message, BPD.getAppTitle(), type);
    }

    public void setRecentFilesMenu(JMenu rfm) {
        recentFilesMenu = rfm;
    }

    /**
     * Reacts upon the XML element change by setting isModified flag of
     * PackageEditor if needed.
     */
    public void xmlElementChanged(XMLElement el) {
        if (!(((el instanceof XMLCollection) && !(el instanceof ExternalPackages)
                && !el.getClass().getName().startsWith("com.ds.bpm.bpd.xml.elements.Activity$"))
                || (el instanceof Responsible) || (el instanceof ExtendedAttribute) || (el instanceof DataTypes)
                || (el instanceof EnumerationValue) || (el instanceof Tool) || (el instanceof Service)
                || (el instanceof Device) || (el instanceof Event) || (el instanceof ActualParameter)
                || (el instanceof ExternalProcesses) || (el instanceof Deadline)
                || el.getClass().getName().startsWith("com.ds.bpm.bpd.xml.panels.XMLListChoiceControlPanel$"))) {
            setModified(true);
        }
        // if (!BPDConfig.getInstance().getStatusBarStatus())
        // return;
        // status bar update
        if (el instanceof Activity || el instanceof Transition) {
            packageEditor.getStatusBar().updateMessage();
            XMLCollectionElement actOrTrans = (XMLCollectionElement) el;
            com.ds.bpm.bpd.graph.Process pr = null;

            if (actOrTrans.getCollection().getOwner() instanceof WorkflowProcess) {
                pr = packageEditor.getProcessObject((WorkflowProcess) actOrTrans.getCollection().getOwner());
                WorkflowProcess wp = (WorkflowProcess) actOrTrans.getCollection().getOwner();
                if (el instanceof Activity) {
                    Activity activity = (Activity) el;
                }
                // this.isModified()
                // JPanel errJPanel=getErrTablePanel().getTablePanel();
                // packageEditor.errPanel=errJPanel;
                // packageEditor.graphMainsplitPane.setBottomComponent(errJPanel);
                pr.getImplementationEditor().getStatusBar().updateMessage();
            } else {
                ActivitySet actSet = (ActivitySet) actOrTrans.getCollection().getOwner();
                pr = packageEditor.getProcessObject((WorkflowProcess) actSet.getCollection().getOwner());
                Set baObjects = pr.getImplementationEditor().getGraph().getWorkflowManager().getBlockActivities(true);
                // iterate through all block activity objects, get their editors
                // and
                // call change language on them
                Iterator baObjs = baObjects.iterator();
                while (baObjs.hasNext()) {
                    com.ds.bpm.bpd.graph.BlockActivity ba = (com.ds.bpm.bpd.graph.BlockActivity) baObjs.next();
                    ProcessEditor bae = ba.getImplementationEditor();
                    if (bae != null) {
                        Object xpdlObj = bae.getGraph().getXPDLObject();
                        if (xpdlObj.equals(actSet)) {
                            bae.getStatusBar().updateMessage();
                        }
                    }
                }
            }
        }
        if (el instanceof Package) {
            packageEditor.getStatusBar().updateMessage();
        }

    }

    /**
     * Processes conformance class attribute, compares it with mandatory default,
     * and performs appropriate actions.
     */
    private void processConformanceClassAttribute(Package pkg) {
        ConformanceClass cc = (ConformanceClass) pkg.get("ConformanceClass");
        String gct = cc.get("GraphConformance").toValue().toString();
        int mct = XMLUtil.getConformanceClassNo(mandatoryConformanceClass);
        int ct = XMLUtil.getConformanceClassNo(gct);
        if (mct > 0) {
            if (mct != ct) {
                // message(ResourceManager.getLanguageDependentString("WarningYouHaveOpenedPackageWithConformanceClassDiferentThenMandatoryOne"),
                // JOptionPane.WARNING_MESSAGE);
            } else {
                cc.setReadOnly(true);
            }
        }
    }

    public String getMandatoryConformanceClass() {
        return mandatoryConformanceClass;
    }

    /**
     * Main method.
     */
    public static void main(String[] args) {

        Icon icon = new ImageIcon(ResourceManager.getResource("SplashImage"));
        splash = new BPDSplash(icon, ResourceManager.getLanguageDependentString("SplashScreen.Startup"), null);
        splash.setVisible(true);
        // Starting file name
        // String fn = null;
        // Starting locale
        String sl = null;
        // Mandatory conformance class
        String mcc = null;
        // Startup parameters:
        // -sl STARTING_LOCALE
        // -mcc MANDATORY_CONFORMANCE_CLASS
        if (args != null && args.length > 0) {
            splash.showStatus(ResourceManager.getLanguageDependentString("SplashScreen.ParseConsoleArg"), 3);
            for (int i = 0; i < args.length; ++i) {
                if (args[i].compareTo("-mcc") == 0) {
                    if (++i == args.length) {
                        System.err.println("error: Missing argument to -mcc option.");
                        continue;
                    }
                    mcc = args[i];
                    String oldMCC = BPDConfig.getInstance().getMandatoryConformanceClass();
                    BPDConfig.getInstance().setMandatoryConformanceClass(mcc);
                    // mandatoryConformanceClass =
                    // BPDConfig.getInstance().getMandatoryConformanceClass();
                    BPDConfig.getInstance().setMandatoryConformanceClass(oldMCC);
                }
                if (args[i].compareTo("-sl") == 0) {
                    if (++i == args.length) {
                        System.err.println("error: Missing argument to -sl option.");
                        continue;
                    }
                    sl = args[i];
                    try {
                        PFLocale pfl = PFLocale.createPFLocale(sl);
                        if (pfl == null) {
                            pfl = new PFLocale(Locale.getDefault());
                        }
                        ResourceManager.setChoosen(pfl.getLocale());
                    } catch (Exception ex) {
                        System.err.println("warning: Can't start with locale " + sl);
                    }
                }
            }
            // check if there is a file that should be open at the startup
            /*
             * if (args.length / 2 != (args.length / 2.0)) { fn = args[args.length - 1]; }
             */
        } else {
            try {
                // PFLocale pfl = PFLocale.createPFLocale("en");
                PFLocale pfl = new PFLocale("cn");
                pfl = new PFLocale(Locale.getDefault());
                ResourceManager.setChoosen(pfl.getLocale());

            } catch (Exception ex) {
                System.err.println("warning: Can't start with locale " + sl);
            }
        }

        // first the singleton object must be created, and after that
        // it is initialized because within init method, some BPD
        // methods are called, which would cause reinitialization
        splash.showStatus(ResourceManager.getLanguageDependentString("SplashScreen.InitialFrame"), 4);


        // 初始化总线环境
        try {

            EsbFactory.initBus();
            JDSServer.getInstance();

//
//            List<BUSBean> list = EsbBeanFactory.getInstance().getExpressionTempBeanList();
//            for (int k = 0; k < list.size(); k++) {
//                if (!(list.get(k) instanceof ExpressionTempBean)) {
//                    continue;
//                }
//                ExpressionTempBean bean = (ExpressionTempBean) list.get(k);
//                System.out.println(bean.getName() + bean.getExpressionArr());
//            }
            //  JDSServer.getClusterClient().getUDPClient().clientLogin(UserBean.getInstance());

            BPD.bpd = BPD.getInstance(true);
            BPD.bpd.init(true);
            splash.showStatus(ResourceManager.getLanguageDependentString("SplashScreen.Finish"), 100);
            splash.setVisible(false);
            splash = null;
            bpd.getPackageEditor().showWindow(bpd.getPackageEditor().getTitle());


            Dimension dialogDimension = new Dimension(300, 200);
            JFrame frame = (JFrame) bpd.getPackageEditor().getWindow();
            String title = ResourceManager
                    .getLanguageDependentString("RemoteLogin.Name.display");

            final LoginDialog loginDlg = new LoginDialog(frame, title, true);
            loginDlg.setSize(dialogDimension);
            loginDlg.setLocationRelativeTo(frame);
            Utils.center(loginDlg, 100, 100);

            //	loginDlg.show();
            loginDlg.autoRun();


        } catch (Exception e) {
            e.printStackTrace();
        }


    }

    /**
     * 设置当前正在编辑的流程界面
     *
     * @param packageEditor current actived processEditor
     */
    public void setPackageEditor(PackageEditor packageEditor) {
        this.packageEditor = packageEditor;
    }

    /**
     * 设置当前正在编辑的流程界面
     *
     * @param processEditor current actived processEditor
     */
    public void setActivedProcessEditor(ProcessEditor processEditor) {
        this.activedProcessEditor = processEditor;
    }

    /**
     * 获得当前正在编辑的流程界面
     *
     * @return activedProcessEditor current actived processEditor
     */
    public ProcessEditor getActivedProcessEditor() {

        return this.activedProcessEditor;
    }

    /**
     * 设置用户登陆标志.
     *
     * @param isLogin 用户登陆标志
     */
    public void setLoginFlag(boolean isLogin) {
        if (this.isLogin != isLogin) {
            this.isLogin = isLogin;
        }
    }

    public void fillUser() {
        MinServerActionContextImpl context = (MinServerActionContextImpl) JDSActionContext.getActionContext();
        try {
            context.setSessionId(JDSServer.getInstance().getAdminUser().getSessionId());
            context.getParamMap().put(JDSContext.SYSCODE, JDSServer.getInstance().getAdminUser().getSystemCode());
        } catch (JDSException e) {
            e.printStackTrace();
        }

        context.getSession().put("JDSUSERID", UserBean.getInstance().getPersonid());
        context.getParamMap().put("JDSUSERID", UserBean.getInstance().getPersonid());
//
//        JDSClientService clientService = EsbUtil.parExpression(JDSClientService.class);
//        if (clientService.getConnectInfo() == null) {
//            try {
//                Person person = OrgManagerFactory.getOrgManager().getPersonByID(JDSServer.getInstance().getAdminUser().getId());
//                ConnectInfo connectInfo = new ConnectInfo(person.getID(), person.getAccount(), person.getPassword());
//                clientService.connect(connectInfo);
//            } catch (PersonNotFoundException e) {
//                e.printStackTrace();
//            } catch (JDSException e) {
//                e.printStackTrace();
//            }
//
//        }
    }

    /**
     * 获得用户是否登陆标志.
     *
     * @return isLogin
     */
    public boolean isLogined() {
        return isLogin;
    }

    /**
     * 获得WebService实例.
     *
     * @return webServiceClient
     */
    public CtBPDService getBPDService() {
        fillUser();
        if (this.ctService == null) {
            BPDService service = (BPDService) EsbUtil.parExpression("$BPDService");
            this.ctService = new CtBPDServiceImpl(service);
        }

        return ctService;

    }

    /**
     * 返回xpdlFilePathMap对象集合
     *
     * @return xpdlFilePathMap
     */
    public Map getXpdlFilePathMap() {
        return xpdlFilePathMap;
    }

    /**
     * 返回localEditingProcessMap对象集合
     *
     * @return localEditingProcessMap
     */
    public Map getLocalEditingProcessMap() {
        return localEditingProcessMap;
    }

    /**
     * 返回remoteProcessMap对象集合
     *
     * @return remoteProcessMap
     */
    public Map getRemoteProcessMap() {
        return remoteProcessMap;
    }

    /**
     * 设置远程流程列表，remoteProcessMap对象集合
     */
    public void setRemoteProcessMap(List<ProcessDef> remoteProcessDefList) {
        remoteProcessMap.clear();
        if (remoteProcessDefList != null) {
            for (ProcessDef processDef : remoteProcessDefList) {
                remoteProcessMap.put(processDef.getProcessDefId(), processDef);

            }
        }
    }

    /**
     * 返回remoteEditingProcessMap对象集合
     *
     * @return remoteEditingProcessMap
     */
    public Map<String, ProcessEditor> getRemoteEditingProcessMap() {
        return remoteEditingProcessMap;
    }

    /**
     * 设置登陆用户信息对象.
     *
     * @param userinfo 用户信息
     */
    public void setUserInfo(UserInfo userinfo) {
        this.userinfo = userinfo;
    }

    /**
     * 获得登陆用户信息对象.
     *
     * @return userinfo
     */
    public UserInfo getUserInfo() {
        return userinfo;
    }

    /**
     * 获取帮助代理对象
     *
     * @return HelpBroker
     */
    public HelpBroker getHelpBroker() {
        return hb;
    }

    // 把工作流信息保存成String形式
    public String saveWFToString(Package pkg) {
        String ret = "";
        if (!packageEditor.isInitialized()) {
            packageEditor.initialize();
        }
        try {
            // 检查用户是否配置了应用
            Iterator wpCln = ((WorkflowProcesses) pkg.get("WorkflowProcesses")).toCollection().iterator();
            if (wpCln.hasNext()) {
                WorkflowProcess wp = (WorkflowProcess) wpCln.next();
                if (wp.getAppName().trim().equals("")) {
                    JOptionPane.showMessageDialog(BPD.getInstance().getPackageEditor().getWindow(),
                            ResourceManager.getLanguageDependentString("WarningAppIsNotConfiged"), BPD.getAppTitle(),
                            JOptionPane.WARNING_MESSAGE);
                    return "";
                }
            }

            // Package pkg =
            // BPD.getInstance().getActivedProcessEditor().getGraph().getXMLPackage();
            // com.ds.bpm.bpd.xml.elements.Package pkg =
            // packageEditor.getXMLPackage();

            // if (BPD.getInstance().validateWorkflowProcess(pkg)) {
            Save.updateExtendedAttributesForWorkflowProcesses(pkg);
            // set the XPDL version to 1.0
            PackageHeader ph = (PackageHeader) pkg.get("PackageHeader");
            ph.set("XPDLVersion", "1.0");
            Document document = null;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dbuilder = dbf.newDocumentBuilder();
            document = dbuilder.newDocument();
            OutputStream os = new ByteArrayOutputStream();
            pkg.toXML(document);

//	 // Use a Transformer for output
//		TransformerFactory tFactory = TransformerFactory.newInstance();
//		Transformer transformer = tFactory.newTransformer();
//		transformer.setOutputProperty("indent", "yes");
//		transformer.setOutputProperty(
//				"{http://xml.apache.org/xslt}indent-amount", "4");
//		transformer.setOutputProperty("encoding", BPDConfig
//				.getInstance().getEncoding());
//		// if (editor instanceof ProcessEditor) {
//		transformer.setOutputProperty("omit-xml-declaration", "yes");
//		// }
//		DOMSource source = new DOMSource(document);
//		StreamResult result = new StreamResult(baos);
//
//		transformer.transform(source, result);
//		String text=baos.toString(BPDConfig.getInstance()
//				.getEncoding());

            // Use a Transformer for output


            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            // transformer.setOutputProperty("indent", "yes");
            // transformer.setOutputProperty(Sys.Vendor
            // "{http://xml.apache.org/xslt}indent-amount", "4");

            //String charSet = ResourceManager.getLanguageDependentString("Sys.Encoding");

            String charSet = "utf-8";
            transformer.setOutputProperty("encoding", charSet);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            ret = os.toString();
            os.close();

            /*
             * } else { String msg =
             * ResourceManager.getLanguageDependentString("ErrorCannotSaveIncorrectPackage")
             * ; BPD.getInstance().message(msg, JOptionPane.ERROR_MESSAGE); }
             */
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public Package wf2Package(String wfStr) {
        StringBuffer sb = new StringBuffer();
        sb.append("<Package Id=\"" + UUID.randomUUID().toString()
                + "\" xmlns=\"http://www.wfmc.org/2005/XPDL2.0\" xmlns:itjds=\"http://www.itjds.net\" xmlns:xpdl=\"http://www.wfmc.org/20052/XPDL2.0\" xmlns:xsi=\"http://www.w3.org/2005/XMLSchema-instance\" xsi:schemaLocation=\" http://www.wfmc.org/2005/XPDL2.0 http://wfmc.org/standards/docs/TC-1025_schema_20_xpdl.xsd\">");
        sb.append(wfStr);
        sb.append("</Package>");
        // System.out.println(sb.toString());
        Package pkg = openDocument(sb.toString(), false, true);
        return pkg;
    }

    // 把XPDL字符串解析成工作流对象
    public void openWFFromString(String wfStr) {
        StringBuffer sb = new StringBuffer();
        sb.append("<Package Id=\"" + UUID.randomUUID().toString()
                + "\" xmlns=\"http://www.wfmc.org/2005/XPDL2.0\" xmlns:itjds=\"http://www.itjds.net\" xmlns:xpdl=\"http://www.wfmc.org/20052/XPDL2.0\" xmlns:xsi=\"http://www.w3.org/2005/XMLSchema-instance\" xsi:schemaLocation=\" http://www.wfmc.org/2005/XPDL2.0 http://wfmc.org/standards/docs/TC-1025_schema_20_xpdl.xsd\">");
        sb.append(wfStr);
        sb.append("</Package>");
        // System.out.println(sb.toString());
        Package pkg = openDocument(sb.toString(), false, true);
        WorkflowProcesses wps = (WorkflowProcesses) pkg.get("WorkflowProcesses");
        // if (validateWorkflowProcess(pkg)) {
        Iterator wpCln = wps.toCollection().iterator();
        packageEditor.setNewPackage(pkg, true);
        packageEditor.setXMLPackage(pkg);

        for (int k = 0; wpCln.hasNext(); k++) {
            WorkflowProcess wp = (WorkflowProcess) wpCln.next();
            String processDefVersionId = wp.getVersionID();

            if (isProcessOpenedAfresh(BPDConstants.PROCESS_REMOTE, processDefVersionId)) {
                this.getRomveWorkflowProcessMap().put(processDefVersionId, wp);
                if (wp.isSubFlow()) {
                    openRomveWorkflow(processDefVersionId, false);
                }
            }
        }
        // 重新打开主流程

        WorkflowProcess mainProcess = (WorkflowProcess) (wps.getMainProceList()).get(0);
        String mainProcessDefVersionId = mainProcess.getVersionID();
        openRomveWorkflow(mainProcessDefVersionId, true);
        /*
         * } else { message(ResourceManager.getLanguageDependentString(
         * "InformationErrorWhileOpeningFile"), JOptionPane.INFORMATION_MESSAGE); }
         */
    }

    // Clone xpdl文件中的WorkflowProcess
    public void cloneWorkflowProcess(String wfStr) {
        StringBuffer sb = new StringBuffer();
        sb.append("<Package Id=\"" + UUID.randomUUID().toString()
                + "\" xmlns=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:itjds=\"http://www.itjds.net\" xmlns:xpdl=\"http://www.wfmc.org/2002/XPDL1.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\" http://www.wfmc.org/2002/XPDL1.0 http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd\">");
        sb.append(wfStr);
        sb.append("</Package>");
        // System.out.println(sb.toString());
        Package pkg = openDocument(sb.toString(), false, true);
        // if (validateWorkflowProcess(pkg)) {
        Iterator wpCln = ((WorkflowProcesses) pkg.get("WorkflowProcesses")).toCollection().iterator();
        Package newPkg = BPD.getInstance().openDocument(null, false, false);
        WorkflowProcesses wps = (WorkflowProcesses) newPkg.get("WorkflowProcesses");
        // 存储克隆后新旧WorkflowFlowPorcessId的对应关系
        Map cloneWPId = new HashMap();
        // 存储子流程对应的关系
        Map cloneAcId = new HashMap();
        for (int k = 0; wpCln.hasNext(); k++) {
            WorkflowProcess wp = (WorkflowProcess) wpCln.next();
            // 获得流程包
            // 创建新的工作流
            WorkflowProcess newWp = (WorkflowProcess) wp.clone();
            cloneWPId.put(newWp.getID(), wp.getID());
            newWp.addVersion(Integer.parseInt(newWp.getVersionNumber()) + 1);
            newWp.setCollection(wps);
            newWp.setPackage(newPkg);
            newWp.setNew(true);
            wps.add(newWp);
            Activities activities = wp.getActivities();
            Iterator it = activities.toCollection().iterator();
            for (int j = 0; it.hasNext(); j++) {
                Activity activity = (Activity) it.next();
                SubFlow subFlow = activity.getSubflow();
                if (subFlow != null) {
                    String wpId = subFlow.getAttrId();
                    cloneAcId.put(wp.getID() + j, wpId);
                }
            }
        }

        Iterator newWpCln = wps.toCollection().iterator();
        for (int k = 0; newWpCln.hasNext(); k++) {
            WorkflowProcess wp = (WorkflowProcess) newWpCln.next();
            Activities activities = wp.getActivities();
            Iterator it = activities.toCollection().iterator();
            for (int j = 0; it.hasNext(); j++) {
                Activity activity = (Activity) it.next();
                SubFlow subFlow = activity.getSubflow();
                if (subFlow != null) {
                    String oldWPId = (String) cloneWPId.get(wp.getID());
                    String newWpid = (String) cloneAcId.get(oldWPId + j);
                    subFlow.setAttrId(newWpid);
                }
            }

            String processDefVersionId = wp.getVersionID();
            if (isProcessOpenedAfresh(BPDConstants.PROCESS_REMOTE, processDefVersionId)) {
                this.getRomveWorkflowProcessMap().put(processDefVersionId, wp);
                if (wp.isSubFlow()) {
                    packageEditor.setNewPackage(pkg, false);
                    openRomveWorkflow(processDefVersionId, false);
                }
            }
        }
        // 重新打开主流程

        WorkflowProcess mainProcess = (WorkflowProcess) (wps.getMainProceList()).get(0);
        String mainProcessDefVersionId = mainProcess.getVersionID();
        openRomveWorkflow(mainProcessDefVersionId, true);

    }

    public void initHelpSystem(JFrame frame) {
        // Find the HelpSet file and create the HelpSet object:
        String helpHS = "com/ds/bpm/bpd/help/BPDHelpSet.hs";
        ClassLoader cl = BPD.class.getClassLoader();
        try {
            URL hsURL = HelpSet.findHelpSet(cl, helpHS, ResourceManager.getChoosenLocale());
            hs = new HelpSet(cl, hsURL);
        } catch (Exception ee) {
            // Say what the exception really is
            System.out.println("HelpSet " + ee.getMessage());
            System.out.println("HelpSet " + helpHS + " not found");
            return;
        }
        if (hs != null) {
            // Create a HelpBroker object:
            hb = hs.createHelpBroker();

            // Center help window
            hb.setSize(new Dimension(800, 600));
            Dimension dimScreen = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimFrame = hb.getSize();
            hb.setLocation(new Point((dimScreen.width - dimFrame.width) / 2, (dimScreen.height - dimFrame.height) / 2));

            // Get help menubar item
            JMenuItem helpMenu = (JMenuItem) packageEditor.getMenuItem("HelpTutorial");
            hb.enableHelpOnButton(helpMenu, "top", hs);

            // Enable window?level help on RootPane
            hb.enableHelpKey(frame.getRootPane(), "top", null);

            // Regist direct help listener
            JMenuItem directHelpMenu = (JMenuItem) packageEditor.getMenuItem("DirectHelp");
            directHelpMenu.addActionListener(new CSH.DisplayHelpAfterTracking(hb));

            // Set help id string
            // CSH.setHelpIDString(newtext, "browse.strings");*/
        }
    }

    /**
     * 获得远程流程定义信息集
     *
     * @return piVector
     * @throws JDSException
     */
    public List<ProcessDef> getRemoteProcessDefList(Boolean reLoad) {

        if (this.processDefList == null || reLoad) {
            this.processDefList = new ArrayList<ProcessDef>();
            try {
                processDefList = getBPDService().getProcessDefList(null);
            } catch (JDSException e) {
                getBPDService().handleWebServiceException(e);
            }

        }
        return processDefList;
    }

    /**
     * 获得远程流程定义信息集
     *
     * @return piVector
     */
    public String getPackProcessDefList(String processdefList) {

        String xpdl = "";
        try {
            xpdl = getBPDService().getProcessDefListFromDB(processdefList);
        } catch (JDSException e) {
            getBPDService().handleWebServiceException(e);
        }

        return xpdl;
    }

    /**
     * 验证是否重新打开流程
     *
     * @param processDefVersionId 流程ID
     * @return openProcessFlag
     */
    public boolean isProcessOpenedAfresh(String processFlag, String processDefVersionId) {
        Map processMap = new HashMap();
        boolean openProcessFlag = false;
        boolean processIsOpened = false;
        if (processFlag.equals(BPDConstants.PROCESS_LOCAL)) {
            processMap = BPD.getInstance().getLocalEditingProcessMap();
            if (packageEditor.getContentTabbedPane()
                    .indexOfComponent((ProcessEditor) processMap.get(processDefVersionId)) != -1) {
                processIsOpened = true;
            }
        } else if (processFlag.equals(BPDConstants.PROCESS_REMOTE)) {
            processMap = BPD.getInstance().getRemoteEditingProcessMap();
            processIsOpened = true;
        }
        if (processMap.containsKey(processDefVersionId) && processIsOpened) {
            int flag = JOptionPane.showConfirmDialog(packageEditor.getWindow(),
                    ResourceManager.getLanguageDependentString("MessageProcessDefIsRefreshed"), BPD.getAppTitle(),
                    JOptionPane.YES_NO_OPTION);
            if (flag == JOptionPane.YES_OPTION) {
                BPD.getInstance().getPackageEditor().getContentTabbedPane()
                        .remove((ProcessEditor) processMap.get(processDefVersionId));
                openProcessFlag = true;
            }
        } else {
            openProcessFlag = true;
        }
        return openProcessFlag;
    }

    // 创建默认应用配置文件
    private void createDefaultConfigFile() {
        String cfPath = BPDConstants.BPD_USER_HOME + "/" + PluginManager.appFileName;
        File cf = new File(cfPath);
        if (!cf.exists()) {
            try {
                PrintWriter pw = new PrintWriter(new FileOutputStream(cf));
                pw.print("<Application/>");
                pw.close();
            } catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 指定所有打开流程的登录编辑用户
     */
    public void setLoginedUserForOpenedProcesses() {
        JTabbedPane ctp = packageEditor.getContentTabbedPane();
        Component[] processEditorArray = (Component[]) ctp.getComponents();
        for (int i = 0; i < processEditorArray.length; i++) {
            ProcessEditor processEditor = ((ProcessEditor) processEditorArray[i]);
            processEditor.setLoginedUserForProcess();
        }
    }

    public void refreshModel() {
        setAppTitle(ResourceManager.getLanguageDependentString("Title"));
    }

    public Map getActMap() {
        return actMap;
    }

    public void setSelectionCells(Set wc, boolean refesh) {
        getActivedProcessEditor().getGraph().clearSelection();
        WorkflowManager wm = getActivedProcessEditor().getGraph().getWorkflowManager();
        Set graphObjects = new HashSet();
        Iterator it = wc.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Activity) {
                com.ds.bpm.bpd.graph.Activity gAct = wm.getActivity(((Activity) obj).getID());
                if (gAct != null) {

                    JScrollPane jsp = this.getActivedProcessEditor().graphScrollPane;
                    this.getActivedProcessEditor().graphScrollPane.setAlignmentX(gAct.getXOff());
                    this.getActivedProcessEditor().graphScrollPane.setAlignmentY(gAct.getYOff());
                    this.getActivedProcessEditor().graphScrollPane.getHorizontalScrollBar().getModel()
                            .setValue(gAct.getXOff());
                    this.getActivedProcessEditor().graphScrollPane.getVerticalScrollBar().getModel()
                            .setValue(gAct.getYOff());
                    this.getActivedProcessEditor().graphScrollPane.updateUI();
                    graphObjects.add(gAct);
                    if (refesh) {
                        XMLUtil.setSelectCell(graphObjects.toArray()[0]);
                    }

                }
            } else if ((obj instanceof Start) || (obj instanceof End)) {
                graphObjects.add(obj);
            } else if (obj instanceof Transition) {
                Object gTrans = wm.getTransition(((Transition) obj).getID());
                if (gTrans != null) {
                    graphObjects.add(gTrans);
                }
            } else if (obj instanceof Participant) {
                Object gPart = wm.getParticipant(((Participant) obj).getID());
                if (gPart != null) {
                    graphObjects.add(gPart);
                }
            }
        }
        getActivedProcessEditor().getGraph().setSelectionCells(graphObjects.toArray());
        this.getActivedProcessEditor().getGraph().getSelectionCell();

        // getActivedProcessEditor().getGraph()
        // .setSelectionCells(graphObjects.toArray());
        // this.getActivedProcessEditor().getGraph().getSelectionCell();
        // getActivedProcessEditor().valueChanged(null);

    }

    /**
     * 刷新已经打开在显示面板中的流程
     */
    public void refreshOpenedWorkflowProcess() {
        // 保存在服务器端的流程
        List<ProcessDefVersion> allFlowVersionList = new ArrayList<ProcessDefVersion>();
        for (Iterator it = remoteProcessMap.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            ProcessDef processDef = (ProcessDef) entry.getValue();
            List<ProcessDefVersion> versionList = new ArrayList<ProcessDefVersion>();
            try {
                versionList = processDef.getAllProcessDefVersions();
            } catch (BPMException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } // .getProcessDefVersionList();
            allFlowVersionList.addAll(versionList);
        }
        // BPD打开的远端流程
        for (Iterator it = remoteEditingProcessMap.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            String versionId = (String) entry.getKey();
            ProcessEditor editor = (ProcessEditor) entry.getValue();
            WorkflowProcess wp = (WorkflowProcess) editor.getGraph().getPropertyObject();
            for (ProcessDefVersion processDefVersion : allFlowVersionList) {

                if (processDefVersion.getProcessDefVersionId().equals(versionId)) {
                    wp.setPublicationStatus(processDefVersion.getPublicationStatus());
                    wp.setActiveTime(DateUtility.formatDate(processDefVersion.getActiveTime(), "yyyy-MM-dd HH:mm:ss"));
                    wp.setFreezeTime(DateUtility.formatDate(processDefVersion.getFreezeTime(), "yyyy-MM-dd HH:mm:ss"));
                }
            }
        }
    }

    public XMLInterface getXMLInterface() {

        return this.xmlInterface;
    }


    public JFrame getMainFrame() {
        return mainFrame;
    }

    public void setMainFrame(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }
}
