/* AbstractGraph.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：工作流图形界面的抽象类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 */
package com.ds.bpm.bpd;

import com.ds.bpm.bpd.graph.Transition;
import com.ds.bpm.bpd.graph.TransitionView;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.enums.route.RouteDirction;
import org.jgraph.JGraph;
import org.jgraph.graph.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * Abstract implementation of JGraph.
 */
public abstract class AbstractGraph extends JGraph implements WorkflowElement {
	protected XMLComplexElement xmlObject = null;

	/** WorkflowManager that controls various things */
	protected transient WorkflowManager workflowManager;

	/** Reference to editor */
	protected transient AbstractEditor editor;

	protected transient ProcessEditor processEditor;

	/**
	 */
	protected Map xpdlSchemaValidationErrors = null;

	/**
	 * The basic xpdl schema validation error.
	 */
	protected String basicXpdlSchemaValidationError = null;

	/**
	 * Map of activities as a keys and error messages as a values that represent
	 * wrong connected activities.
	 */
	protected Map graphConnectionErrors = null;

	/**
	 * The basic connection error that is written at the status bar.
	 */
	protected String basicGraphConnectionError = null;

	/**
	 * Map of activities as a keys and error messages as a values that represent
	 * activities that don't satisfy graph conformance.
	 */
	protected Map graphConformanceErrors = null;

	/**
	 * The list of basic graph conformance errors. First of them will be written
	 * in the status bar.
	 */
	protected java.util.List basicGraphConformanceErrors = null;

	/**
	 * Map of xml objects as keys and error messages as a values that represent
	 * some logic error.
	 */
	protected Map logicErrors = null;

	/**
	 * The basic logic error that is written at the status bar.
	 */
	protected String basicLogicError = null;

	/**
	 * Constructs workflow graph based on a given model.
	 */
	public AbstractGraph(GraphModel model, AbstractEditor editor) {
		selectionModel = new BPDGraphSelectionModel(this);
		setLayout(null);
		// setting marquee handler
		// marquee=new BasicMarqueeHandler();
		   GraphLayoutCache view = new GraphLayoutCache(this);//HM, JGraph3.4.1
		setGraphLayoutCache(view);
		updateUI();
		if (model == null) {
			model = new BPDGraphModel();
		}
		setModel(model);
		this.editor = editor;
		this.xmlObject=(XMLComplexElement) this.getPropertyObject();
		// creating participant manager
		workflowManager = new WorkflowManager(this);
		// setting new marquee handler (couldn't be set before
		// creation of WorkflowManager
		// setMarqueeHandler(new BPDMarqueeHandler(this));
		// initialization of main graph behaviour
		initGraphBehavior();
	}

	public AbstractGraph(GraphModel model, GraphLayoutCache view,
			AbstractEditor editor) {
		super(model, view);
		this.editor = editor;
	}

	public abstract com.ds.bpm.bpd.xml.elements.Package getXMLPackage();

	public abstract void setPropertyObject(XMLComplexElement ce);

	public abstract void createWorkflowGraph(Window pFrame);

	/**
	 * Overrides <code>JComponent</code>'s <code>getToolTipText</code>
	 * method in order to allow the graph controller to create a tooltip for the
	 * topmost cell under the mousepointer. This differs from JTree where the
	 * renderers tooltip is used.
	 * <p>
	 * NOTE: For <code>JGraph</code> to properly display tooltips of its
	 * renderers, <code>JGraph</code> must be a registered component with the
	 * <code>ToolTipManager</code>. This can be done by invoking
	 * <code>ToolTipManager.sharedInstance().registerComponent(graph)</code>.
	 * This is not done automatically!
	 * 
	 * @param event
	 *            the <code>MouseEvent</code> that initiated the
	 *            <code>ToolTip</code> display
	 * @return a string containing the tooltip or <code>null</code> if
	 *         <code>event</code> is null
	 */
	public abstract String getToolTipText(MouseEvent event);

	protected void initGraphBehavior() {
		setHandleSize(4);
		setTolerance(4);
	//	setSelectNewCells(true);
		setSizeable(false);
		setMoveable(false);
		selectionModel
				.setSelectionMode(GraphSelectionModel.SINGLE_GRAPH_SELECTION);
		refreshGraphConfiguration();
	}

	/**
	 * 刷新流程的图形配置
	 */
	public void refreshGraphConfiguration() {
		BPDConfig jcfg = BPDConfig.getInstance();
		boolean gs = jcfg.getGridStatus();
		setGridEnabled(gs);
		setGridVisible(gs);
		setGridSize(jcfg.getGridSize());
		setBackground(Utils.getColor(jcfg.getGraphBackgroundColor()));
		setHighlightColor(Utils.getColor(jcfg.getHighlightColor()));
		setGridColor(Utils.getColor(jcfg.getGridColor()));
		setHandleColor(Utils.getColor(jcfg.getHandleColor()));
		setMarqueeColor(Utils.getColor(jcfg.getMarqueeColor()));
		refreshTransitionGraph();
		//refreshActivitesGraph(null);
	}

	/**
	 * 刷新流程所有路由的颜色配置
	 */
	public void refreshTransitionGraph() {
		Set allTrans = BPDGraphModel.getAllTransitionsInModel(this.getModel());
		if (allTrans != null) {
			Iterator it = allTrans.iterator();
			Transition tran;
			String curID;
			while (it.hasNext()) {
				tran = (Transition) it.next();
				com.ds.bpm.bpd.xml.elements.Transition tranElement = (com.ds.bpm.bpd.xml.elements.Transition) tran
						.getPropertyObject();
				String attrDirection = tranElement
						.getAttributeValue("RouteDirection");
				String routeOrder = tranElement
				.getAttributeValue("Condition");
				CellView view = BPD.getInstance().getActivedProcessEditor()
						.getGraph().getGraphLayoutCache().getMapping(tran,
								false);
				TransitionView tv = (TransitionView) view;
				// 在进行子流程调用编辑时可能会出现NULL
				// 进行效验 ADD BY LIWENZHANG 06-02-21
				if (tv == null) {
					return;
				}
				Map map = tv.getAllAttributes();
				
				if (attrDirection
						.equals(RouteDirction.BACK.getType())) {					
					GraphConstants.setLineColor(map, Utils.getColor(BPDConfig
							.getInstance().getBackwardTransitionColor()));
				} else {
					GraphConstants.setLineColor(map, Utils.getColor(BPDConfig
							.getInstance().getTransitionColor()));
				}
				if (routeOrder !=null && !routeOrder.trim().equals("")){					
					GraphConstants.setLineWidth(map,3);
				}else{
					GraphConstants.setLineWidth(map,1);
				}
				
				tv.setAttributes(map);
				tv.refresh(false);
			}
		}
	}
	
	

	/**
	 * Overrides super method - don't need to waste a time for this.
	 */
	public static void addSampleData(GraphModel model) {
		return;
	}

	/** To satisfy interface */
	public void showPropertyDialog(Window parentWindow, AbstractGraph graph) {
	}

	/**
	 * Gets a property object (DTDElement).
	 */
	public XMLElement getPropertyObject() {
		return xmlObject;
	}

	/**
	 * Gets an XPDL object (DTDElement).
	 */
	public XMLElement getXPDLObject() {
		return xmlObject;
	}

	/**
	 * Gets an userObject property which name is given in parameter what.
	 */
	public XMLElement get(String what) {
		return ((XMLComplexElement) getPropertyObject()).get(what);
	}

	/**
	 * Sets an userObject property which name is given in parameter what to a
	 * value given in a parameter value.
	 */
	public void set(String what, Object value) {
		((XMLComplexElement) getPropertyObject()).set(what, value);
	}

	/**
	 * Gets a tooltip text for element.
	 */
	public String getTooltip() {
		return "";
	}

	/**
	 * Gets an editor object.
	 */
	public AbstractEditor getEditor() {
		return editor;
	}

	/**
	 * Gets an editor object.
	 */
	public abstract ProcessEditor getProcessEditor();

	/**
	 * Gets the WorkflowManager.
	 */
	public WorkflowManager getWorkflowManager() {
		return workflowManager;
	}

	/**
	 */
	public Map getXPDLSchemaValidationErrorMessages() {
		return xpdlSchemaValidationErrors;
	}

	/**
	 */
	public String getBasicXPDLSchemaValidationErrorMessage() {
		return basicXpdlSchemaValidationError;
	}

	/**
	 * Returns Map of activities as a keys and error message strings as a value.
	 * This Map represents wrong connected activities and should be called right
	 * after checkConnections method, otherwise you can get wrong results.
	 */
	public Map getConnectionErrorMessages() {
		return graphConnectionErrors;
	}

	/**
	 * Returns the basic connection error for the graph, or null if there are no
	 * errors;
	 */
	public String getBasicConnectionErrorMessage() {
		return basicGraphConnectionError;
	}

	public abstract boolean validateAgainsXPDLSchema();

	/**
	 * Checks workflow diagram and returns <code>true</code> if there are no
	 * wrong-connected or non-connected activities. When checking on block
	 * activity, there are two type's of check realized internaly by a block
	 * activity - the first is check of it's outer representation, and the
	 * second is check of it's inner representation. The eventual errors are
	 * reported as a Map and consists of wrong connected activities as a keys
	 * and String messages as a values and could be retrieved by a method
	 * getConnectionErrorMessages(). <BR>
	 * NOTE: You must call method getConnectionErrorMessages right after calling
	 * this check method, otherwise you can get wrong results.
	 */
	public abstract boolean checkConnections(boolean fullCheck);

	protected abstract boolean checkStartEndEndsConnections(boolean fullCheck);

	protected abstract void updateXMLObjectsBeforeChecking();

	/**
	 * Returns map of activities as a keys and error message strings as a value.
	 * This map represents activities that does not satisfy graph conformance,
	 * and should be called right after checkGraphConformance method,
	 * otherwiseyou can get wrong results.
	 */
	public Map getGraphConformanceErrorMessages() {
		return graphConformanceErrors;
	}

	/**
	 * Returns the message to be written in statusbar if graph is not
	 * conformant.
	 */
	public java.util.List getBasicGraphConformanceErrorMessages() {
		return basicGraphConformanceErrors;
	}

	/**
	 * Checks workflow diagram and returns <code>true</code> if it conforms to
	 * the specified type (fool-blocked, loop-blocked).When checking on block
	 * activity, there are two type's of check realized internaly by a block
	 * activity - the first is check of it's outer representation, and the
	 * second is check of it's inner representation. The errors are reported as
	 * a map and consists of improper activities as a keys and String messages
	 * as a values and could be retrieved by a method
	 * getConformanceErrorMessages(). <BR>
	 * NOTE: You must call method getGraphConformanceErrorMessages right after
	 * calling this check method, otherwise you can get wrong results.
	 */
	public abstract boolean checkGraphConformance(boolean fullCheck);

	/**
	 * Returns Map of xml objects as keys and error message strings as values.
	 */
	public Map getLogicErrorMessages() {
		return logicErrors;
	}

	/**
	 * Returns the basic logic error, or null if there are no errors.
	 */
	public String getBasicLogicErrorMessage() {
		return basicLogicError;
	}

	/**
	 * Checks xml model and returns <code>true</code> if there are no logic
	 * errors.
	 */
	public abstract boolean checkLogic(boolean fullCheck);

	/**
	 * Notification from the <code>UIManager</code> that the L&F has changed.
	 * Replaces the current UI object with the latest version from the
	 * <code>UIManager</code>. Subclassers can override this to support
	 * different GraphUIs.
	 * 
	 * @see JComponent#updateUI
	 */
	public void updateUI() {
		setUI(new BPDGraphUI());
		invalidate();
	}

	public void setAdditionalKeyboardShortcuts() {
	}
}
