/* AbstractEditor.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：主界面UI的展现抽象类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 */

package com.ds.bpm.bpd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import com.ds.bpm.bpd.actions.FocusNearestCell;
import com.ds.bpm.bpd.actions.Redo;
import com.ds.bpm.bpd.actions.Undo;



import org.jgraph.JGraph;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.graph.GraphUndoManager;

/**
 * BPD主界面的抽象构造类
 */
public abstract class AbstractEditor extends JPanel implements
		org.jgraph.event.GraphModelListener,
		org.jgraph.event.GraphSelectionListener, Observer {

	public static Image icon = (new ImageIcon(AbstractEditor.class
			.getResource(BPDConstants.BPDICONPAT))).getImage();
	
	/**
	 * 主界面菜单、工具条、状态栏以及相关图形的构造类 A factory for the menubar, tool and popup bars
	 */
	protected BarFactory barFactory = new BarFactory(this);

	// various things needed for initializing and further work
	protected Hashtable commands;

	protected Hashtable menuItems;

	protected Hashtable specialItems;

	protected Hashtable toolbarComponents;

	protected Hashtable toolbarGroup;

	protected JMenuBar menubar;

	protected JPanel mainPanel;

	protected JPanel submainPanel;

	protected JScrollPane graphScrollPane;

	protected BPDStatusBar statusBar;

	protected GraphUndoManager undo;

	protected UndoHandler undoHandler;

	protected JSplitPane leftSplitPane;

	protected Hashtable specialButtonGroup;

	public JTabbedPane contentTabbedPane;

	protected AbstractGraph graph;

	/**
	 * 撤销、重复操作的实现 undo and redo action implementations
	 */
	// --- action implementations -----------------------------------
	protected Undo undoAction = new Undo(this);

	protected Redo redoAction = new Redo(this);

	/**
	 * 缺省操作定义 Actions defined by the Editor class
	 */
	protected Action[] defaultActions;

	protected AbstractEditor parentEditor;



	public JPanel graphMainPanel;

	public JSplitPane graphMainsplitPane;

	private JPanel graphMainAndMainPanel;

	//public JTabbedPane mainDownTaBedPanel;

	public AbstractEditor() {
		super(true);
		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new BorderLayout());
		// creating undo manager
		undoHandler = new UndoHandler(this, true);
		undo = new GraphUndoManager();

		// install the command table
		commands = new Hashtable();
		// Actions defined by the concrete editor class
		createActions();
		Action[] actions = getActions();
		for (int i = 0; i < actions.length; i++) {
			Action a = actions[i];
			commands.put(a.getValue(Action.NAME), a);
		}
		specialItems = createSpecialItems();
		graph=createGraph();
		// creating menubar 创建主界面菜单
		menuItems = new Hashtable();
		menubar = barFactory.createMenubar();
		add(menubar, BorderLayout.NORTH);
		// adding mainpane to the center 添加主界面中央部分的界面
		add(createMainComponent(), BorderLayout.CENTER);
		// adding status bar to the south 添加主界面底部的状态栏
		add(createStatusBar(), BorderLayout.SOUTH);
		valueChanged(null);
	}
	public void refreshView(){
		//this.remove(mainPanel);
		mainPanel.updateUI();
		//add(mainPanel, BorderLayout.CENTER);
		valueChanged(null);
	}

	/**
	 * 主界面分为菜单、中央组件、状态栏上、中、下三部分，此方法是创建主界面中央部分的组件 Create the main component of
	 * this panel.
	 */
	protected Component createMainComponent() {
		// creating mainpanel 创建主面板
		mainPanel = new JPanel();
		mainPanel.setLayout(new BorderLayout());
		// creating toolbars 添加主面板上部的快捷方式工具栏
		toolbarGroup = new Hashtable();
		toolbarComponents = new Hashtable();
		Component toolBarComponent = barFactory.createToolBars();
		mainPanel.add(toolBarComponent, BorderLayout.NORTH);
		// creating center component 添加主面板的中心组件
		mainPanel.add(createSubMainComponent(), BorderLayout.CENTER);
		// 返回主面板
		return mainPanel;
	}

	/**
	 * 主面板分为快捷方式工具栏、子主面板组件的上、下两部分，此方法创建子主面板 Create the center component of this
	 * panel.
	 */
	protected Component createSubMainComponent() {
		// creating the submainpanel of mainpanel 创建主面板的子主面板
		submainPanel = new JPanel();
		submainPanel.setLayout(new BorderLayout());
		// creating the leftpanel of submainpanel 添加子主面板的左边组件
		this.graphMainPanel = new JPanel();
		//submainPanel.add(createLeftComponent(), BorderLayout.WEST);
		Component toolBarComponent = barFactory.createGraphToolBars();
		
		
		// creating the splitPane of rightpanel of submainpanel 添加子主面板的右边组件
		Component centerComponent = createCenterComponent();
		//Component leftComponent = createLeftComponent();
		
		//submainPanel.add(rightComponent, BorderLayout.WEST);		
		graphMainPanel.setLayout(new BorderLayout());
		graphMainPanel.add(createRightComponent(),BorderLayout.EAST);		
		JPanel mainCenterDownPanel= MainCenterDownPanel.getInstance(this);	
		//MainLeftDownPanel mldp=MainLeftDownPanel.getInstance(this);
		//mldp.refreshView();				
		graphMainsplitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				centerComponent,mainCenterDownPanel);
//		this.graphMainAndMainPanel = new JPanel();
//		graphMainAndMainPanel.add(centerComponent,BorderLayout.EAST);
//		graphMainAndMainPanel.add(toolBarComponent,BorderLayout.NORTH);
		
		graphMainsplitPane.setBorder(BorderFactory.createLoweredBevelBorder());
		graphMainsplitPane.setContinuousLayout(true);
		graphMainsplitPane.setOneTouchExpandable(true);
		
		graphMainPanel.add(graphMainsplitPane,BorderLayout.CENTER);
		graphMainPanel.add(BorderLayout.NORTH, toolBarComponent);

		leftSplitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
				this.createLeftComponent(),graphMainPanel);
		
		leftSplitPane.setBorder(BorderFactory.createLoweredBevelBorder());
		leftSplitPane.setContinuousLayout(true);
		leftSplitPane.setOneTouchExpandable(true);
		submainPanel.add(leftSplitPane, BorderLayout.CENTER);
		
		//submainPanel.add(centerComponent,BorderLayout.EAST);
		return submainPanel;
	}

	/**
	 * 子主面板分为左、中、右三部分，此方法是创建子主面板的左边组件 Create the left of component of this
	 * submainpanel component.
	 */
	protected Component createRightComponent() {
		// creating the leftpanel of submainpanel 添加子主面板组件的左边面板
		JPanel rightPanel = new JPanel();
		// creating buttongroup 添加左边面板的流程工具按钮组
		specialButtonGroup = new Hashtable();
		Component buttonGroupComponent = barFactory.createSpecialButtonGroup();
		rightPanel.add(buttonGroupComponent);
		return rightPanel;
	}

	/**
	 * 子主面板分为左、中、右三部分，此方法是创建子主面板的右边组件 Create the right of component of this
	 * submainpanel.
	 */
	abstract Component createLeftComponent();
	/*
	public Component createRightComponent()
	 {
			JPanel rightPanel = new JPanel();
			//JLabel rightView = new JLabel("ProcessTree");
			//rightPanel.add(rightView);
			return rightPanel;
		}
*/

	
	/**
	 * 主面板分为快捷方式工具栏、中心组件的上、下两部分，此方法创建子主面板的中心组件 Create the centerpanel of
	 * component of this submainpanel.
	 */
	protected Component createCenterComponent() {
		// creating the centerpanel of submainpanel 创建子主面板的中心面板
		JPanel centerPanel = new JPanel();
		centerPanel.setLayout(new BorderLayout());
	
		// creating tabbed pane
		contentTabbedPane = new JTabbedPane(JTabbedPane.TOP);
		// contentTabbedPane.setPreferredSize(new Dimension(750, 400));
		contentTabbedPane.setMinimumSize(new Dimension(550, 400));
		// contentTabbedPane.add(barFactory.createPopupMenuOfJTabbedPanel());		
		centerPanel.add(BorderLayout.CENTER, contentTabbedPane);
		
		// 当前选择的工作流变换侦听器
		contentTabbedPane.addChangeListener(new ChangeListener() {

			public void stateChanged(ChangeEvent ce) {
				JTabbedPane tabbedPane = (JTabbedPane) ce.getSource();
				if (tabbedPane.getSelectedComponent() != null) {
					ProcessEditor processEditor = (ProcessEditor) tabbedPane
							.getSelectedComponent();
					//add by wenzhang fix two tabederre
					BPD.getInstance().getPackageEditor().setXMLPackage( processEditor.getGraph().getXMLPackage());
					AbstractGraph processGraph = ((ProcessEditor) tabbedPane
							.getSelectedComponent()).getGraph();
					processGraph.setMarqueeHandler(new BPDMarqueeHandler(
							processGraph));
					BPD.getInstance().setActivedProcessEditor(processEditor);
				
					
					// 刷新界面
					processEditor.valueChanged(null);
				}
			}
		});
		contentTabbedPane.addMouseListener(new MouseAdapter() {

			public void mousePressed(MouseEvent ev) {
				if (ev.getClickCount()>1 && !SwingUtilities.isRightMouseButton(ev)){
					if (BPD.getInstance().getPackageEditor().leftSplitPane.getLeftComponent().isShowing()){
						BPD.getInstance().getPackageEditor().leftSplitPane.getLeftComponent().hide();
						}else {
							BPD.getInstance().getPackageEditor().leftSplitPane.getLeftComponent().show(true);

						}
					if (BPD.getInstance().getPackageEditor().graphMainsplitPane.getBottomComponent().isShowing()){
					BPD.getInstance().getPackageEditor().graphMainsplitPane.getBottomComponent().hide();
					}else {
						BPD.getInstance().getPackageEditor().graphMainsplitPane.getBottomComponent().show(true);	
						
					}		
					MainLeftDownPanel mldp=MainLeftDownPanel.getInstance(BPD.getInstance().getPackageEditor());
					mldp.refreshView();		
					BPD.getInstance().getPackageEditor().leftSplitPane.setLeftComponent(mldp);
					
					MainCenterDownPanel mcdp=(MainCenterDownPanel.getInstance(BPD.getInstance().getPackageEditor()));
					mcdp.refreshView();
					BPD.getInstance().getPackageEditor().graphMainsplitPane.setBottomComponent(mcdp);
					
				}
				if (SwingUtilities.isRightMouseButton(ev)
						&& contentTabbedPane.getTabRunCount() != 0) {
					// Create PopupMenu
					JPopupMenu menu = barFactory
							.createPopupMenuOfJTabbedPanel();
					// Display PopupMenu
					menu.show(contentTabbedPane, ev.getX(), ev.getY());
				}
				
			}
		});
		
		return centerPanel;
	}

	/**
	 * 此方法创建主界面的状态栏 Create the statusBar
	 */
	protected Component createStatusBar() {
		statusBar = new BPDStatusBar(this);
		if (!BPDConfig.getInstance().getStatusBarStatus()) {
			statusBar.setVisible(false);
		}
		return statusBar;
	}

	/**
	 * 此方法获得主界面的状态栏 Get the statusBar
	 */
	public BPDStatusBar getStatusBar() {
		return statusBar;
	}

	/**
	 * 获得窗口标题 Gets a title.
	 */
	public abstract String getTitle();
	/**
	 * 获得图形界面工具栏的配置名称
	 * @return
	 */

	public abstract String graphbars();
	/**
	 * 获得快捷方式工具栏的配置名称 Returns string of toolbars for load.
	 */
	public abstract String toolbarToLoad();

	/**
	 * 获得工作流工具按钮组的配置名称 Returns string of buttongroup for load.
	 */
	public abstract String buttongroupToLoad();

	/**
	 * 获得主界面菜单的配置名称 Returns string of menubar for load.
	 */
	public abstract String menubarToLoad();

	/**
	 * 创建主界面的动作行为 Creates actions used by editor.
	 */
	protected abstract void createActions();

	/**
	 * 获得主界面的对象 Gets parentEditor.
	 */
	public AbstractEditor getParentEditor() {
		return parentEditor;
	}

	protected void doEditorSpecificStuff() {
	};

	/**
	 * 添加流程定义按钮到特别按钮组 Put SpecialButton to the Hashtable of specialButtonGroup.
	 */
	public void putSpecialButtonGroup(String key, Object buttom) {
		specialButtonGroup.put(key, buttom);
	}

	/**
	 * 获得流程定义按钮 Put SpecialButton to the Hashtable of specialButtonGroup.
	 */
	public Object getSpecialButtonGroup(String key) {
		return specialButtonGroup.get(key);
	}

	/**
	 * 获得流程定义按钮的MAP集合 Put SpecialButton to the Hashtable of specialButtonGroup.
	 */
	public Map getSpecialButtonGroup() {
		return Collections.unmodifiableMap(specialButtonGroup);
	}

	/**
	 * 从Hashtable中 获得特殊菜单项
	 * 
	 * @param key
	 *            菜单项关键字
	 * @return 返回特殊菜单项
	 */
	public Object getSpecialItem(String key) {
		return specialItems.get(key);
	}

	/**
	 * 获得特殊菜单项的HashTable
	 * 
	 * @return the Map of specialItems
	 */
	public Map getSpecialItems() {
		return Collections.unmodifiableMap(specialItems);
	}

	/**
	 * 将菜单项目存入Hashtable Put menuItem to the Hashtable of menuItems.
	 */
	public void putMenuItem(String key, Object item) {
		menuItems.put(key, item);
	}

	/**
	 * 将工具栏存入工具栏组Hashtable Put the toolbar to the Hashtable of toolbarGroup.
	 */
	public void putToolbarGroup(String key, Object item) {
		toolbarGroup.put(key, item);
	}

	/**
	 * 从工具栏组中获得工具栏对象 Get the toolbar from the Hashtable of toolbarComponents.
	 */
	public JToolBar getToolbarGroup(String key) {
		return (JToolBar) toolbarGroup.get(key);
	}

	/**
	 * 将快捷方式工具栏按钮存入Hashtable Put the buttons of toolbar to the Hashtable of
	 * toolbarComponents.
	 */
	public void putToolbarComponent(String key, Object item) {
		toolbarComponents.put(key, item);
	}

	/**
	 * 获得存储所有快捷方式工具栏按钮的Map对象 Get the buttons of toolbar from the Map of
	 * toolbarComponents.
	 */
	public Map getToolbarComponents() {
		return Collections.unmodifiableMap(toolbarComponents);
	}

	/**
	 * 获得主界面组件的构造类 Get barFactory class.
	 */
	public BarFactory getBarFactory() {
		return barFactory;
	}

	/**
	 * 获得配置工作流的分页面板 Get contentTabbedPane.
	 */
	public JTabbedPane getContentTabbedPane() {
		return contentTabbedPane;
	}

	/**
	 * 获得主界面菜单组件 Get menubar.
	 */
	public JMenuBar getMenubar() {
		return menubar;
	}

	/**
	 * 获得主界面菜单组件的菜单项集合 Get the menuItems of .JMenuBar from the Map of menuItems
	 */
	public Map getMenuItems() {
		return Collections.unmodifiableMap(menuItems);
	}

	/**
	 * 获得一个菜单项
	 * 
	 * @param cmd
	 *            The keyword in the resource file to serve as the basis of
	 *            lookups. Returns menubar item if exist.
	 */
	public JMenuItem getMenuItem(String cmd) {
		return (JMenuItem) menuItems.get(cmd);
	}

	/**
	 * 获得一个快捷方式工具栏按钮
	 * 
	 * @param cmd
	 *            The keyword in the resource file to serve as the basis of
	 *            lookups. Returns toolbar button if exist.
	 */
	public JComponent getToolbarComponent(String cmd) {
		return (JComponent) toolbarComponents.get(cmd);
	}

	/**
	 * 获得一个重复操作对象 Returns redoAction class.
	 */
	public Redo getRedo() {
		return redoAction;
	}

	/**
	 * 获得一个撤销操作对象 Returns undoAction class.
	 */
	public Undo getUndo() {
		return undoAction;
	}

	/**
	 * 创建特殊菜单项 Create special menubar items - have no functionality at the moment.
	 * This is a place to add special things.
	 */
	protected Hashtable createSpecialItems() {
		return new Hashtable();
	}

	/**
	 * 获得主窗口 Find the hosting window.
	 */
	public Window getWindow() {
		for (Container p = getParent(); p != null; p = p.getParent()) {
			if (p instanceof Window) {
				return (Window) p;
			}
		}
		return null;
	}

	/**
	 * 更新界面 Invoked after the selection or the model has changed.
	 */
	public void update() {
		undoAction.update();
		redoAction.update();
		try {
			setTitle(getWindow(), getTitle());
			this.invalidate();
		} catch (Exception ex) {
		}
	}

	/**
	 * 显示主界面窗口 Shows a window.
	 */
	public void showWindow(String name) {
		Window w = getWindow();
		if (w != null) {
			
			w.setIconImage(icon);
			setTitle(w, name);
			w.show();
		}
	}

	/**
	 * 设置窗口标题 Sets the title to the window.
	 */
	public void setTitle(Window w, String name) {
		if (w == null)
			return;
		if (w instanceof JFrame) {
			((JFrame) w).setTitle(name);
		} else {
			((JDialog) w).setTitle(name);
		}
	}

	/**
	 * 重新设置撤销操作 Resets UndoManager.
	 */
	public void resetUndoManager() {
		// undo.discardAllEdits();
		undoAction.update();
		redoAction.update();
	}

	/**
	 * 得到撤销对象
	 */
	public GraphUndoManager getUndoManager() {
		return undo;
	}

	/**
	 * @param jc
	 *            侦听组件
	 */
	protected void setALTCursorKeyboardShortcuts(JComponent jc) {
		String focusUp = "focusUp";
		String focusDown = "focusDown";
		String focusLeft = "focusLeft";
		String focusRight = "focusRight";
		jc.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_UP,
						InputEvent.ALT_DOWN_MASK, false), focusUp);
		jc.getActionMap().put(focusUp,
				new FocusNearestCell(this, FocusNearestCell.FOCUS_UP));
		jc.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,
						InputEvent.ALT_DOWN_MASK, false), focusDown);
		jc.getActionMap().put(focusDown,
				new FocusNearestCell(this, FocusNearestCell.FOCUS_DOWN));
		jc.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_LEFT,
						InputEvent.ALT_DOWN_MASK, false), focusLeft);
		jc.getActionMap().put(focusLeft,
				new FocusNearestCell(this, FocusNearestCell.FOCUS_LEFT));
		jc.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
				KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT,
						InputEvent.ALT_DOWN_MASK, false), focusRight);
		jc.getActionMap().put(focusRight,
				new FocusNearestCell(this, FocusNearestCell.FOCUS_RIGHT));
	}

	// ************************* ACTION STUFF *****************************
	/**
	 * 获得主界面按钮或菜单的操作对象Action Fetch the list of actions supported by this
	 * packageEditor.
	 */
	public Action[] getActions() {
		return defaultActions;
	}

	/**
	 * 得到响应的操作 Method to get packageEditor's action corresponding to the given
	 * string.
	 * 
	 * @param cmd
	 *            String representation of editor's action.
	 * @return action specified by the string cmd.
	 */
	public Action getAction(String cmd) {
		return (Action) commands.get(cmd);
	}

	// ********************* END OF ACTION STUFF **************************

	// ********************* REGISTRATION AND REMOVAL OF LISTENERS
	// *****************
	/**
	 * 为流程定义图形注册侦听器 Add this documents listeners to the specified graph.
	 * 
	 * @param graph
	 */
	protected void registerListeners(JGraph graph) {
		graph.getSelectionModel().addGraphSelectionListener(this);
		graph.getModel().addGraphModelListener(this);
		graph.getGraphLayoutCache().addObserver(this);
	}

	/**
	 * 移除流程定义图形侦听器 Remove this documents listeners from the specified graph.
	 * 
	 * @param graph
	 */
	protected void unregisterListeners(JGraph graph) {
		graph.getSelectionModel().removeGraphSelectionListener(this);
		graph.getModel().removeGraphModelListener(this);
	}

	// ***************** END OF REGISTRATION AND REMOVAL OF LISTENERS
	// **************

	// *********************** GRAPH SELECTION LISTENER INTERFACE
	// ******************
	/** Enables and disables various actions depending of cell selection */
	public void valueChanged(GraphSelectionEvent e) {
	}

	// ******************* END OF GRAPH SELECTION LISTENER INTERFACE
	// ***************

	// ****************************** OBSERVER INTERFACE
	// ***************************
	public void update(Observable obs, Object arg) {
		BPD.getInstance().setModified(true);
		update();
	}

	// ************************** END OF OBSERVER INTERFACE
	// ************************

	// ***************************** GRAPH MODEL LISTENER INTERFACE
	// ****************
	/**
	 * 图形变化侦听器
	 * 
	 * @param e
	 */
	public void graphChanged(GraphModelEvent e) {
		BPD.getInstance().setModified(true);
		update();
	}

	// ************************* END OF GRAPH MODEL LISTENER INTERFACE
	// *************

	/**
	 * 刷新主界面配置
	 */
	public void refreshEditorConfiguration() {
		try{
		//SwingUtilities.updateComponentTreeUI(this);
		}catch (Exception ex){
			System.out.print("更新updateComponentTreeUI出现错误");
		}
		// 刷新工作流面板
		
		int count = contentTabbedPane.getTabCount();
		for (int i = 0; i < count; i++) {
			try {
				((ProcessEditor) contentTabbedPane.getComponentAt(i))
						.getGraph().refreshGraphConfiguration();
			} catch (Exception ex) {
			}
		}
		/*
		int count1 = MainLeftDownPanel.getInstance(this).mainLeftDownPanel.getTabCount();
		for (int i = 0; i < count; i++) {
			try {
				(MainLeftDownPanel.getInstance(this).mainLeftDownPanel.getComponentAt(i)).resize(MainLeftDownPanel.getInstance(this).mainLeftDownPanel.getComponentAt(i).getSize());
			} catch (Exception ex) {
			}
		}
		*/
		// 从资源文件获得工具栏组
		String[] toolBars = Utils.tokenize(ResourceManager
				.getResourceString(toolbarToLoad()), " ");
		// 刷新工具栏组
		for (int i = 0; i < toolBars.length; i++) {
			try {
				JToolBar toolBar = (JToolBar) getToolbarGroup(toolBars[i]);
				toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
				toolBar.updateUI();
			} catch (Exception ex) {
			}
		}
		
		statusBar.setVisible(BPDConfig.getInstance().getStatusBarStatus());
		statusBar.updateMessage();
		
	}
	  public AbstractGraph getGraph() {
	      return graph;
	  }
	  /**
	    * Create an editor to represent the given document.
	    */
	   protected abstract AbstractGraph createGraph();

	public UndoHandler getUndoHandler() {
		return undoHandler;
	}
}

/* End of AbstractEditor.java */
