package com.ds.rad;

import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.expression.function.AbstractFunction;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.context.JDSActionContext;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.ProjectVersion;
import com.ds.esd.plugins.font.node.FontConfig;
import com.ds.vfs.FileInfo;

import java.util.ArrayList;
import java.util.List;

@EsbBeanAnnotation(expressionArr = "CssFills()", id = "CssFills")
public class CssFills extends AbstractFunction {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, CssFills.class);

    public CssFills() {

    }

    public List<FileInfo> perform() {
        String projectName = (String) JDSActionContext.getActionContext().getParams("projectName");
        List<FileInfo> cssFiles = new ArrayList<FileInfo>();
        ProjectVersion version = null;
        try {
            version = getClient().getProjectVersionByName(projectName);
            List<FontConfig> fontNodes = version.getProject().getFonts();
            for (FontConfig fontNode : fontNodes) {
                for (String cssFilePath : fontNode.getListCachePath()) {
                    FileInfo cssFile = getClient().getFileByPath(cssFilePath);
                    if (cssFile.getName().endsWith(".css") && cssFile.getCurrentVersion() != null && cssFile.getCurrentVersion().getLength() > 0) {
                        if (!cssFiles.contains(cssFile)) {
                            cssFiles.add(cssFile);
                        }
                    }
                }


            }
        } catch (JDSException e) {
            e.printStackTrace();
        }
        return cssFiles;
    }


    ESDClient getClient() throws JDSException {
        ESDClient client = ESDFacrory.getESDClient();
        return client;
    }
}
