package com.ds.listener;

import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.engine.event.EIServerAdapter;
import com.ds.engine.event.EIServerEvent;
import com.ds.esb.config.EsbBeanAnnotation;
import com.ds.esb.config.EsbFlowType;
import com.ds.esd.client.ESDFacrory;
import com.ds.server.JDSServer;
import com.ds.web.RemoteConnectionManager;

@EsbBeanAnnotation(id = "HttpProxyListener", name = "本地HTTP代理服务", expressionArr = "HttpProxyListener()", flowType = EsbFlowType.listener, desc = "本地HTTP代理服务")
public class HttpProxyListener extends EIServerAdapter {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, HttpProxyListener.class);

    @Override
    public void serverStarted(EIServerEvent event) throws JDSException {


        final String[] spaceformUrl = {null};
        try {
            RemoteConnectionManager.getStaticConntction("dumpCache").submit(new Runnable() {
                @Override
                public void run() {
                    ESDFacrory.getInstance().dumpCache();
                    ESDFacrory.getInstance().loadFromCache();
                    try {
                        if (JDSServer.getInstance().getAdminUser() != null) {
                            spaceformUrl[0] = JDSServer.getClusterClient().getSystem(JDSServer.getInstance().getAdminUser().getSystemCode()).getVfsPath();
                            ESDFacrory.getInstance().reloadData(spaceformUrl[0]);
                        } else {
                            logger.error("未登录！");
                        }

                    } catch (JDSException e) {
                        e.printStackTrace();
                    }

                }
            }).get();

        } catch (Exception e) {
            e.printStackTrace();
        }


    }


}
