package com.ds.httpproxy;

import com.ds.common.util.StringUtility;
import com.ds.config.JDSUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;


import java.io.File;
import java.io.IOException;
import java.io.StringWriter;

public class TestFtlProxy {
    public String test = "ceshi";

    public String getExtStr()
            throws IOException, TemplateException {
        StringWriter stringWriter = new StringWriter();
        Configuration configuration = new Configuration();
        String classpath = StringUtility.replace(getClass().getPackage().getName(), ".", File.separator);

        String defaultPath = JDSUtil.getJdsPath();
        try {
            configuration.setDirectoryForTemplateLoading(new File(defaultPath + File.separator + classpath));
        } catch (IOException e) {
            e.printStackTrace();
        }

        Template template = configuration.getTemplate("form.ftl");

        template.process(this, stringWriter);

        String str = stringWriter.toString();
        return str;
    }

    public String getTest() {
        return this.test;
    }

    public void setTest(String test) {
        this.test = test;
    }

    public static void main(String[] args) {
        TestFtlProxy test = new TestFtlProxy();
        try {
            System.out.print(test.getExtStr());
        } catch (IOException e) {
            e.printStackTrace();
        } catch (TemplateException e) {
            e.printStackTrace();
        }
    }
}