package com.ds.expression;

import com.ds.common.JDSException;
import com.ds.common.database.metadata.TableInfo;
import com.ds.common.expression.function.AbstractFunction;
import com.ds.common.util.ClassUtility;
import com.ds.common.util.StringUtility;
import com.ds.config.ListResultModel;
import com.ds.enums.db.MethodChinaName;
import com.ds.esb.config.EsbFlowType;
import com.ds.esb.config.manager.EsbBean;
import com.ds.esb.config.manager.EsbBeanFactory;
import com.ds.esb.config.manager.ExpressionTempBean;
import com.ds.esb.config.manager.ServiceBean;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.custom.CustomMethodInfo;
import com.ds.esd.custom.ESDClass;
import com.ds.esd.custom.ESDField;
import com.ds.esd.dsm.DSMFactory;
import com.ds.web.util.JSONGenUtil;
import com.ds.web.util.PageUtil;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.lang.reflect.Method;
import java.util.*;

@Controller
@RequestMapping(value = {"/admin/el/"})
public class ELService {

    static Map<String, ESDField> fieldMap = new HashMap<>();

    @MethodChinaName(cname = "获取注册服务信息")
    @RequestMapping(value = {"getBusBeanTemp"}, method = {RequestMethod.GET, RequestMethod.POST})
    public @ResponseBody
    ListResultModel<Set<ExpressionTempBean>> getBusBeanTemp(String flowTypes) {
        List<EsbFlowType> types = new ArrayList<EsbFlowType>();
        if (flowTypes != null) {
            if (flowTypes.equals("all")) {
                types.addAll(Arrays.asList(EsbFlowType.values()));
            } else {
                String[] flowTypeArr = StringUtility.split(flowTypes, ";");
                for (String app : flowTypeArr) {
                    types.add(EsbFlowType.fromType(app));
                }
            }
        }

        List<ExpressionTempBean> esbBeans = (List<ExpressionTempBean>) EsbBeanFactory.getInstance().getServiceBeanByFlowType(types.toArray(new EsbFlowType[]{}));
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList(esbBeans);
        return userStatusInfo;
    }


    @MethodChinaName(cname = "获取远程服务信息")
    @RequestMapping(value = {"getEsbBeanListBean"}, method = {RequestMethod.GET, RequestMethod.POST})
    public @ResponseBody
    ListResultModel<List<EsbBean>> getEsbTemp() {
        List<EsbBean> esbBeans = EsbBeanFactory.getInstance().getEsbBeanList();
        ListResultModel userStatusInfo = PageUtil.getDefaultPageList(esbBeans);
        return userStatusInfo;
    }


    @ResponseBody
    @RequestMapping(value = {"getServcieByType"}, method = {RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<ServiceNode>> getServcieByType() {
        ListResultModel<List<ServiceNode>> module = new ListResultModel<List<ServiceNode>>();
        List<ServiceNode> serviceNodes = new ArrayList<ServiceNode>();
        EsbFlowType[] types = EsbFlowType.values();
        for (EsbFlowType type : types) {
            ServiceNode serviceNode = new ServiceNode(type);
            serviceNodes.add(serviceNode);
        }
        module.setData(serviceNodes);
        return module;
    }

    @ResponseBody
    @RequestMapping(value = {"searchKey"}, method = {RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<KeyStartBean>> searchKey() {
        ListResultModel<List<KeyStartBean>> module = new ListResultModel<List<KeyStartBean>>();
        List<KeyStartBean> beans = new ArrayList<KeyStartBean>();
        EsbFlowType[] types = EsbFlowType.values();

        List<? extends ServiceBean> serviceBeans = EsbBeanFactory.getInstance().getServiceBeanByFlowType(EsbFlowType.localAction);
        for (ServiceBean serviceBean : serviceBeans) {
            beans.add(new KeyStartBean(serviceBean));
        }
        module.setData(beans);
        return module;
    }


    public ListResultModel<List<KeyStartBean>> searchTable(String tableName) {
        try {
            TableInfo info = ESDFacrory.getESDClient().getTableInfoByFullName(tableName);
        } catch (JDSException e) {
            e.printStackTrace();
        }
        return null;

    }

    ;

    @ResponseBody
    @RequestMapping(value = {"searchMethod"}, method = {RequestMethod.POST, RequestMethod.GET})
    public ListResultModel<List<KeyStartBean>> searchMethod(String key) {
        ListResultModel<List<KeyStartBean>> module = new ListResultModel<List<KeyStartBean>>();
        List<KeyStartBean> beans = new ArrayList<KeyStartBean>();
        EsbFlowType[] types = EsbFlowType.values();
        if (key.endsWith(".")) {
            key = key.substring(0, key.lastIndexOf("."));
        }

        if (key.indexOf("[") > -1) {
            key = key.substring(0, key.lastIndexOf("["));
        }
        ServiceBean serviceBean = EsbBeanFactory.getInstance().getEsbBeanById(key);
        Class clazz = null;
        if (serviceBean != null) {
            try {
                clazz = ClassUtility.loadClass(serviceBean.getClazz());
                if (AbstractFunction.class.isAssignableFrom(clazz)) {
                    Method[] methods = clazz.getDeclaredMethods();
                    for (int k = 0; k < methods.length; k++) {
                        Method method = methods[k];
                        if (method.getName().equals("perform")) {
                            clazz = method.getReturnType();
                        }
                    }
                }
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else if (fieldMap.containsKey(key)) {
            ESDField field = fieldMap.get(key);
            if (field instanceof CustomMethodInfo) {
                CustomMethodInfo methodField = (CustomMethodInfo) field;
                clazz = JSONGenUtil.getInnerReturnType(((CustomMethodInfo) field).getInnerMethod());
            }

        }

        if (clazz != null) {
            ESDClass esdClass = null;
            try {
                esdClass = DSMFactory.getInstance().getClassManager().loadAggregation(clazz.getName());
            } catch (ClassNotFoundException e) {
                e.printStackTrace();
            } catch (JDSException e) {
                e.printStackTrace();
            }

            List<CustomMethodInfo> fields = esdClass.getMethodsList();
            for (ESDField field : fields) {
                KeyStartBean keyBean = new KeyStartBean(key, field);
                beans.add(keyBean);
                fieldMap.put(keyBean.getExpression(), field);
            }

            List<CustomMethodInfo> otherfields = esdClass.getOtherMethodsList();
            for (ESDField field : otherfields) {
                KeyStartBean keyBean = new KeyStartBean(key, field);
                beans.add(keyBean);
                fieldMap.put(keyBean.getExpression(), field);
            }

        }


        module.setData(beans);
        return module;
    }


}
