package com.ds.editor.cmd;

import com.ds.common.JDSConstants;
import com.ds.common.JDSException;
import com.ds.common.logging.ChromeProxy;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.common.util.StringUtility;
import com.ds.context.JDSActionContext;
import com.ds.editor.chrome.task.RobotScreenModule;
import com.ds.editor.chrome.task.RobotScreenPage;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.tool.module.EUModule;
import com.ds.rad.ESDService;
import com.ds.web.RemoteConnectionManager;
import org.openqa.selenium.chrome.ChromeDriver;

import java.net.URL;
import java.util.concurrent.Executors;

public class ESDChrome implements ChromeProxy {
    private static final Log logger = LogFactory.getLog(JDSConstants.CONFIG_KEY, ESDService.class);
    private final ChromeDriver chrome;


    public ESDChrome(ChromeDriver chrome) {
        this.chrome = chrome;
    }


    public ChromeDriver getChrome() {
        return chrome;
    }

    public void sendDownLoadCommand(String path) {
        String script = " xui.create(\"xui.UI.Div\").setLeft(\"0\").setTop(\"0\").setWidth(\"0\").setHeight(\"0\").setIframeAutoLoad('RAD/vfs/download?path=" + path + "').show()";
        execScript(script);

    }

    public void printLog(String msg, boolean ismsg) {
        logger.info(msg);
        msg = StringUtility.escapeJSSpecial(msg);
        String script = "console.log('" + msg + "');";
        if (ismsg) {
            script = script + "xui.Debugger.log('" + msg + "');";
        }
        execScript(script);
    }

    @Override
    public void printError(String msg) {
        logger.error(msg);
        msg = StringUtility.escapeJSSpecial(msg);
        String script = "console.error('" + msg + "');";
        script = script + "xui.Debugger.err('" + msg + "');";


        execScript(script);
    }

    @Override
    public void printWarn(String msg) {
        logger.warn(msg);
        String script = "console.warn('" + msg + "');";
        script = script + "xui.Debugger.log('" + msg + "');";
        execScript(script);
    }

    public void sendMsg(String msg) {
        logger.info(msg);
        String script = "xui.Debugger.log('" + msg + "');";
        execScript(script);
    }


    public void execScript(String script) {
        if (chrome != null) {
            RemoteConnectionManager.getConntctionService(chrome.getWindowHandle()).execute(new ExecScript(chrome, script));
        }
    }

    @Override
    public void screenModeule(String projectVersionName, String className, Integer deploy) {
        if (projectVersionName != null) {
            try {
                final EUModule euModule = ESDFacrory.getESDClient().getModule(className, projectVersionName);
                RemoteConnectionManager.getConntctionService(projectVersionName.toString()).execute(new Runnable() {
                    @Override
                    public void run() {
                        Executors.newSingleThreadExecutor().execute(new RobotScreenModule(euModule, deploy));
                    }
                });
            } catch (JDSException e) {
                e.printStackTrace();
            }


        }
    }


    public void screenPage(URL url, Integer deploy) {
        Object projectName = JDSActionContext.getActionContext().getParams("projectName");
        if (projectName != null) {
            RemoteConnectionManager.getConntctionService(projectName.toString()).execute(new RobotScreenPage(chrome, url, deploy));
        }
    }

}
