package com.ds.editor.chrome.task;

import com.ds.common.md5.MD5;
import com.ds.config.JDSUtil;
import com.ds.esd.tool.module.EUModule;
import com.ds.web.RemoteConnectionManager;
import org.openqa.selenium.chrome.ChromeDriver;

import java.io.File;

public class RobotScreenModule implements Runnable {

    private final EUModule euModule;

    private final Integer deploy;


    public RobotScreenModule(EUModule euModule, Integer deploy) {
        this.euModule = euModule;
        this.deploy = deploy;
    }

    @Override
    public void run() {
        if (euModule != null) {
            String cacheFilePath = MD5.getHashString(euModule.getProjectVersion().getPath() + euModule.getClassName());
            ChromeDriver chromeDriver = null;
            try {
                File file = new File(JDSUtil.getJdsRealPath() + File.separator + "temp" + File.separator + cacheFilePath + ".png");
                if (!file.exists()) {
                    try {
                        chromeDriver = RobotFactory.getDriver();
                    } catch (Throwable e) {

                    }
                    String url = null;
                    String className = euModule.getClassName();
                    if (className.startsWith("App.")) {
                        String serverUrl = euModule.getProjectVersion().getProject().getConfig().getPublicServerUrl();
                        url = serverUrl + "/debug/" + euModule.getProjectVersion().getVersionName() + "/" + className + ".cls#debug=1&height=1024px&lang=cn&rand=hwf3gvdu&theme=default&width=1280px";
                    } else {
                        url = "http://custom.itjds.net/custom/" + euModule.getProjectVersion().getVersionName() + "/" + className + ".view?" + euModule.getProjectVersion().getProjectId();
                    }
                    if (url != null) {
                        chromeDriver.get(url);
                    }
                    DelayScreen delayScreen = new DelayScreen(chromeDriver, file, deploy);
                    RemoteConnectionManager.getConntctionService(euModule.getProjectVersion().getVersionName()).execute(delayScreen);

                }
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }


    }
}
