package com.ds.editor.chrome.task;

import com.ds.config.UserBean;
import com.ds.server.httpproxy.ServerProxyFactory;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RobotFactory {

    private static ChromeDriver webDriver;


    private static Map<String, ChromeDriver> workableDriverMap = new HashMap<>();

    public static synchronized void reSetDriver(String handleId, ChromeDriver workableDriver) {
        ChromeDriver webDriver = getRobotChrome(false);
        if (workableDriverMap.size() > 10) {
            workableDriverMap.remove(handleId);
            workableDriver.close();
        } else {
            if (webDriver.getWindowHandles().contains(handleId)) {
                workableDriverMap.put(handleId, workableDriver);
            } else {
                workableDriverMap.remove(handleId);
                webDriver.quit();
            }
        }

    }

    public static synchronized ChromeDriver getDriver() {
        ChromeDriver webDriver = null;
        if (workableDriverMap.isEmpty()) {
            ChromeDriver driver = getRobotChrome(false);
            webDriver = (ChromeDriver) driver.switchTo().newWindow(WindowType.TAB);
            workableDriverMap.put(webDriver.getWindowHandle(), webDriver);


        } else {
            String handleId = workableDriverMap.keySet().iterator().next();
            webDriver = workableDriverMap.get(handleId);
            workableDriverMap.remove(handleId);
        }

        return webDriver;

    }

    public static synchronized ChromeDriver getRobotChrome(boolean isNew) {


        if (webDriver == null || isNew) {
            ChromeOptions options = new ChromeOptions();
            options.setExperimentalOption("useAutomationExtension", false);
            options.setExperimentalOption("excludeSwitches", Collections.singletonList("enable-automation"));
            options.addArguments("--headless"); //
            options.addArguments("--disable-gpu"); //
            String proxyUrl = UserBean.getInstance().getProxyHost() + ":" + ServerProxyFactory.getInstance().getProxyServer().getPort();
            options.addArguments("--proxy-server=" + proxyUrl);
            webDriver = new ChromeDriver(options);
            webDriver.manage().window().setSize(new Dimension(800, 600));
            webDriver.get("http://itjds.net/projectManager/index.html");
        }

        return webDriver;
    }

}
