package com.ds.bpm.bpd.xml.panels.tablesorting;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

import javax.swing.table.DefaultTableModel;

import com.ds.bpm.bpd.xml.NewXMLCollection;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElement;

public class SortingTableModel extends DefaultTableModel {

   NewXMLCollection owner;

   public SortingTableModel(NewXMLCollection c,Vector data, Vector names) {
      super(data, names);
      this.owner=c;
   }

   public void sortByColumn(int col, boolean ascending) {
      Vector dv=getDataVector();
      Vector v=new Vector(dv);
      int vs=v.size();
      for (int i=vs-1; i>=0; i--) {
         XMLElement el=(XMLElement)((Vector)v.elementAt(i)).elementAt(0);
         if (el instanceof XMLCollectionElement) {
            XMLCollectionElement cel=(XMLCollectionElement)el;
            XMLCollection celOwner=cel.getCollection();
            if (celOwner==null || !celOwner.equals(owner)) {
               v.remove(i);
            }
         }
      }
      vs=v.size();
      if (vs>0) {
         Collections.sort(v,new ColumnSortingComparator(col, ascending));
         for (int i=0; i<vs; i++) {
            dv.set(i,v.get(i));
         }
      }
   }

   static class ColumnSortingComparator implements Comparator {

      protected int index;
      protected boolean ascending;

      public ColumnSortingComparator(int index, boolean ascending) {
         this.index = index;
         this.ascending = ascending;
      }

      public int compare(Object first, Object second) {
         if (first instanceof Vector && second instanceof Vector) {
            String str1 = ((Vector)first).elementAt(index).toString();
            String str2 = ((Vector)second).elementAt(index).toString();
            if (ascending) {
               return str1.compareTo(str2);
            } else {
               return str2.compareTo(str1);
            }
         }

         return 1;
      }

   }
}
