/*
 * Created on 2004-4-5
 *
 * The itjds Software License, Version 1.0
 *
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.panels.formula.org;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.misc.OrgTree;
import com.ds.bpm.bpd.misc.OrgTreeNode;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.org.Org;
import com.ds.org.OrgManager;
import com.ds.org.OrgNotFoundException;
import com.ds.server.JDSServer;
import com.ds.server.OrgManagerFactory;
import com.ds.server.SubSystem;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 选择组织的面板类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 *
 * @author Huchm 2004-4-5 18:22:41
 * @version 1.0
 */
public class XMLOrgPanel extends XMLPanel {

    private static Dimension minimalDimension = new Dimension(120, 100);

    private static Dimension listDimension = new Dimension(120, 160);

    private List elements = new ArrayList();

    private int selectionMode;

    // 组织机构树
    JTree allOrgTree;

    // 已选List
    private JList choosenList = new JList();

    // 构造器----显示原有信息
    public XMLOrgPanel(XMLElement myOwner, String title, boolean hasBorder, boolean minDimension, int selectionMode) {

        super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
        this.selectionMode = selectionMode;

        // 调用Org接口得到服务器的组织机构
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());

        WorkflowProcess wp = (WorkflowProcess) BPD.getInstance()
                .getActivedProcessEditor().getGraph().getPropertyObject();
        SubSystem system= null;
        try {
            system = JDSServer.getClusterClient().getSystem(JDSServer.getInstance().getCurrServerBean().getId());
        } catch (JDSException e) {
            e.printStackTrace();
        }
        OrgManager manager = OrgManagerFactory.getClientOrgManager(system.getConfigname());
        // 取得第一层的组织机构。
        OrgTree orgTree = new OrgTree(manager.getTopOrgs(system.getSysId()));
        allOrgTree = new JTree(orgTree.getRoot());
        allOrgTree.setRootVisible(false);
        TreeSelectionModel selectModel = new DefaultTreeSelectionModel();
        selectModel.setSelectionMode(selectionMode);
        allOrgTree.setSelectionModel(selectModel);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JScrollPane orgScrollPane = new JScrollPane();
        orgScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        orgScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        orgScrollPane.setViewportView(allOrgTree);
        orgScrollPane.setPreferredSize(new Dimension(180, 200));
        allOrgTree.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent me) {
                JTree tree = (JTree) me.getSource();
                TreePath selPath = tree.getSelectionPath();
                if (selPath != null) {
                    OrgTreeNode node = (OrgTreeNode) selPath.getLastPathComponent();
                    Org org = (Org) node.getUserObject();
                    if (org != null) {
                        // 动态增加子节点。
                        if (node.getChildren().length == 0) {

                            List<Org> childrens = org.getChildrenList();
                            for (Org corg : childrens) {
                                node.insert(new OrgTreeNode(corg));
                            }
                        }
                    }
                }
            }
        });
        allOrgTree.addTreeWillExpandListener(new TreeWillExpandListener() {
            public void treeWillExpand(TreeExpansionEvent tee) {
                TreePath selPath = tee.getPath();
                if (selPath != null) {
                    OrgTreeNode node = (OrgTreeNode) selPath.getLastPathComponent();
                    Org org = (Org) node.getUserObject();
                    if (org != null) {
                        // 动态增加子节点。
                        if (node.getChildren().length == 0) {

                            List<Org> childrens = org.getChildrenList();
                            for (Org corg : childrens) {
                                node.insert(new OrgTreeNode(corg));
                            }

                        }
                    }
                }
            }

            public void treeWillCollapse(TreeExpansionEvent tee) {

            }
        });
        leftPanel.add(new JLabel("■ " + ResourceManager.getLanguageDependentString("OrgRight.Org.display")), BorderLayout.NORTH);
        leftPanel.add(orgScrollPane, BorderLayout.CENTER);
        JPanel orgPanel = new JPanel();
        orgPanel.setLayout(new BorderLayout());
        orgPanel.setPreferredSize(new Dimension(182, 250));
        orgPanel.add(leftPanel, BorderLayout.CENTER);

        // 该工作流已配置的组织机构
        if (myOwner.toValue() != null && !myOwner.toValue().toString().equals("")) {
            String val = myOwner.toValue().toString();
            String[] vals = Utils.tokenize(val, FormulaParameter.DELIMITER_MULTIPLE);
            for (int i = 0; i < vals.length; i++) {
                String org_id = vals[i];
                if (!org_id.trim().equals("")) {
                    String org_name = null;
                    try {
                        org_name = manager.getOrgByID(org_id).getName();
                    } catch (OrgNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    if (org_name != null) {
                        elements.add(new XMLSelectOption(org_name, org_id));
                    }
                }
            }
        }

        final DefaultListModel listModel = new DefaultListModel();

        // fills list
        Iterator it = elements.iterator();

        while (it.hasNext()) {
            XMLElement elem = (XMLElement) it.next();
            listModel.addElement(elem);
        }

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        String a = ResourceManager.getLanguageDependentString("AddKey");
        String r = ResourceManager.getLanguageDependentString("RemoveKey");
        Dimension dim = new Dimension(45, 15);
        XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
        XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
        // 添加按钮的操作
        buttonAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                addOperation();
            }
        });
        // 删除按钮的操作
        buttonRemove.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                removeOperation();
            }
        });
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonAdd);
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonRemove);
        buttonPanel.setPreferredSize(new Dimension(80, 60));

        JPanel choosenPanel = new JPanel();
        choosenPanel.setLayout(new BorderLayout());
        JScrollPane choosenScrollPane = new JScrollPane();
        choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        choosenScrollPane.setViewportView(choosenList);
        choosenList.setModel(listModel);
        if (getSelectionMode() == TreeSelectionModel.SINGLE_TREE_SELECTION) {
            choosenList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        } else {
            choosenList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        }
        choosenScrollPane.setPreferredSize(new Dimension(110, 200));
        choosenPanel.add(new JLabel("■ " + ResourceManager.getLanguageDependentString("OrgRight.Choosen.display")), BorderLayout.NORTH);
        choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

        jPanel.add(orgPanel, BorderLayout.WEST);
        jPanel.add(buttonPanel, BorderLayout.CENTER);
        jPanel.add(choosenPanel, BorderLayout.EAST);
        add(jPanel);
    }

    public void setElements() {
        DefaultListModel model = (DefaultListModel) getList().getModel();
        String val = "";
        for (int i = 0; i < model.size(); i++) {
            Object obj = model.get(i);
            val = val + FormulaParameter.DELIMITER_MULTIPLE + ((XMLSelectOption) obj).getText();
        }
        if (!val.equals("")) {
            val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
        }
        getOwner().setValue(val);
    }

    public JList getList() {
        return choosenList;
    }

    public boolean checkRequired() {
        if (getList().getModel().getSize() == 0) {
            XMLPanel.errorMessage(this.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorDialog.title"), getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
                    ResourceManager.getLanguageDependentString("RightFormula.Parameter.notEmptyMessage"));
            return false;
        }
        return true;
    }

    public int getSelectionMode() {
        return selectionMode;
    }

    // 添加操作
    private void addOperation() {
        TreePath[] paths = allOrgTree.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            if (getSelectionMode() == TreeSelectionModel.SINGLE_TREE_SELECTION) {
                model.removeAllElements();
            }
            for (int i = 0; i < paths.length; i++) {
                TreePath path = paths[i];
                OrgTreeNode node = (OrgTreeNode) path.getLastPathComponent();
                Org org = (Org) node.getUserObject();
                XMLSelectOption elem = new XMLSelectOption(org.getName(), org.getOrgId());
                if (!model.contains(elem)) {
                    model.addElement(elem);
                }
            }
        }
    }

    // 删除操作
    private void removeOperation() {
        Object[] objs = choosenList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                model.removeElement(obj);
            }
            if (model.size() > 0) {
                choosenList.setSelectedIndex(model.size() - 1);
            }
        }
    }
}
