
package com.ds.bpm.bpd.xml.panels.formula.esd;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.misc.ComponentTreeNode;
import com.ds.bpm.bpd.misc.ESDComTree;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.JDSException;
import com.ds.esd.client.ESDClient;
import com.ds.esd.client.ESDFacrory;
import com.ds.esd.client.Project;
import com.ds.esd.tool.module.EUModule;

import com.ds.esd.tool.ui.component.form.FormField;
import com.ds.esd.tool.ui.component.form.HiddenInputComponent;
import com.ds.esd.tool.ui.module.ModuleComponent;

import javax.swing.*;
import javax.swing.tree.TreePath;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


public class XMLESDComponentPanel extends XMLPanel {
    private static Dimension minimalDimension = new Dimension(500, 100);

    private static Dimension listDimension = new Dimension(220, 160);
    private final Project project;
    private List elements = new ArrayList();
    private int selectionMode;
    private ESDClient client;
    // 可选List
    private JList colinfoList = new JList();
    // 已选List
    private JList choosenList = new JList();


    // 构造器----显示原有信息
    public XMLESDComponentPanel(XMLElement myOwner, String title, boolean hasBorder, boolean minDimension, int selectionMode) throws JDSException {
        super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
        this.selectionMode = selectionMode;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        WorkflowProcess wp = (WorkflowProcess) BPD.getInstance() .getActivedProcessEditor().getGraph().getPropertyObject();

        this.client = ESDFacrory.getESDClient();

        this.project = this.client.getProjectByName(wp.getProjectName());
        ESDComTree moduleTree = new ESDComTree(project.getActiveProjectVersion());
        JTree allTableTree = new JTree(moduleTree.getRoot());

        allTableTree.setRootVisible(false);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        JScrollPane placeScrollPane = new JScrollPane();
        placeScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        placeScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        placeScrollPane.setViewportView(allTableTree);
        placeScrollPane.setPreferredSize(new Dimension(300, 200));
        allTableTree.addMouseListener(new MouseAdapter() {
            public void mouseClicked(MouseEvent me) {
                JTree tree = (JTree) me.getSource();
                TreePath selPath = tree.getSelectionPath();
                if (selPath != null) {
                    ComponentTreeNode node = (ComponentTreeNode) selPath.getLastPathComponent();
                    com.ds.esd.tool.ui.component.Component component = (com.ds.esd.tool.ui.component.Component) node.getUserObject();
                    if (component != null) {
                        List<com.ds.esd.tool.ui.component.Component> components = new ArrayList<>();
                        if (component instanceof ModuleComponent) {
                            List<com.ds.esd.tool.ui.component.Component> comList = ((ModuleComponent) component).findByPropertiesType(FormField.class, null);
                            for (com.ds.esd.tool.ui.component.Component childCom : comList) {
                                if (!(childCom instanceof HiddenInputComponent)) {
                                    components.add(childCom);
                                }
                            }
                        }
                        colinfoList.setListData(components.toArray());
                    }
                }
            }
        });
//        allTableTree.addTreeWillExpandListener(new TreeWillExpandListener() {
//            public void treeWillExpand(TreeExpansionEvent tee) {
//                TreePath selPath = tee.getPath();
//                if (selPath != null) {
//                    ComponentTreeNode node = (ComponentTreeNode) selPath.getLastPathComponent();
//                    com.ds.esd.tool.ui.component.Component component = (com.ds.esd.tool.ui.component.Component) node.getUserObject();
//                    if (component != null) {
//                        List<com.ds.esd.tool.ui.component.Component> comList = component.getChildrenRecursivelyList();
//                        colinfoList.setListData(comList.toArray());
//                    }
//                }
//            }
//
//            public void treeWillCollapse(TreeExpansionEvent tee) {
//
//            }
//        });
        leftPanel.add(new JLabel("■ " + "UI对象树"), BorderLayout.NORTH);
        leftPanel.add(placeScrollPane, BorderLayout.CENTER);
        leftPanel.add(new JLabel(" "), BorderLayout.EAST);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        JScrollPane childScrollPane = new JScrollPane();
        childScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        childScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        childScrollPane.setViewportView(colinfoList);
        childScrollPane.setPreferredSize(new Dimension(220, 200));
        rightPanel.add(new JLabel("■ " + "UI组件"), BorderLayout.NORTH);
        rightPanel.add(childScrollPane, BorderLayout.CENTER);
        JPanel comPanel = new JPanel();
        comPanel.setLayout(new BorderLayout());
        comPanel.setPreferredSize(new Dimension(500, 250));
        comPanel.add(leftPanel, BorderLayout.CENTER);
        comPanel.add(rightPanel, BorderLayout.EAST);

        if (myOwner.toValue() != null && !myOwner.toValue().toString().equals("")) {
            String val = myOwner.toValue().toString();
            String[] vals = Utils.tokenize(val, FormulaParameter.DELIMITER_MULTIPLE);
            for (int i = 0; i < vals.length; i++) {
                String colid = vals[i];
                if (!colid.trim().equals("") && colid.indexOf("##") > 0) {
                    try {
                        String className = colid.split("##")[0];
                        String alias = colid.split("##")[1];
                        EUModule module = this.client.getModule(className, project.getProjectName());
                        if (module != null) {
                            if (module.getComponent().findComponentsByAlias(alias).size() > 0) {
                                com.ds.esd.tool.ui.component.Component component = (com.ds.esd.tool.ui.component.Component) module.getComponent().findComponentsByAlias(alias).get(0);
                                elements.add(new XMLSelectOption(component.getAlias(), component.getModuleComponent().getClassName() + "##" + component.getAlias()));
                            }

                        }
                    } catch (JDSException e) {
                        e.printStackTrace();
                    }


                }
            }
        }

        final DefaultListModel listModel = new DefaultListModel();

        // fills list
        Iterator it = elements.iterator();

        while (it.hasNext()) {
            XMLElement elem = (XMLElement) it.next();
            listModel.addElement(elem);
        }
        // allPersonList.setModel(listModel);
        colinfoList.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent me) {
                if (me.getClickCount() > 1) {
                    addOperation();
                }
            }
        });
        colinfoList.setSelectionMode(selectionMode);
        colinfoList.setAlignmentX(Component.LEFT_ALIGNMENT);
        colinfoList.setAlignmentY(Component.TOP_ALIGNMENT);

        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        String a = ResourceManager.getLanguageDependentString("AddKey");
        String r = ResourceManager.getLanguageDependentString("RemoveKey");
        Dimension dim = new Dimension(45, 15);
        XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
        XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
        // 添加按钮的操作
        buttonAdd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                addOperation();
            }
        });
        // 删除按钮的操作
        buttonRemove.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                removeOperation();
            }
        });
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonAdd);
        buttonPanel.add(new JLabel(" "));
        buttonPanel.add(buttonRemove);
        buttonPanel.setPreferredSize(new Dimension(120, 60));

        JPanel choosenPanel = new JPanel();
        choosenPanel.setLayout(new BorderLayout());
        JScrollPane choosenScrollPane = new JScrollPane();
        choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
        choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
        choosenScrollPane.setViewportView(choosenList);
        choosenList.setModel(listModel);
        choosenList.setSelectionMode(selectionMode);
        choosenScrollPane.setPreferredSize(new Dimension(110, 200));
        choosenPanel.add(new JLabel("■ " + "已选字段"), BorderLayout.NORTH);
        choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

        jPanel.add(comPanel, BorderLayout.WEST);
        jPanel.add(buttonPanel, BorderLayout.CENTER);
        jPanel.add(choosenPanel, BorderLayout.EAST);
        add(jPanel);
    }

    public void setElements() {
        DefaultListModel model = (DefaultListModel) getList().getModel();
        String val = "";
        for (int i = 0; i < model.size(); i++) {
            Object obj = model.get(i);
            if (obj instanceof com.ds.esd.tool.ui.component.Component) {
                com.ds.esd.tool.ui.component.Component component = (com.ds.esd.tool.ui.component.Component) (obj);
                obj = new XMLSelectOption(component.getAlias(), component.getModuleComponent().getClassName() + "##" + component.getAlias());
            }
            val = val + FormulaParameter.DELIMITER_MULTIPLE + ((XMLSelectOption) obj).getText();
        }
        if (!val.equals("")) {
            val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
        }
        getOwner().setValue(val);
    }

    public JList getList() {
        return choosenList;
    }

    public boolean checkRequired() {
        if (getList().getModel().getSize() == 0) {
            XMLPanel.errorMessage(this.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorDialog.title"), getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
                    ResourceManager.getLanguageDependentString("RightFormula.Parameter.notEmptyMessage"));
            return false;
        }
        return true;
    }

    public int getSelectionMode() {
        return selectionMode;
    }

    // 添加操作
    private void addOperation() {
        Object[] objs = colinfoList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                if (obj instanceof com.ds.esd.tool.ui.component.Component) {
                    com.ds.esd.tool.ui.component.Component component = (com.ds.esd.tool.ui.component.Component) obj;
                    XMLSelectOption elem = new XMLSelectOption(component.getAlias(), component.getModuleComponent().getClassName() + "##" + component.getAlias());
                    if (!model.contains(elem)) {
                        model.addElement(elem);
                    }
                }
            }
        }
    }

    // 删除操作
    private void removeOperation() {
        Object[] objs = choosenList.getSelectedValues();
        if (objs != null && objs.length > 0) {
            DefaultListModel model = (DefaultListModel) choosenList.getModel();
            for (int i = 0; i < objs.length; i++) {
                Object obj = objs[i];
                model.removeElement(obj);
            }
            if (model.size() > 0) {
                choosenList.setSelectedIndex(model.size() - 1);
            }
        }
    }
}
