package com.ds.bpm.bpd.xml.panels.formula;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreePath;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.plugin.impl.activity.DicType;
import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.elements.formula.FormulaParameter;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.swing.tree.JDSTree;
import com.ds.common.swing.tree.JDSTreeNode;
import com.ds.config.MenuCfg;
import com.ds.enums.Enums;
import com.ds.enums.EnumsUtil;
import com.ds.iot.DeviceEndPoint;

public class XMLEnumsTreePanel extends XMLPanel {

    private static Dimension minimalDimension = new Dimension(120, 100);

    private static Dimension listDimension = new Dimension(120, 160);

    private List elements = new ArrayList();

    private int selectionMode;

    // 可选List
    private JList allSensorList = new JList();

    // 已选List
    private JList choosenList = new JList();

    // private String type;

    // 构造器----显示原有信息
    public XMLEnumsTreePanel(XMLElement myOwner, String title, boolean hasBorder, boolean minDimension, int selectionMode, Class<? extends Enums> enums) {
	super(myOwner, 2, title, XMLPanel.BOX_LAYOUT, false, hasBorder);
	FormulaParameter formula = (FormulaParameter) myOwner;

	this.selectionMode = selectionMode;
	JPanel jPanel = new JPanel();
	jPanel.setLayout(new BorderLayout());

	MenuCfg menu = EnumsUtil.getMenuCfg(enums);

	MenuCfg parentMenu = new MenuCfg();
	List<MenuCfg> menus = new ArrayList<MenuCfg>();
	menus.add(menu);
	parentMenu.setMenu(menus);

	JDSTreeNode jdsTreeNode = new JDSTreeNode(parentMenu);

	JDSTree leftPanel = new JDSTree(jdsTreeNode);
	JTree dicTree = leftPanel.getTreePanel();

	dicTree.setRootVisible(false);
	dicTree.addMouseListener(new MouseAdapter() {
	    public void mouseClicked(MouseEvent me) {
		JTree tree = (JTree) me.getSource();
		TreePath selPath = tree.getSelectionPath();
		if (selPath != null && selPath.getParentPath() != null) {
		    JDSTreeNode node = (JDSTreeNode) selPath.getLastPathComponent();
		    if (node.getUserObject() instanceof MenuCfg) {

			MenuCfg cfg = (MenuCfg) node.getUserObject();
			if (cfg.getMenu() != null) {

			    allSensorList.setListData(XMLEnumsTreePanel.this.getDicTypes(cfg));

			}

		    }
		}
	    }
	});
	dicTree.addTreeWillExpandListener(new TreeWillExpandListener() {
	    public void treeWillExpand(TreeExpansionEvent tee) {
		TreePath selPath = tee.getPath();
		if (selPath != null) {
		    JDSTreeNode node = (JDSTreeNode) selPath.getLastPathComponent();
		    if (node.getUserObject() instanceof MenuCfg) {

		    }

		}
	    }

	    public void treeWillCollapse(TreeExpansionEvent tee) {

	    }
	});
	leftPanel.add(new JLabel("■ " + ResourceManager.getLanguageDependentString("Sensor.Org.display")), BorderLayout.NORTH);
	// leftPanel.add(orgScrollPane, BorderLayout.CENTER);
	// leftPanel.add(new JLabel(" "), BorderLayout.EAST);

	JPanel rightPanel = new JPanel();
	rightPanel.setLayout(new BorderLayout());
	JScrollPane personScrollPane = new JScrollPane();
	personScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
	personScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
	personScrollPane.setViewportView(allSensorList);
	personScrollPane.setPreferredSize(new Dimension(110, 200));
	rightPanel.add(new JLabel("■ " + ResourceManager.getLanguageDependentString("Sensor.Person.display")), BorderLayout.NORTH);
	rightPanel.add(personScrollPane, BorderLayout.CENTER);
	JPanel orgPanel = new JPanel();
	orgPanel.setLayout(new BorderLayout());
	orgPanel.setPreferredSize(new Dimension(292, 250));
	orgPanel.add(leftPanel, BorderLayout.CENTER);
	orgPanel.add(rightPanel, BorderLayout.EAST);

	if (myOwner.toValue() != null && !myOwner.toValue().toString().equals("")) {
	    String val = myOwner.toValue().toString();
	    String[] vals = Utils.tokenize(val, FormulaParameter.DELIMITER_MULTIPLE);

	    for (int i = 0; i < vals.length; i++) {
		String sensor_id = vals[i];
		if (!sensor_id.trim().equals("")) {
		    String sensor_name = null;

		    if (sensor_name != null) {
			elements.add(new XMLSelectOption(sensor_name, sensor_id));
		    } else {
			elements.add(new XMLSelectOption(sensor_id, sensor_id));
		    }
		}
	    }
	}

	final DefaultListModel listModel = new DefaultListModel();

	// fills list
	Iterator it = elements.iterator();

	while (it.hasNext()) {
	    XMLElement elem = (XMLElement) it.next();
	    listModel.addElement(elem);
	}
	// allPersonList.setModel(listModel);
	allSensorList.addMouseListener(new MouseAdapter() {
	    public void mousePressed(MouseEvent me) {
		if (me.getClickCount() > 1) {
		    addOperation();
		}
	    }
	});
	allSensorList.setSelectionMode(selectionMode);
	allSensorList.setAlignmentX(Component.LEFT_ALIGNMENT);
	allSensorList.setAlignmentY(Component.TOP_ALIGNMENT);

	JPanel buttonPanel = new JPanel();
	buttonPanel.setLayout(new FlowLayout());
	String a = ResourceManager.getLanguageDependentString("AddKey");
	String r = ResourceManager.getLanguageDependentString("RemoveKey");
	Dimension dim = new Dimension(45, 15);
	XMLButton buttonAdd = new XMLButton(a, "AddSmall", dim);
	XMLButton buttonRemove = new XMLButton(r, "RemoveSmall", dim);
	// 添加按钮的操作
	buttonAdd.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent ae) {
		addOperation();
	    }
	});
	// 删除按钮的操作
	buttonRemove.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent ae) {
		removeOperation();
	    }
	});
	buttonPanel.add(new JLabel(" "));
	buttonPanel.add(buttonAdd);
	buttonPanel.add(new JLabel(" "));
	buttonPanel.add(buttonRemove);
	buttonPanel.setPreferredSize(new Dimension(80, 60));

	JPanel choosenPanel = new JPanel();
	choosenPanel.setLayout(new BorderLayout());
	JScrollPane choosenScrollPane = new JScrollPane();
	choosenScrollPane.setAlignmentX(Component.LEFT_ALIGNMENT);
	choosenScrollPane.setAlignmentY(Component.TOP_ALIGNMENT);
	choosenScrollPane.setViewportView(choosenList);
	choosenList.setModel(listModel);
	choosenList.setSelectionMode(selectionMode);
	choosenScrollPane.setPreferredSize(new Dimension(110, 200));
	choosenPanel.add(new JLabel("■ " + ResourceManager.getLanguageDependentString("Sensor.Choosen.display")), BorderLayout.NORTH);
	choosenPanel.add(choosenScrollPane, BorderLayout.CENTER);

	jPanel.add(orgPanel, BorderLayout.WEST);
	jPanel.add(buttonPanel, BorderLayout.CENTER);
	jPanel.add(choosenPanel, BorderLayout.EAST);
	add(jPanel);
    }

    public void setElements() {
	DefaultListModel model = (DefaultListModel) getList().getModel();
	String val = "";
	for (int i = 0; i < model.size(); i++) {
	    Object obj = model.get(i);
	    if (obj instanceof DeviceEndPoint) {
		DeviceEndPoint sensor = (DeviceEndPoint) (obj);
		obj = new XMLSelectOption(sensor.getName(), sensor.getEndPointId());
	    }
	    val = val + FormulaParameter.DELIMITER_MULTIPLE + ((XMLSelectOption) obj).getText();
	}
	if (!val.equals("")) {
	    val = val.substring(FormulaParameter.DELIMITER_MULTIPLE.length());
	}
	getOwner().setValue(val);
    }

    public JList getList() {
	return choosenList;
    }

    public boolean checkRequired() {
	if (getList().getModel().getSize() == 0) {
	    XMLPanel.errorMessage(this.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorDialog.title"), getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
		    ResourceManager.getLanguageDependentString("Formula.Parameter.notEmptyMessage"));
	    return false;
	}
	return true;
    }

    public int getSelectionMode() {
	return selectionMode;
    }

    // 添加操作
    private void addOperation() {
	Object[] objs = allSensorList.getSelectedValues();
	if (objs != null && objs.length > 0) {
	    DefaultListModel model = (DefaultListModel) choosenList.getModel();
	    for (int i = 0; i < objs.length; i++) {
		Object obj = objs[i];
		if (obj instanceof DicType) {
		    obj = (DicType) obj;
		    XMLSelectOption elem = new XMLSelectOption(((DicType) obj).getName() + "(" + ((DicType) obj).getType() + ")", ((DicType) obj).getType());
		    if (!model.contains(elem)) {
			model.addElement(elem);
		    }
		}
	    }
	}
    }

    // 删除操作
    private void removeOperation() {
	Object[] objs = choosenList.getSelectedValues();
	if (objs != null && objs.length > 0) {
	    DefaultListModel model = (DefaultListModel) choosenList.getModel();
	    for (int i = 0; i < objs.length; i++) {
		Object obj = objs[i];
		model.removeElement(obj);
	    }
	    if (model.size() > 0) {
		choosenList.setSelectedIndex(model.size() - 1);
	    }
	}
    }

    public DicType[] getDicTypes(MenuCfg menuCfg) {

	List<DicType> sensorTypeList = new ArrayList<DicType>();

	List<MenuCfg> menuCfgs = menuCfg.getMenu();

	for (MenuCfg cfs : menuCfgs) {

	    DicType dictype = new DicType();
	    dictype.setType(cfs.getId());
	    dictype.setName(cfs.getText());
	    sensorTypeList.add(dictype);

	}

	return sensorTypeList.toArray(new DicType[0]);
    }

}
