/* XMLGroupPanel.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：属性组合面板构造类
 * Authors： wenzhang li
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.Component;

import javax.swing.Box;

import com.ds.bpm.bpd.xml.XMLElement;

/**
 * Creates titled group panel with vertical or horizontal BoxLayout, that
 * consists of panels of given elements.
 */
public class XMLGroupPanel extends XMLPanel {

	private Object[] elements;

	private boolean isVertical;

	public XMLGroupPanel(XMLElement myOwner, Object[] elements) {
		this(myOwner, elements, "");
	}

	public XMLGroupPanel(XMLElement myOwner, Object[] elements, String title) {
		this(myOwner, elements, title, XMLPanel.BOX_LAYOUT);
	}

	public XMLGroupPanel(XMLElement myOwner, Object[] elements, String title,
			int layout) {
		this(myOwner, elements, title, layout, true);
	}

	public XMLGroupPanel(XMLElement myOwner, Object[] elements, String title,
			int layout, boolean isVertical) {
		this(myOwner, elements, title, layout, isVertical, true);
	}

	public XMLGroupPanel(XMLElement myOwner, Object[] elements, String title,
			int layout, boolean isVertical, boolean hasBorder) {

		super(myOwner, elements.length + 1, title, layout, isVertical,
				hasBorder);

		this.elements = elements;
		this.isVertical = isVertical;
		constructPanel();
	}

	public void constructPanel() {
		XMLPanel dtdp = null;
		for (int i = 0; i < elements.length; i++) {
			if (elements[i] instanceof XMLElement) {
				dtdp = ((XMLElement) elements[i]).getPanel();
			} else if (elements[i] instanceof XMLPanel) {
				dtdp = (XMLPanel) elements[i];
			}
			dtdp.setEnabled(!getOwner().isReadOnly());
			add(dtdp);
		}

		if (isVertical) {
			add(Box.createVerticalGlue());
		} else {
			add(Box.createHorizontalGlue());
		}
	}

	public XMLPanel getPanel(int no) {
		if (no >= getComponentCount() - 1) {
			return null;
		}
		return (XMLPanel) getComponent(no);
	}

	public boolean checkRequired() {
		if (isEmpty() && !getOwner().isRequired())
			return true;
		boolean isOK = true;
		for (int i = 0; i < getComponentCount(); i++) {
			Component c = getComponent(i);
			if (c instanceof XMLPanel) {
				isOK = isOK && ((XMLPanel) c).checkRequired();
			}
		}
		return isOK;
	}

	public boolean isEmpty() {
		boolean isEmpty = true;
		for (int i = 0; i < getComponentCount(); i++) {
			Component c = getComponent(i);
			if (c instanceof XMLPanel) {
				isEmpty = isEmpty && ((XMLPanel) c).isEmpty();
			}
		}
		return isEmpty;
	}

	public void setElements() {
		boolean isOK = true;
		for (int i = 0; i < getComponentCount(); i++) {
			Component c = getComponent(i);
			if (c instanceof XMLPanel) {
				// System.out.println("Comp no "+(i+1)+" = "+getComponent(i));
				((XMLPanel) c).setElements();
			}
		}
	}
	
	public void panelActivated(){
		this.getPanel(0).panelActivated();
	}

}

/* End of XMLGroupPanel.java */
