/* XMLTablePanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */


package com.ds.bpm.bpd.xml.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import com.ds.bpm.bpd.xml.NewXMLCollection;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.tablesorting.SortingTable;

/**
 * Creates a table panel.
 */
public class NewXMLTablePanel extends NewXMLPanel {

   public static Color FOREIGN_EL_COLOR_BKG=Color.lightGray;
   public static Color SPEC_EL_COLOR_BKG=Color.orange;

   protected static Dimension miniTableDimension=new Dimension(300,75);
   protected static Dimension smallTableDimension=new Dimension(400,200);
   protected static Dimension mediumTableDimension=new Dimension(600,200);
   protected static Dimension largeTableDimension=new Dimension(800,200);

   private static XMLElement toHack=new XMLElement();
   /**
    * Object which we are replacing from one place to another within
    * the list by draging it.
    */
   private Object replacingObject;
   /**
    * Index of the object which we are replacing from one place to another
    * within the list by draging it.
    */
   private int startReplaceIndex;
   /**
    * The new index of the object which we are replacing from one place
    * to another within the list by draging it.
    */
   private int endReplaceIndex;
   /** Indicates if object is beeing draged. */
   private boolean dragging=false;
   /**
    * Indicates if the code for changing object position within the list
    * is executed.
    */
   private boolean changing=false;

   public NewXMLTablePanel (NewXMLCollection myOwner) {
      this(myOwner,"");
   }

   public NewXMLTablePanel (NewXMLCollection myOwner,String title) {
      this(myOwner,title,true,false);
   }

   public NewXMLTablePanel (NewXMLCollection myOwner,
                         String title,
                         boolean hasBorder,
                         boolean automaticWidth) {
      this(myOwner,title,hasBorder,automaticWidth,false);
   }

   public NewXMLTablePanel (NewXMLCollection myOwner,
                         String title,
                         boolean hasBorder,
                         boolean automaticWidth,
                         boolean miniDimension) {
      this(myOwner,title,hasBorder,automaticWidth,miniDimension,true,true);
   }

   public NewXMLTablePanel (NewXMLCollection myOwner,
                         String title,
                         boolean hasBorder,
                         boolean automaticWidth,
                         boolean miniDimension,
                         final boolean colors,
                         final boolean showArrows) {

      super(myOwner,2,title,XMLPanel.BOX_LAYOUT,false,hasBorder);

      // creating a table which do not allow cell editing
      Vector columnNames=new Vector();
      int noOfVisibleColumns=0;
      columnNames.add("Object");
      Collection c=myOwner.getElementStructure();
      Iterator it=c.iterator();
      while (it.hasNext()) {
         XMLElement el=(XMLElement)it.next();
         columnNames.add(el.toLabel());
         noOfVisibleColumns++;
      }


      JTable allItems=new SortingTable(this,new Vector(),columnNames) {
         public boolean isCellEditable(int row, int col) {
            return false;
         }
         // This table colors elements depending on their owner
         public Component prepareRenderer(TableCellRenderer renderer,
                                          int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            if (!isCellSelected(rowIndex, vColIndex) && colors) {
               XMLElement el=(XMLElement)getValueAt(rowIndex,0);
               if (el instanceof XMLCollectionElement) {
                  XMLCollectionElement cel=(XMLCollectionElement)el;
                  XMLCollection celOwner=cel.getCollection();
                  if (celOwner==null) {
                     c.setBackground(SPEC_EL_COLOR_BKG);
                  } else if (!celOwner.equals(getOwner())) {
                     c.setBackground(FOREIGN_EL_COLOR_BKG);
                  } else {
                     c.setBackground(getBackground());
                  }
               } else {
                  c.setBackground(getBackground());
               }
            }
            return c;
         }

      };

      int[] invisibleFieldOrdinals=myOwner.getInvisibleTableFieldOrdinals();

      TableColumnModel tcm=allItems.getColumnModel();
      TableColumn column;
      // setting the first column (object column) to be invisible
      column = allItems.getColumnModel().getColumn(0);
      column.setMinWidth(0);
      column.setMaxWidth(0);
      column.setPreferredWidth(0);
      column.setResizable(false);
      // setting fields that will not be displayed within the table
      if (invisibleFieldOrdinals!=null && invisibleFieldOrdinals.length>0) {
         noOfVisibleColumns-=invisibleFieldOrdinals.length;
         for (int i=0; i<invisibleFieldOrdinals.length; i++) {
            column = allItems.getColumnModel().getColumn(invisibleFieldOrdinals[i]+1);
            column.setMinWidth(0);
            column.setMaxWidth(0);
            column.setPreferredWidth(0);
            column.setResizable(false);
         }
      }

      // setting some table properties
      allItems.setColumnSelectionAllowed(false);
      allItems.setRowSelectionAllowed(true);
      allItems.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
      allItems.getTableHeader().setReorderingAllowed(false);

      // fills Table
      DefaultTableModel dtm=(DefaultTableModel)allItems.getModel();
      it=myOwner.getTableElements().iterator();
      while (it.hasNext()) {
         XMLElement elem=null;
         if (it.hasNext()) {
            elem=(XMLElement)it.next();
         }
         Vector v=null;
         if (elem instanceof XMLComplexElement) {
            v=new Vector(((XMLComplexElement)elem).toComplexTypeValues());
         } else {
            v=new Vector();
            v.add(elem.toString());
         }
         v.add(0,elem);
         dtm.addRow(v);
      }


      // mouse listener for editing on double-click
      allItems.addMouseListener(new MouseAdapter() {
               public void mouseClicked (MouseEvent me) {
                  if (me.getClickCount()>1) {
                     editElementDialog();
                  }
               }

               /** Marks the object which place within the table will be changed.*/
               public void mousePressed (MouseEvent me) {
                  if (!showArrows ||
                         (getOwner().isReadOnly() && ((NewXMLCollection)getOwner()).getOwner().isReadOnly())) return;
                  dragging=true;
                  JTable t=getTable();
                  replacingObject=null;
                  startReplaceIndex=-1;
                  try {
                     startReplaceIndex=t.getSelectedRow();
                     if (startReplaceIndex>=0) {
                        replacingObject=t.getValueAt(startReplaceIndex,0);
                     }
                  } catch (Exception ex) {}
               }

               /** Just indicates that dragging is over.*/
               public void mouseReleased (MouseEvent me) {
                  dragging=false;
               }
            });

      /** Changes position of object within the list.*/
      if (showArrows &&
             (!(myOwner.isReadOnly() && ((NewXMLCollection)getOwner()).getOwner().isReadOnly()))) {

         ListSelectionModel rowSM = allItems.getSelectionModel();
         rowSM.addListSelectionListener(new ListSelectionListener() {
                  public void valueChanged (ListSelectionEvent lse) {
                     if (dragging && !changing) {
                        changing=true;
                        JTable t=getTable();
                        endReplaceIndex=-1;
                        try {
                           endReplaceIndex=t.getSelectedRow();
                        } catch (Exception ex) {}
                        NewXMLCollection owncol=(NewXMLCollection)getOwner();
                        //System.out.println("ro="+replacingObject+", sri="+startReplaceIndex+", eri="+endReplaceIndex+", ocs="+owncol.size()+"occol="+owncol.toCollection());
                        if (replacingObject==null || startReplaceIndex==-1 || endReplaceIndex==-1 ||
                            startReplaceIndex==endReplaceIndex || (owncol.size()-1)<startReplaceIndex ||
                               (owncol.size()-1)<endReplaceIndex || !owncol.toCollection().contains(replacingObject)) {
                           changing=false;
                           return;
                        }

                        DefaultTableModel dtm=(DefaultTableModel)t.getModel();
                        Vector v=null;
                        if (replacingObject instanceof XMLComplexElement) {
                           v=new Vector(((XMLComplexElement)replacingObject).toComplexTypeValues());
                        } else {
                           v=new Vector();
                           v.add(replacingObject.toString());
                        }
                        // add object itself to the first column (it is invisible column)
                        v.add(0,replacingObject);
                        dtm.removeRow(startReplaceIndex);
                        dtm.insertRow(endReplaceIndex,v);
                        ((NewXMLCollection)getOwner()).remove(replacingObject);
                        ((ArrayList)((NewXMLCollection)getOwner()).
                            toCollection()).add(endReplaceIndex,replacingObject);
                        try {
                           t.setRowSelectionInterval(endReplaceIndex,endReplaceIndex);
                        } catch (Exception ex) {}

                        ((XMLElementDialog)getDialog()).notifyListeners((XMLElement)replacingObject); // this is dirty hack

                        startReplaceIndex=endReplaceIndex;
                        changing=false;
                     }
                  }
               });
         allItems.setToolTipText(
            XMLUtil.getLanguageDependentString("MessageDragItemToChangeItsPosition"));
      }

      allItems.getInputMap(JComponent.WHEN_FOCUSED).
         put(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER,0,false),"edit");
      allItems.getActionMap().put("edit",new AbstractAction() {
               public void actionPerformed(ActionEvent e) {
                  editElementDialog();
               }
            });

      allItems.getInputMap(JComponent.WHEN_FOCUSED).
         put(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE,0,false),"delete");
      allItems.getActionMap().put("delete",new AbstractAction() {
               public void actionPerformed(ActionEvent e) {
                  deleteElementDialog();
               }
            });

      allItems.getInputMap(JComponent.WHEN_FOCUSED).
         put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE,0,false),"cancel");
      allItems.getActionMap().put("cancel",new AbstractAction() {
               public void actionPerformed(ActionEvent e) {
                  XMLElementDialog d=((XMLElementDialog)getDialog());
                  d.setCanceled(true);
                  d.dispose();
               }
            });

      // creates panel
      JScrollPane allItemsPane=new JScrollPane();
      allItemsPane.setViewportView(allItems);
      Dimension tDim;
      if (miniDimension) {
         tDim=new Dimension(miniTableDimension);
      } else if (noOfVisibleColumns<=3) {
         tDim=new Dimension(smallTableDimension);
      } else if (noOfVisibleColumns<=5) {
         tDim=new Dimension(mediumTableDimension);
      } else {
         tDim=new Dimension(largeTableDimension);
      }

      if (automaticWidth) {
         tDim.width=allItems.getPreferredScrollableViewportSize().width;
      }
      allItems.setPreferredScrollableViewportSize(new Dimension(tDim));

      add(allItemsPane);
      //add(Box.createVerticalGlue());

      if (showArrows) {
         JPanel p=new JPanel();
         p.setLayout(new BoxLayout(p,BoxLayout.Y_AXIS));

         JButton buttonUp=new JButton();
         java.net.URL u = XMLUtil.getResource("ArrowUpImage");
         if (u!=null) {
            buttonUp.setIcon(new ImageIcon(u));
         }
         buttonUp.setEnabled(!(myOwner.isReadOnly() && ((NewXMLCollection)getOwner()).getOwner().isReadOnly()));
         buttonUp.addActionListener(new ActionListener() {
                  public void actionPerformed(ActionEvent e) {
                     moveItem(0);
                  }
               });
         buttonUp.setPreferredSize(new Dimension(25,25));
         JButton buttonDown=new JButton();
         u = XMLUtil.getResource("ArrowDownImage");
         if (u!=null) {
            buttonDown.setIcon(new ImageIcon(u));
         }
         buttonDown.setEnabled(!(myOwner.isReadOnly() && ((NewXMLCollection)getOwner()).getOwner().isReadOnly()));
         buttonDown.addActionListener(new ActionListener() {
                  public void actionPerformed(ActionEvent e) {
                     moveItem(1);
                  }
               });
         buttonDown.setPreferredSize(new Dimension(25,25));
         p.add(buttonUp);
         p.add(Box.createVerticalGlue());
         p.add(buttonDown);
         add(Box.createRigidArea(new Dimension(5,0)));
         add(p);
      }
   }

   public JTable getTable () {
      JScrollPane jsp=(JScrollPane)getComponent(0);
      JViewport jvp=(JViewport)jsp.getComponent(0);
      JTable jt=(JTable)jvp.getComponent(0);
      return jt;
   }

   public XMLElement getSelectedElement () {
      JTable t=getTable();
      int row=t.getSelectedRow();
      if (row>=0) {
         return (XMLElement)t.getValueAt(row, 0);
      }
      return null;

   }

   public void setSelectedElement (Object el) {
      try {
         JTable t=getTable();
         int rc=t.getRowCount();
         if (rc>0) {
            for (int i=0; i<rc; i++) {
               if (el.equals(t.getValueAt(i,0))) {
                  t.setRowSelectionInterval(i,i);

                  // focus the row

                  JViewport viewport = (JViewport)t.getParent();
                  // This rectangle is relative to the table where the
                  // northwest corner of cell (0,0) is always (0,0).
                  Rectangle rect = t.getCellRect(i,0,true);
                  // The location of the viewport relative to the table
                  Point pt = viewport.getViewPosition();
                  // Translate the cell location so that it is relative
                  // to the view, assuming the northwest corner of the
                  // view is (0,0)
                  rect.setLocation(rect.x-pt.x, rect.y-pt.y);
                  // Scroll the area into view
                  viewport.scrollRectToVisible(rect);

                  break;
               }
            }
         }
      } catch (Exception ex) {}
   }


   public void modifyElement(XMLElement e) {
      SortingTable t=(SortingTable)getTable();
      int row=t.getSelectedRow();
      DefaultTableModel dtm=(DefaultTableModel)t.getModel();
      Vector v=null;
      if (e instanceof XMLComplexElement) {
         v=new Vector(((XMLComplexElement)e).toComplexTypeValues());
      } else {
         v=new Vector();
         v.add(e.toString());
      }
      // add object itself to the first column (it is invisible column)
      v.add(0,e);
      dtm.removeRow(row);
      dtm.insertRow(row,v);
      try {
         t.setRowSelectionInterval(row,row);
      } catch (Exception ex) {}
      t.performSorting(null);
   }

   public void removeElement(XMLElement e) {
      ((NewXMLCollection)getOwner()).remove(getSelectedElement());
      JTable t=getTable();
      int row=t.getSelectedRow();
      DefaultTableModel dtm=(DefaultTableModel)t.getModel();
      dtm.removeRow(row);
      try {
         if (row==0) {
            row++;
         }
         t.setRowSelectionInterval(row-1,row-1);
      } catch (Exception ex) {}
      t.requestFocus();
   }

   private void editElementDialog () {
      XMLElement editElement=getSelectedElement();
      if (editElement != null) {
         XMLElementDialog de=new XMLElementDialog(getDialog(),
                                                  editElement.toLabel()+" '"+editElement.toString()+"' - "+
                                                     XMLUtil.getLanguageDependentString("EditingKey"));
         de.editXMLElement(editElement.getPanel(),true,false);
         if (!de.isCanceled()) {
            modifyElement(editElement);
            ((NewXMLCollection)getOwner()).onElementModified(editElement);
         }
      } else {
         JOptionPane.showMessageDialog(getDialog(),
                                       XMLUtil.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
                                       XMLUtil.getLanguageDependentString("Title"),
                                       JOptionPane.WARNING_MESSAGE);
      }
      getTable().requestFocus();
   }

   private void deleteElementDialog () {
      XMLElement deleteElement=getSelectedElement();
      if (deleteElement == null) {
         JOptionPane.showMessageDialog(getDialog(),
                                       XMLUtil.getLanguageDependentString("WarningEmptySelectionToEditOrDelete"),
                                       XMLUtil.getLanguageDependentString("Title"),
                                       JOptionPane.WARNING_MESSAGE);
      } else if (deleteElement.isReadOnly()) {
         JOptionPane.showMessageDialog(getDialog(),
                                       XMLUtil.getLanguageDependentString(((NewXMLCollection)getOwner()).
                                                                             getReadOnlyMessageName((XMLComplexElement) deleteElement)),
                                       XMLUtil.getLanguageDependentString("Title"),
                                       JOptionPane.WARNING_MESSAGE);
      } else if (!((NewXMLCollection)getOwner()).canRemoveElement(deleteElement)) {
         JOptionPane.showMessageDialog(getDialog(),
                                       XMLUtil.getLanguageDependentString(((NewXMLCollection)getOwner()).
                                                                             getInUseMessageName((XMLComplexElement) deleteElement)),
                                       XMLUtil.getLanguageDependentString("Title"),
                                       JOptionPane.WARNING_MESSAGE);
      } else {
         int yn=JOptionPane.showConfirmDialog(getDialog(),
                                              XMLUtil.getLanguageDependentString(
                                                 "MessageDoYouReallyWantToRemoveSelectedItem"),
                                              deleteElement.toLabel()+" - "+
                                                 XMLUtil.getLanguageDependentString("DeletingKey"),
                                              JOptionPane.YES_NO_OPTION);
         if (yn==JOptionPane.YES_OPTION) {
            removeElement(deleteElement);
            ((NewXMLCollection)getOwner()).onElementDeleted(deleteElement);
            XMLElementDialog.notifyListeners(deleteElement); // this is dirty hack
         }
      }

   }

   private void moveItem (int upOrDown) {
      changing=true;
      JTable t=getTable();
      XMLElement rObject=null;
      int sri=-1;
      try {
         sri=t.getSelectedRow();
         if (sri>=0) {
            rObject=(XMLElement)t.getValueAt(sri,0);
         }
      } catch (Exception ex) {}
      NewXMLCollection owncol=(NewXMLCollection)getOwner();

      int eri=sri;
      if (eri==-1) {
         // do nothing
      } else if (upOrDown==0) {
         eri--;
      } else {
         eri++;
      }

      if (rObject==null || sri==-1 || eri==-1 || eri==sri || (owncol.size()-1)<sri ||
             (owncol.size()-1)<eri ||
          !owncol.toCollection().contains(rObject)) {
         changing=false;
         return;
      }

      DefaultTableModel dtm=(DefaultTableModel)t.getModel();
      Vector v=null;
      if (rObject instanceof XMLComplexElement) {
         v=new Vector(((XMLComplexElement)rObject).toComplexTypeValues());
      } else {
         v=new Vector();
         v.add(rObject.toString());
      }
      // add object itself to the first column (it is invisible column)
      v.add(0,rObject);
      dtm.removeRow(sri);
      dtm.insertRow(eri,v);
      ((NewXMLCollection)getOwner()).remove(rObject);
      ((ArrayList)((NewXMLCollection)getOwner()).toCollection()).add(eri,rObject);

      try {
         t.setRowSelectionInterval(eri,eri);
      } catch (Exception ex) {}

      ((XMLElementDialog)getDialog()).notifyListeners(rObject); // this is dirty hack

      changing=false;
   }

}


