/* XMLTablePanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

import com.ds.bpm.bpd.AbstractGraph;
import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConfig;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ProcessEditor;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.graph.Subflow;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.activity.SubFlow;
import com.ds.bpm.bpd.xml.elements.BlockActivity;

/**
 * Creates a table panel. 问题表格Panel
 */
public class ErrTablePanel extends JPanel {

	protected static Dimension miniTableDimension = new Dimension(700, 75);

	protected static Dimension smallTableDimension = new Dimension(750, 150);

	protected static Dimension mediumTableDimension = new Dimension(750, 200);

	protected static Dimension largeTableDimension = new Dimension(750, 200);

	private Map connectionErrors;

	private Map logicErrors;

	private Map graphConformanceErrors;

	private JPanel connectionJpanel;

	private JPanel xpdlJpanel;

	private Map xpdlSchemaValidationErrors;

	private List basicGraphConformanceErrors;

	private JPanel graphConformancePanel;

	private JPanel logicPanel;

	private String title;


	private JPanel allPanel;

	private boolean isSchemaValidationError;

	private boolean isConnectionError;

	private boolean isGraphConformanceError;

	private boolean isModelOK;

	private boolean isLogicError;

	private final static String errImage = "Err";

	//private final static String transitionexception_errorImage = "transitionexception_error";
	
	private final static String transitionexception_errorImage = "Err";


	private final static String warning_iconImage = "warning_icon";

	private final static String subflowactivity_error = "subflowactivity_error";

	private static final String image = "image";

	private static final String type = "type";

	private  JTabbedPane errTaBedPanel;

	private static ErrTablePanel errTaBPanel;

	private ProcessEditor editor;

	public static ErrTablePanel getInstance(){
		
		if (BPD.getInstance().getActivedProcessEditor() == null) {						
			errTaBPanel =new ErrTablePanel();
			return errTaBPanel;
		}else if (errTaBPanel==null||errTaBPanel.getProcessEditor()==null){		
			errTaBPanel=new ErrTablePanel(BPD.getInstance().getActivedProcessEditor());
		}
		return errTaBPanel;
	}
	public ErrTablePanel() {
		
	}
	
	public ErrTablePanel(ProcessEditor editor) {	
		this.editor=editor;
		init();
		
		this.errTaBedPanel = new JTabbedPane(JTabbedPane.TOP);
		AbstractGraph jgh = editor.getGraph();
		errTaBedPanel.add(allPanel);
		errTaBedPanel.add(logicPanel);
		errTaBedPanel.add(connectionJpanel);
		errTaBedPanel.add(xpdlJpanel);
		errTaBedPanel.addChangeListener(new ChangeListener() {
			public void stateChanged(ChangeEvent e) {
				{				
					Component object=errTaBedPanel.getSelectedComponent();			
				}
			}
		});

		this.setLayout(new BorderLayout());
		this.add(errTaBedPanel, BorderLayout.WEST);
	}
	public ProcessEditor getProcessEditor(){
		return this.editor;
	}
	public void refreshView(){
		this.editor=BPD.getInstance().getActivedProcessEditor();
		refreshErrMap();
		refreshErrPanel(this.allPanel,new Map[] { logicErrors, connectionErrors,
				xpdlSchemaValidationErrors });
		refreshErrPanel(this.connectionJpanel,new Map[]{connectionErrors});
		refreshErrPanel(this.xpdlJpanel,new Map[]{xpdlSchemaValidationErrors});
		refreshErrPanel(this.logicPanel,new Map[]{logicErrors});
		
	}
	
	
	public void refreshErrMap(){
//		 判断是否起用错误
		this.isSchemaValidationError = !BPD.getInstance()
				.getActivedProcessEditor().getGraph()
				.validateAgainsXPDLSchema();
		try{
		this.isConnectionError = !editor.getGraph().checkConnections(true);
		}catch(Exception e){
			
		}
		this.isLogicError = !editor.getGraph().checkLogic(true);
		this.isGraphConformanceError = !editor.getGraph().checkGraphConformance(
						true);
		this.isModelOK = !(isSchemaValidationError || isConnectionError
				|| isGraphConformanceError || isLogicError);
		
		this.xpdlSchemaValidationErrors = editor.getGraph()
				.getXPDLSchemaValidationErrorMessages();
		// 放如图标
		if (xpdlSchemaValidationErrors == null) {
			xpdlSchemaValidationErrors = new HashMap();
		}
		xpdlSchemaValidationErrors.put(image, errImage);
		xpdlSchemaValidationErrors
				.put(
						type,
						ResourceManager
								.getLanguageDependentString("ErrTablePanel.xpdlJpanel.Title.display"));
		
		this.connectionErrors = editor.getGraph().getConnectionErrorMessages();
		connectionErrors.put(image, transitionexception_errorImage);
		connectionErrors
				.put(
						type,
						ResourceManager
								.getLanguageDependentString("ErrTablePanel.connectionJpanel.Title.display"));
		this.logicErrors = editor.getGraph().getLogicErrorMessages();
		logicErrors.put(image, warning_iconImage);
		logicErrors
				.put(
						type,
						ResourceManager
								.getLanguageDependentString("ErrTablePanel.logicPanel.Title.display"));
		
		
	}
	private void refreshErrPanel(JPanel errPanel,Map[] errMap){	
		
		JScrollPane js=(JScrollPane)errPanel.getComponent(1);
		JViewport jw=(JViewport) js.getComponent(0);
		JTable jtable=(JTable) jw.getComponent(0);
		//ErrTableModel errTableModel=(ErrTableModel) jtable.getModel();
		ErrTableModel errTableModel=new ErrTableModel(errMap);
		//errTableModel.refresh(errMap);	
		jtable.setModel(errTableModel);
		

		//init();
	}
	public void init() {
		try{
		refreshErrMap();
		}catch(Exception e){
			e.printStackTrace();
		}
		// 取得错误类型
		this.xpdlJpanel = getErrPanel(
				ResourceManager
						.getLanguageDependentString("ErrTablePanel.xpdlJpanel.Title.display"),
				new Map[] { xpdlSchemaValidationErrors });
		
		this.connectionJpanel = this
				.getErrPanel(
						ResourceManager
								.getLanguageDependentString("ErrTablePanel.connectionJpanel.Title.display"),
						new Map[] { connectionErrors });

	
		this.logicPanel = this
				.getErrPanel(
						ResourceManager
								.getLanguageDependentString("ErrTablePanel.logicPanel.Title.display"),
						new Map[] { logicErrors });
		this.allPanel = this
				.getErrPanel(
						ResourceManager
								.getLanguageDependentString("ErrTablePanel.allPanel.Title.displsy"),
						new Map[] { logicErrors, connectionErrors,
								xpdlSchemaValidationErrors });
		
	}
	

	protected JPanel getErrPanel(String title, Map[] errMap) {

		JPanel ettPanel = new JPanel();
		ettPanel.setLayout(new BorderLayout());
		Dimension tDim;
		ettPanel.setName(title);
		
		if (errTaBPanel == null) {
			JLabel message = new JLabel("  ");
			message.setBorder(BorderFactory.createLoweredBevelBorder());
			ettPanel.add(message, BorderLayout.WEST);
			return ettPanel;
		}

		final JTable allItems = new JTable() {
			public boolean isCellEditable(int row, int col) {
				return false;
			}
		};

		allItems.setColumnSelectionAllowed(true);
		allItems.setRowSelectionAllowed(true);
		allItems.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		allItems.getTableHeader().setReorderingAllowed(false);
		// fills Table
	
		final TableModel dtm = new ErrTableModel(errMap);
	
		
		allItems.addMouseListener(new MouseListener() {
			public void mouseClicked(MouseEvent e) {
				int[] k = allItems.getSelectedRows();
				Activity activity = (Activity) allItems.getModel().getValueAt(k[0], 2);
				SubFlow subFlow = activity.getSubflow();
				BlockActivity blockActivity = activity.getBlockActivity();
				if (e.getClickCount() > 1) {
					if (subFlow == null && blockActivity == null) {
						com.ds.bpm.bpd.graph.Activity activityGraph = BPD
								.getInstance().getActivedProcessEditor()
								.getGraph().getWorkflowManager().getActivity(
										activity.getID());
						activityGraph.showPropertyDialog(BPD.getInstance()
								.getPackageEditor().getWindow(), BPD
								.getInstance().getActivedProcessEditor()
								.getGraph());
						
					} else if (subFlow != null) {
						Subflow subFlowGraph = (Subflow) BPD.getInstance()
								.getActivedProcessEditor().getGraph()
								.getWorkflowManager().getActivity(
										activity.getID());
						subFlowGraph.showSubflow(subFlow.getPackage());
						//BPD.getInstance().getErrTablePanel().checkConnection(null);		
						
					} else if (subFlow != null) {
						Subflow subFlowGraph = (Subflow) BPD.getInstance()
								.getActivedProcessEditor().getGraph()
								.getWorkflowManager().getActivity(
										activity.getID());
						subFlowGraph.showSubflow(subFlow.getPackage());
						//BPD.getInstance().getErrTablePanel().checkConnection(null);
					} else if (blockActivity != null) {
						com.ds.bpm.bpd.graph.BlockActivity blockActivityGraph = (com.ds.bpm.bpd.graph.BlockActivity) BPD
								.getInstance().getActivedProcessEditor()
								.getGraph().getWorkflowManager().getActivity(
										activity.getID());
						blockActivityGraph.showBlockActivity();
					//	ErrTablethis.checkConnection(null);
					}
				} else {
					
					Set wc=new HashSet();
					wc.add(activity);
					BPD.getInstance().setSelectionCells(wc,true);
					
				}

			}

			public void mouseEntered(MouseEvent e) {

			}

			public void mouseExited(MouseEvent e) {		
			}
			public void mousePressed(MouseEvent e) {
			}

			public void mouseReleased(MouseEvent e) {
			}
		});

		allItems.setModel(dtm);
		int noOfVisibleColumns = dtm.getColumnCount();
		// public
		JScrollPane allItemsPane = new JScrollPane();

		boolean miniDimension = false;
		if (miniDimension) {
			tDim = new Dimension(miniTableDimension);
		} else if (noOfVisibleColumns <= 3) {
			tDim = new Dimension(smallTableDimension);
		} else if (noOfVisibleColumns <= 5) {
			tDim = new Dimension(mediumTableDimension);
		} else {
			tDim = new Dimension(largeTableDimension);
		}
		allItems.getColumnModel().getColumn(0).setPreferredWidth(2);
	
		allItems.getColumnModel().getColumn(4).setPreferredWidth(200);
		allItemsPane.setViewportView(allItems);
		boolean automaticWidth = false;
		if (automaticWidth) {
			tDim.width = allItems.getPreferredScrollableViewportSize().width;
		}
		allItemsPane.setWheelScrollingEnabled(true);
		allItemsPane.setAutoscrolls(true);
		allItems.setPreferredScrollableViewportSize(new Dimension(tDim));
		//显示行样式
		//allItems.setShowHorizontalLines(true);
		allItems.setAutoResizeMode(JTable.AUTO_RESIZE_NEXT_COLUMN);
		ettPanel.add(Box.createVerticalGlue());
		ettPanel.add(allItemsPane, BorderLayout.EAST);
		return ettPanel;
	}


	

	public class ErrTableModel extends AbstractTableModel {

		private Vector value;

		String[] columnName = new String[] {
				ResourceManager
						.getLanguageDependentString("ErrTablePanel.ColumnName1.display"),
				ResourceManager
						.getLanguageDependentString("ErrTablePanel.ColumnName2.display"),
				ResourceManager
						.getLanguageDependentString("ErrTablePanel.ColumnName3.display"),
				ResourceManager
						.getLanguageDependentString("ErrTablePanel.ColumnName4.display"),
				ResourceManager
						.getLanguageDependentString("ErrTablePanel.ColumnName5.display") };

		private Map[] errMapArr;
		public void refresh(Map[] errMapArr){
			this.errMapArr=errMapArr;
			init();
		}
		public ErrTableModel(Map[] errMapArr) {
			this.errMapArr=errMapArr;
			init();
		}
		public void init(){
			
			this.value = new Vector();
			for (int j = 0; errMapArr.length > j; j++) {
				Map errMap = errMapArr[j];
				if (errMap != null && !(errMap.isEmpty())) {
					ImageIcon imageIcon = this.getImgIcon((String) errMap
							.get(image));
					String errType = (String) errMap
							.get(type);

					Iterator itErr = errMap.keySet().iterator();
					for (int i = 1; itErr.hasNext(); i++) {
						Object object = itErr.next();
						if (object instanceof Activity) {
							Activity activity = (Activity) object;
							List errList = new ArrayList();
							errList.add(imageIcon);
							errList.add(errType);
							errList.add(activity);
							errList.add(activity.getOwnerProcess().toString());
							errList.add(errMap.get(activity));
							Vector v = new Vector(errList);
							value.add(v);
						}
					}
				}
			}

		}

		private ImageIcon getImgIcon(String resour) {
			if (resour == null) {
				resour = "Err";
			}
			URL url = ResourceManager.getResource(resour
					+ BPDConstants.IMAGE_SUFFIX);
			ImageIcon imageIcon = new ImageIcon(url);
			return imageIcon;
		}

		public String getColumnName(int col) {
			return (String) columnName[col];
		}

		public int getColumnCount() {
			return columnName.length;
		}

		public int getRowCount() {
			return value.size();
		}

		public Class getColumnClass(int c) {
			return getValueAt(0, c).getClass();
		}

		public Object getValueAt(int rowIndex, int columnIndex) {
			Vector row = (Vector) value.get(rowIndex);
			return row.get(columnIndex);
		}

	}

	public JPanel setTitle(String title, JPanel jPanel,boolean hasBorder) {
		this.title = title;
		int emptyBorderHSize = 5;
		int emptyBorderVSize = 1;

		Border emptyb = BorderFactory.createEmptyBorder(emptyBorderVSize,
				emptyBorderHSize, emptyBorderVSize, emptyBorderHSize);
		Border inb = BorderFactory.createEmptyBorder(0, 0, 0, 0);
		if (hasBorder) {
			inb = BorderFactory.createMatteBorder(1, 1, 1, 1, Color.darkGray);
			inb = BorderFactory.createTitledBorder(inb, title,
					TitledBorder.DEFAULT_JUSTIFICATION,
					TitledBorder.DEFAULT_POSITION, BPDConfig.getInstance()
							.getFont());
		} else {
			emptyb = BorderFactory.createTitledBorder(emptyb, title,
					TitledBorder.DEFAULT_JUSTIFICATION,
					TitledBorder.DEFAULT_POSITION, BPDConfig.getInstance()
							.getFont());
		}
		jPanel.setBorder(BorderFactory.createCompoundBorder(emptyb, inb));
		return jPanel;
	}

}
