/* XMLActualParametersListControlPanel.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements.specialpanels;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JList;

import com.ds.bpm.bpd.xml.XMLButton;
import com.ds.bpm.bpd.xml.XMLChoice;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLElementDialog;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.elements.formula.FormalParameters;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLListPanel;

/**
 * Creates a control panel for table panel.
 */
public class XMLActualParametersListControlPanel extends XMLListControlPanel {
	public XMLActualParametersListControlPanel(XMLCollection myOwner,
			String title, boolean isVertical, boolean hasBorder) {

		super(myOwner, title, isVertical, hasBorder, true);

		Dimension dim = getPreferredDimension(new String[] { "x" });
		final XMLButton buttonView = new XMLButton("", "ViewFormalParameters",
				dim);
		buttonView.setToolTipText(XMLUtil
				.getLanguageDependentString("ViewFormalParametersKey"));

		add(Box.createRigidArea(new Dimension(0, 10)));
		add(buttonView);

		// action listener for viewing formal params
		buttonView.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				XMLGroupPanel gp = (XMLGroupPanel) getParent().getParent();
				XMLComboPanel cp = (XMLComboPanel) gp.getComponent(0);
				JComboBox cb = cp.getComboBox();
				Object sel = cp.getSelectedItem();
				if (!(sel instanceof XMLComplexElement))
					return;
				XMLComplexElement selected = (XMLComplexElement) sel;
				if (selected == null)
					return;
				XMLElement fps = selected.get("FormalParameters");
				if (fps == null) { // 'selected' is instance of Application
					Object tmp = selected.get("Choice");
					tmp = ((XMLChoice) tmp).getChoosen();
					if (tmp instanceof FormalParameters) {
						fps = (XMLElement) tmp;
					}
				}
				if (fps != null) {
					XMLElementDialog de = new XMLElementDialog(getDialog(),
							selected.toString() + " - " + fps.toLabel());
					de.editXMLElement(fps.getPanel(), false, false);
				}
				JList l = ((XMLListPanel) controlledPanel).getList();
				l.requestFocus();
			}
		});

	}

}
