package com.ds.bpm.bpd.xml.elements.event;

import java.util.Iterator;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.elements.Join;
import com.ds.bpm.bpd.xml.elements.Limit;
import com.ds.bpm.bpd.xml.elements.Split;
import com.ds.bpm.bpd.xml.elements.WorkflowProcess;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;
import com.ds.common.util.XMLUtility;

public abstract class ActivityEventBase extends XMLComplexElement {

    // 活动时限
    public Limit limit = new Limit();

    // 活动开始条件
    public Join join = new Join();

    // 活动结束条件
    public Split split = new Split();

    // 活动对象
    Activity act;

    private Join oldJoin;

    private Split oldsplit;

    private WorkflowProcess workflowProcess;

    // 构造器
    public ActivityEventBase(WorkflowProcess process, Activity act) {
        super();
        this.workflowProcess = process;
        this.act = act;
        // 初始化页面显示属性
        setLabelName(ResourceManager.getLanguageDependentString("Activity.ActivityEvent.display"));
        limit.setLabelName(ResourceManager.getLanguageDependentString("Activity.ActivityEvent.Limit.display"));

    }

    protected void fillStructure() {
        complexStructure.add(limit);
        complexStructure.add(join);
        complexStructure.add(split);
    }

    // 把活动办理权限信息保存在XML文件中
    public void toXML(Node parent) {
        // super.toXML(parent);

        NodeList nodeList = ((Element) parent).getElementsByTagName("TransitionRestrictions");
        Element trsElem;
        Document doc = parent.getOwnerDocument();

        if (nodeList.getLength() != 0) {
            trsElem = (Element) nodeList.item(0);
        } else {
            trsElem = doc.createElement("TransitionRestrictions");
            parent.appendChild(trsElem);
        }
        join.toXML(trsElem);
        split.toXML(trsElem);


        nodeList = ((Element) parent).getElementsByTagName("ExtendedAttributes");
        Element easElem;
        if (nodeList.getLength() != 0) {
            easElem = (Element) nodeList.item(0);
        } else {
            easElem = doc.createElement("ExtendedAttributes");
            parent.appendChild(easElem);
        }


        for (Iterator iter = complexStructure.iterator(); iter.hasNext(); ) {
            XMLElement element = (XMLElement) iter.next();
            String elemName = element.toName();
            if (elemName.equalsIgnoreCase(limit.toName()) || elemName.equalsIgnoreCase(join.toName())
                    || elemName.equalsIgnoreCase(split.toName())) {
                continue;
            }
            Element eaElem = doc.createElement("ExtendedAttribute");
            eaElem.setAttribute("Name", element.toName());
            eaElem.setAttribute("Value", element.toValue().toString());
            easElem.appendChild(eaElem);
        }
        limit.toXML(parent);

    }

    // 从活动扩展属性保存到活动事件对象
    public abstract void afterImporting();

    // 解析XPDL文件保存到活动事件对象
    public void fromXML(Node node) {

        super.fromXML(node);
        // System.out.println(XMLUtil.getContent(node, true));

        Node limitNode = XMLUtility.getFirstChild(node, "Limit");
        limit.fromXML(limitNode);
        Node trsNode = XMLUtility.getFirstChild(node, "TransitionRestrictions");
        if (trsNode != null) {
            List trList = XMLUtility.getChildNodes(trsNode, Node.ELEMENT_NODE);
            for (int i = 0; i < trList.size(); i++) {
                Node trNode = (Node) trList.get(i);
                //  Node childNode = XMLUtility.getFirstChild(trNode, Node.ELEMENT_NODE);

                List<Node> childList = XMLUtility.getChildNodes(trNode, Node.ELEMENT_NODE);

                for (Node childNode : childList) {
                    if (childNode.getNodeName().equalsIgnoreCase("Join")) {
                        join.fromXML(childNode);
                    }
                    if (childNode.getNodeName().equalsIgnoreCase("Split")) {
                        split.fromXML(childNode);
                    }
                }


            }
        }

    }

    public void checkJoin() {
        if (act.getIncomingTransitions().size() < 2) {
            join.setReadOnly(true);
        }
        if (act.getNonExceptionalOutgoingTransitions().size() < 2) {
            split.setReadOnly(true);
        }
    }

    public Join getJoin() {
        return this.join;
    }

    public Split getSplit() {
        return this.split;
    }

    // 验证元素填写的合法性
    public boolean isValidEnter(XMLPanel groupPanel) {
        if ((groupPanel instanceof XMLGroupPanel) && ((XMLGroupPanel) groupPanel).getPanel(0) instanceof XMLTextPanel) {
            XMLTextPanel p = (XMLTextPanel) ((XMLGroupPanel) groupPanel).getPanel(0);
            String value = p.getText();
            if (!Utils.isNumber(value)) {
                XMLPanel.errorMessage(groupPanel.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"), p.getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
                        ResourceManager.getLanguageDependentString("Sys.ErrorMessage.invalid"));
                p.requestFocus();
                return false;
            }
            if (((XMLGroupPanel) groupPanel).getPanel(2) instanceof XMLTextPanel) {
                if (p != null) {
                    value = p.getText();
                    if (!Utils.isNumber(value)) {
                        XMLPanel.errorMessage(groupPanel.getDialog(), ResourceManager.getLanguageDependentString("Sys.ErrorMessage.dialogTitle"), p.getOwner().toLabel() + ResourceManager.getLanguageDependentString("Sys.Colon"),
                                ResourceManager.getLanguageDependentString("Sys.ErrorMessage.invalid"));
                        p.requestFocus();
                        return false;
                    }
                    this.oldJoin = (Join) join.clone();
                    this.oldsplit = (Split) split.clone();
                }
            }

        }

        return true;
    }

    /**
     * ACTIVITYEVENT 出入规则类型是否改变 TRUE 发生改变 FALSE 未改变
     *
     * @return
     */
    public boolean isModified() {
        if (oldJoin == null || oldsplit == null) {
            return false;
        }
        if (this.oldJoin.getType().equals(join.getType()) && this.oldsplit.getType().equals(split.getType())) {
            return false;
        }
        return true;
    }

    // 实现Clone方法
    public ActivityEventBase clone() {
        ActivityEventBase ae = (ActivityEventBase) super.clone();
        ae.limit = (Limit) this.limit.clone();
        ae.join = (Join) this.join.clone();
        ae.split = (Split) this.split.clone();

        return ae;
    }

}
