/* WorkflowProcess.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的流程类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import javax.swing.JTextField;

import com.ds.bpm.enums.process.ProcessDefEnums;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.Utils;
import com.ds.bpm.bpd.config.AppConfigManager;
import com.ds.bpm.bpd.listener.ListenerManager;
import com.ds.bpm.bpd.plugin.PluginElement;
import com.ds.bpm.bpd.plugin.PluginManager;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.activity.Activities;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.activity.OutFlow;
import com.ds.bpm.bpd.xml.activity.SubFlow;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;
import com.ds.bpm.client.ProcessDef;
import com.ds.bpm.enums.process.ProcessDefAccess;
import com.ds.bpm.enums.process.ProcessDefVersionStatus;
import com.ds.common.util.StringUtility;
import com.ds.config.BPDProjectConfig;
import com.ds.config.CParameter;
import com.ds.config.PluginType;
import com.ds.enums.EnumsUtil;
import com.ds.iot.json.UserInfo;

/**
 * Represents a WfMC DTD element that has the similar name. 流程属性元素类
 */
public class WorkflowProcess extends XMLCollectionElement {

    // 结束节点的分隔符
    private transient static final String ENDOFWORKFLOW_SEPARATE = "$";

    // 连接同一结束节点的活动间ID的分隔符
    public transient static final String ENDOFWORKFLOWACT_SEPARATE = "#";

    // 内部资源属性
    private transient Map properties = new HashMap();

    // 流程监听器集
    private transient List processListeners;

    // 路由监听器集
    private transient List traListeners;

    // 活动监听器集
    private transient List actListeners;

    private transient List commandListeners;

    // 标识工作流是否为新建
    private transient boolean bNew = false;

    // 流程类型值
    private transient String classificationCode;

    // 流程头信息
    private ProcessHeader refProcessHeader = new ProcessHeader();

    private RedefinableHeader refRedefinableHeader = new RedefinableHeader(this);

    private Participants refParticipants; // min=0

    private ActivitySets refActivitySets = new ActivitySets(this); // min=0

    private Activities refActivities = new Activities(this); // min=0

    private Transitions refTransitions = new Transitions(this); // min=0

    private XMLAttribute mainVersionId = new XMLAttribute("MainProcessVersionId"); // required

    // 流程扩展属性集合
    private ExtendedAttributes refExtendedAttributes = new ExtendedAttributes(this);

    // min=0

    // ------------------------流程一般属性-------------------------
    // 流程名称
    private XMLAttribute attrName = new XMLAttribute("Name");

    // 流程描述
    private Description desc = (Description) refProcessHeader.get("Description");

    // 流程类型
    private XMLAttribute attrClassification = new XMLAttribute(PluginType.Classification.getType());

    // 所属系统标识
    private XMLAttribute attrSystemCode = new XMLAttribute("SystemCode");

    private XMLAttribute attrAccessLevel = new XMLAttribute(EnumsUtil.getAttribute(ProcessDefEnums.AccessLevel));

    // ------------------------版本相关属性-------------------------
    // 流程版本ID
    private XMLAttribute attrVersionId = new XMLAttribute("VersionId");

    // 流程版本号
    private XMLElement version = refRedefinableHeader.get("Version");

    // 版本描述
    private Description versionDesc = new Description(true);

    // 版本状态
    private XMLAttribute publicationStatus = (XMLAttribute) refRedefinableHeader.get("PublicationStatus");

    // 激活时间
    private XMLAttribute activeTime = new XMLAttribute("ActiveTime");

    // 冻结时间
    private XMLAttribute freezeTime = new XMLAttribute("FreezeTime");

    // 创建人ID
    private XMLElement creatorId = refRedefinableHeader.get("Author");

    // 创建人姓名
    private XMLAttribute creatorName = new XMLAttribute("CreatorName");

    // 创建时间
    private XMLElement created = refProcessHeader.get("Created");

    // 修改人ID
    private XMLAttribute modifierId = new XMLAttribute("ModifierId");

    // 修改人姓名
    private XMLAttribute modifierName = new XMLAttribute("ModifierName");

    // 修改时间
    private XMLAttribute modifyTime = new XMLAttribute("ModifyTime");

    // 时间限制
    private XMLElement limit = refProcessHeader.get("Limit");

    // 时间限制单位
    private XMLAttribute durationUnit = (XMLAttribute) refProcessHeader.get("DurationUnit");

    // ------------------------流程权限属性-------------------------
    // 流程监控组
    private XMLElement responsibles = refRedefinableHeader.get("Responsibles");

    // 流程权限组
    private XMLCollection rightGroups = new RightGroups(this);

    // ------------------------监听器属性-------------------------
    // 监听器
    private Listeners listeners = new Listeners(this);

    // 插件工具类
    private transient PluginManager manager;

    // 流程插件属性集
    private transient Map plugins;

    // 流程原插件属性集
    private transient Map oldPlugins = new HashMap();

    // 监听器工具类
    private transient ListenerManager listenerManager;

    /**
     * The container for all processes.
     */
    private transient Package myPackage = null;

    private transient long nextActivityId = 0;
    private transient long nextTransitionId = 0;
    /**
     * Used to hold the visual order of participants within workflow process graph. Set and valid only immediatelly
     * after exporting to or immediatelly after importing from an XML file.
     */
    private transient String visuallySortedParticipantIDs = "";

    /*
     * The set of strings where extended attribute information for description of visual properties for starts of
     * workflow process are held. This information is valid only immediatelly after exporting to or immediatelly after
     * importing from an XML file.
     */
    private Set startDescriptions = new HashSet();

    /*
     * The set of strings where extended attribute information for description of visual properties for ends of workflow
     * process are held. Set and valid only immediatelly after exporting to or immediatelly after importing from an XML
     * file.
     */
    private Set endDescriptions = new HashSet();

    /**
     * Enables canceling of changes to the extended attributes collection.
     */
    private ExtendedAttributes clonedEAs;

    /**
     * Creates a new instance of the class.
     *
     * @param wps The reference to collection of workflow processes where this instance will be put into.
     * @param p   The container for all processes.
     */
    public WorkflowProcess(WorkflowProcesses wps, Package p) {
        super(wps);

        this.myPackage = p;
        init();
    }

    /**
     * ADD BY WENZHANG 2006-03-01 未经测试不推荐使用
     */

    public WorkflowProcess(WorkflowProcesses wps, Package p, boolean SubFlow) {
        super(wps);
        init();
        if (SubFlow) {
            attrAccessLevel.setValue(ProcessDefAccess.Private.getType());
        } else {
            attrAccessLevel.setValue(ProcessDefAccess.Public.getType());
        }

        this.myPackage = p;

    }

    /**
     * WENZHANG 06-03-04 本方法存在缺陷使用时请注意条件 本方法适用的范围：每个包内只能有一个主流程 如果主流程不存在（包内只有一个或多个子流程情况可能存在） 如果存在多个主流程按顺序返回第一个
     *
     * @return
     */
    public WorkflowProcess getMainProcess() {
        if (!this.isSubFlow()) {
            return this;
        } else {
            Package pg = this.getPackage();
            WorkflowProcesses wps = (WorkflowProcesses) pg.get("WorkflowProcesses");
            Iterator it = wps.getTableElements().iterator();
            for (; it.hasNext(); ) {
                WorkflowProcess wp = (WorkflowProcess) it.next();
                if (!wp.isSubFlow()) {
                    return wp;
                }
            }
        }
        return null;
    }

    public WorkflowProcess(WorkflowProcesses wps, Package p, WFApplication wfApp, boolean isNew, String processId) {
        super(wps);
        this.myPackage = p;
        String[][] apps = AppConfigManager.getInstance().getApps();
        if (processId != null) {
            this.attrId.setValue(processId);
        }

        if (apps != null) {
            attrSystemCode = new XMLAttribute("SystemCode", apps, 0);
        }
        init();

        attrSystemCode.setValue(wfApp.get("SystemCode").toValue());
        attrSystemCode.refreshDisplayValue();
        attrAccessLevel.setValue(wfApp.get("AccessLevel").toValue());

        attrAccessLevel.refreshDisplayValue();

        if (!wfApp.get("AccessLevel").toValue().equals(ProcessDefAccess.Public.getType())) {
            this.mainVersionId.setValue(getMainProcess().getMainProcess().getVersionID());
        }

        if (wfApp != null && isNew) {

            this.setClassifications(wfApp.getSystemCode(), wfApp.getClassificationCode());
            attrClassification.setValue(this.getMainProcess().getClassifications());
            attrClassification.setReadOnly(true);
            loadPlugins();
            fillPlugins();

        }

    }

    // 设置可配置的流程类型
    public void setClassifications(String appName, String classificationCode) {
        UserInfo user = BPD.getInstance().getUserInfo();
        if (user != null) {
            List<BPDProjectConfig> classifications = AppConfigManager.getInstance().getProcessClassifications(appName, user.getId());
            if (classifications != null && classifications.size() > 0) {

                String[][] flowArr = new String[classifications.size()][2];
                int i = 0;
                for (BPDProjectConfig classification : classifications) {
                    flowArr[i] = new String[]{classification.getName(), classification.getCode()};
                    i = i + 1;
                }

                attrClassification = new XMLAttribute(PluginType.Classification.getType(), flowArr, 0);
                int index = getIndex(PluginType.Classification.getType());
                if (index != -1) {
                    complexStructure.set(index, attrClassification);
                } else {
                    complexStructure.add(attrClassification);
                }

            }
            if (classificationCode != null) {
                attrClassification.setValue(classificationCode);
                attrClassification.refreshDisplayValue();
            }
            // attrClassification.setReadOnly(true);
            attrClassification.setLabelName(ResourceManager.getLanguageDependentString("Process.General.Classification.display"));
        }
    }

    public String getProjectName() {
        return this.getClassifications();
    }


    // 设置可配置的流程类型
    public String getClassifications() {
        return attrClassification.toValue().toString();
    }

    private void init() {
        // must be defined here because somewhere else in code
        // (Participants constructor) is checked for a BPD
        refParticipants = new Participants(this); // min=0

        // 初始化页面显示信息
        // 流程一般属性
        attrId.setReadOnly(true);
        attrId.setLabelName(ResourceManager.getLanguageDependentString("Process.General.ID.display"));
        attrName.setRequired(true);
        attrName.setLabelName(ResourceManager.getLanguageDependentString("Process.General.Name.display"));
        attrClassification.setLabelName(ResourceManager.getLanguageDependentString("Process.General.Classification.display"));
        desc.setLabelName(ResourceManager.getLanguageDependentString("Process.General.Desc.display"));
        attrSystemCode.setLabelName(ResourceManager.getLanguageDependentString("Process.General.SystemCode.display"));
        // attrSystemCode.setReadOnly(true);
        attrAccessLevel.setLabelName(ResourceManager.getLanguageDependentString("Process.General.AccessLevel.display"));
        attrAccessLevel.setReadOnly(true);

        // 版本相关属性
        attrVersionId.setReadOnly(true);
        attrVersionId.setValue(Utils.generateUUID());
        attrVersionId.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.ID.display"));
        version.setReadOnly(true);
        // 得到workflow的版本号

        version.setValue(String.valueOf(((XML) BPD.getInstance().getXMLInterface()).registerWorkflowVersion(getID())));
        version.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.Num.display"));
        versionDesc.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.Desc.display"));
        publicationStatus.setReadOnly(true);
        publicationStatus.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.Status.display"));
        activeTime.setReadOnly(true);
        activeTime.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.ActiveTime.display"));
        freezeTime.setReadOnly(true);
        freezeTime.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.FreezeTime.display"));
        creatorId.setReadOnly(true);
        creatorId.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.CreatorId.display"));
        creatorName.setReadOnly(true);
        creatorName.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.CreatorName.display"));
        created.setReadOnly(true);
        created.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.Created.display"));
        created.setValue(XMLUtil.getCurrentDateAndTime());
        modifierId.setReadOnly(true);
        modifierId.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.ModifierId.display"));
        modifierName.setReadOnly(true);
        modifierName.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.ModifierName.display"));
        modifyTime.setReadOnly(true);
        modifyTime.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.ModifyTime.display"));
        limit.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.Limit.display"));
        durationUnit.setLabelName(ResourceManager.getLanguageDependentString("Process.Version.DurationUnit.display"));

        // 流程监控人
        responsibles.setLabelName(ResourceManager.getLanguageDependentString("Process.Right.Responsibles.display"));

        saveUserInfo();

        fillStructure();
        try {
            setIDPrefixForCollections();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!this.getMainProcess().getID().equals(this.getID())) {
            this.mainVersionId.setValue(this.getMainProcess().getVersionID());
        }
    }

    public XMLAttribute getMainVersionId() {
        return mainVersionId;
    }

    public void setMainVersionId(XMLAttribute mainVersionId) {
        this.mainVersionId = mainVersionId;
    }

    /**
     * Defines the super-class method. Read the explanation for this method within XMLComplexElement class.
     */
    protected void fillStructure() {
        super.fillStructure();
        complexStructure.add(attrName);
        attributes.add(attrName);
        complexStructure.add(attrAccessLevel);
        attributes.add(attrAccessLevel);
        refProcessHeader.setRequired(true);
        complexStructure.add(refProcessHeader);
        complexStructure.add(refRedefinableHeader);
        complexStructure.add(refParticipants);
        complexStructure.add(refActivitySets);
        complexStructure.add(refActivities);
        complexStructure.add(refTransitions);
        complexStructure.add(refExtendedAttributes);
        complexStructure.add(mainVersionId);

        ExtendedAttribute ea;
        List refExtendedAttributesList = ((ArrayList) refExtendedAttributes.toCollection());
        // 把流程类型加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", attrClassification.toName());
        ea.set("Value", attrClassification.toValue());
        refExtendedAttributesList.add(ea);
        // 把所属系统标识加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", attrSystemCode.toName());
        ea.set("Value", attrSystemCode.toValue());
        refExtendedAttributesList.add(ea);
        // 把版本ID加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", attrVersionId.toName());
        ea.set("Value", attrVersionId.toValue());
        refExtendedAttributesList.add(ea);
        // 把版本描述加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", versionDesc.toName());
        ea.set("Value", versionDesc.toValue());
        refExtendedAttributesList.add(ea);
        // 把激活时间加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", activeTime.toName());
        ea.set("Value", activeTime.toValue());
        refExtendedAttributesList.add(ea);
        // 把冻结时间加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", freezeTime.toName());
        ea.set("Value", freezeTime.toValue());
        refExtendedAttributesList.add(ea);
        // 把创建人姓名加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", creatorName.toName());
        ea.set("Value", creatorName.toValue());
        refExtendedAttributesList.add(ea);
        // 把修改人ID加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", modifierId.toName());
        ea.set("Value", modifierId.toValue());
        refExtendedAttributesList.add(ea);
        // 把修改人姓名加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", modifierName.toName());
        ea.set("Value", modifierName.toValue());
        refExtendedAttributesList.add(ea);
        // 把修改时间加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", modifyTime.toName());
        ea.set("Value", modifyTime.toValue());
        refExtendedAttributesList.add(ea);
        // 把流程权限组加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.get("Value").setRequired(false);
        ea.set("Name", rightGroups.toName());
        ea.setAnyXMLCollection(rightGroups);
        refExtendedAttributesList.add(ea);

        // 把监听器属性加到扩展属性
        ea = new ExtendedAttribute(refExtendedAttributes);
        ea.set("Name", listeners.toName());
        ea.get("Value").setRequired(false);
        ea.setAnyXMLCollection(listeners);

        refExtendedAttributesList.add(ea);
        if (!this.getMainProcess().getID().equals(this.getID())) {
            this.mainVersionId.setValue(this.getMainProcess().getVersionID());
        }
    }

    private void fillPlugins() {
        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            String name = (String) entry.getKey();
            Object val = entry.getValue();
            if (oldPlugins.containsKey(name)) {
                Object oldVal = oldPlugins.get(name);
                int index = complexStructure.indexOf(oldVal);
                // complexStructure.set(index, val);
                plugins.put(name, oldVal);
            } else {
                complexStructure.add(val);
            }
            oldPlugins.put(name, val);
        }
    }

    /**
     * Returns the package that is container for process.
     *
     * @return The package of workflow process.
     */
    public Package getPackage() {
        return myPackage;
    }

    protected void addPropertyToAllActivities(UserProperty up) {
        refActivities.addPropertyToAllActivities(up);
        refActivitySets.addPropertyToAllActivities(up);
    }

    protected void removePropertyFromAllActivities(UserProperty up) {
        refActivities.removePropertyFromAllActivities(up);
        refActivitySets.removePropertyFromAllActivities(up);
    }

    protected void refreshMandatories(UserProperty up) {
        refActivities.refreshMandatories(up);
        refActivitySets.refreshMandatories(up);
    }

    /**
     * Returns set of entities to be inserted for given object. The object can be workflow process or block activity.
     */
    public LinkedHashSet getEntitiesToInsert(Object forObject) {
        LinkedHashSet lhs = new LinkedHashSet();
        boolean isMine = myPackage.isMadeByBPD();
        Collection acts = null;
        Collection parts = null;
        Collection trans = null;
        if (forObject instanceof WorkflowProcess) {
            acts = refActivities.toCollection();
            trans = refTransitions.toCollection();
        } else if (forObject instanceof Activity) {
            Activity act = (Activity) forObject;
            BlockActivity ba = act.getBlockActivity();
            String baID = "";
            if (ba != null) {
                baID = ba.get("Id").toValue().toString();
            }
            ActivitySet as = refActivitySets.getActivitySet(baID);
            if (as != null) {
                acts = ((Activities) as.get("Activities")).toCollection();
                trans = ((Transitions) as.get("Transitions")).toCollection();
            }
        }

        try {
            parts = gatherParticipants(forObject, acts, isMine);
            lhs.addAll(acts);
            lhs.addAll(parts);
            lhs.addAll(trans);
        } catch (Exception ex) {
        }

        return lhs;
    }

    /*
     * Returns extended attribute information for description of visual properties for all starts of workflow process.
     * Valid only after importing from an XML. @return The specific set of descriptions of Start objects attributes.
     */
    public Set getStartDescriptions() {
        return startDescriptions;
    }

    public String getSystemCode() {
        String systemCode = (String) attrSystemCode.toValue();
        return systemCode;
    }

    /*
     * Sets extended attribute information for description of visual properties for all starts of workflow
     * process. @param sd The specific set of descriptions of Start objects attributes.
     */
    public void setStartDescriptions(Set sd) {
        startDescriptions = sd;
    }

    /*
     * Returns extended attribute information for description of visual properties for all ends of workflow process
     * after. Valid only after importing from an XML. @return The specific set of descriptions of End objects
     * attributes.
     */
    public Set getEndDescriptions() {
        return endDescriptions;
    }

    /*
     * Sets extended attribute information for description of visual properties for all ends of workflow process. @param
     * eds The specific set of descriptions of End objects attributes.
     */
    public void setEndDescriptions(Set eds) {
        endDescriptions = eds;
    }

    /**
     * Used to get the visual order of participant visual objects contained within a WorkflowProcess graph.
     * <p>
     * NOTE: This order is valid only immediately after import of WorkflowProcess or it's export to XML file, also, this
     * order is an ExtendedAttribute in a WfMC DTD sence, so it is valid only for XMLs saved by this version of the BPD
     * application.
     *
     * @return String representation of visually sorted participant ID's.
     */
    public String getVisuallySortedParticipantIDs() {
        return visuallySortedParticipantIDs;
    }

    /**
     * Used to set the visual order of participant visual objects contained within a WorkflowProcess graph.
     *
     * @param vsPID String representation of visually sorted participant ID's.
     */
    public void setVisuallySortedParticipantIDs(String vsPID) {
        visuallySortedParticipantIDs = vsPID;
    }

    /**
     * Gets the tooltip for participant. The tooltip consists of property names and values.
     *
     * @return The tooltip to be displayed when user holds the mouse above participant's graph object.
     */
    public String getTooltip() {
        return XMLUtil.makeTooltip(new XMLElement[]{attrId, attrName, attrAccessLevel, refProcessHeader.get("Created"), refProcessHeader.get("Description"), refProcessHeader.get("Priority"), refProcessHeader.get("Limit"),
                refProcessHeader.get("ValidFrom"), refProcessHeader.get("ValidTo"), refRedefinableHeader.get("Author"), refRedefinableHeader.get("Version"), refRedefinableHeader.get("Codepage"), refRedefinableHeader.get("Countrykey"),
                refRedefinableHeader.get("PublicationStatus")});
    }

    /**
     * Overrides super-class method to realize this class specific writting to XML file.
     */
    public void toXML(Node parent) throws DOMException {

        ExtendedAttribute ea;
        // 保存流程类型到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(attrClassification.toName());
        ea.set("Value", attrClassification.toValue());
        // 保存所属系统标识到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(attrSystemCode.toName());
        ea.set("Value", attrSystemCode.toValue());
        // 保存版本ID到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(attrVersionId.toName());
        ea.set("Value", attrVersionId.toValue());
        // 保存版本描述到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(versionDesc.toName());
        ea.set("Value", versionDesc.toValue());
        // 保存激活时间到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(activeTime.toName());
        ea.set("Value", activeTime.toValue());
        // 保存冻结时间到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(freezeTime.toName());
        ea.set("Value", freezeTime.toValue());
        // 保存创建人姓名到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(creatorName.toName());
        ea.set("Value", creatorName.toValue());
        // 保存修改人ID到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(modifierId.toName());
        ea.set("Value", modifierId.toValue());
        // 保存修改人姓名到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(modifierName.toName());
        ea.set("Value", modifierName.toValue());
        // 保存修改时间到扩展属性
        ea = refExtendedAttributes.getExtendedAttribute(modifyTime.toName());
        ea.set("Value", modifyTime.toValue());

        Iterator it;

        // remove all internally used ext. attribs
        Set easToRemove = new HashSet();

        if (visuallySortedParticipantIDs.length() > 0) {
            ea = new ExtendedAttribute(refExtendedAttributes);
            ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
            ea.set("Name", "ParticipantVisualOrder");
            ea.set("Value", visuallySortedParticipantIDs);
            easToRemove.add(ea);
        }

        // ************** writting start and end activities
        if (endDescriptions.size() > 0) {
            it = endDescriptions.iterator();
            ea = new ExtendedAttribute(refExtendedAttributes);
            ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
            ea.set("Name", "EndOfWorkflow");
            ea.set("Type", "BPD");
            String eaValue = "";
            while (it.hasNext()) {
                eaValue = eaValue + WorkflowProcess.ENDOFWORKFLOW_SEPARATE + (String) it.next();
            }
            if (!eaValue.equals("")) {
                eaValue = eaValue.substring(WorkflowProcess.ENDOFWORKFLOW_SEPARATE.length());
            }
            ea.set("Value", eaValue);
            easToRemove.add(ea);
        }
        if (startDescriptions.size() > 0) {
            it = startDescriptions.iterator();

            while (it.hasNext()) {
                ea = refExtendedAttributes.getExtendedAttribute("StartOfWorkflow");
                if (ea == null) {
                    ea = new ExtendedAttribute(refExtendedAttributes);
                }
                ;

                ((ArrayList) refExtendedAttributes.toCollection()).add(0, ea);
                ea.set("Name", "StartOfWorkflow");
                ea.set("Value", (String) it.next());
                ea.set("Type", "BPD");

                easToRemove.add(ea);
            }
        }
        if (parent.getOwnerDocument() != null) {
            super.toXML(parent);
            // this happens when user wants to view XPDL presentation of the
            // graph
        } else {
            Node node = ((Document) parent).createElement(name);
            super.toXML(node);
            parent.appendChild(node);
        }

        // removing internally used ext. attribs - otherwise, it would be
        // duplicated
        refExtendedAttributes.toCollection().removeAll(easToRemove);
        if (!this.getMainProcess().getID().equals(this.getID())) {
            this.mainVersionId.setValue(this.getMainProcess().getVersionID());
        }
    }

    /**
     * Called by Package object after importing of XML file to determine correct block activites and loop activities,
     * and after that to determine the activities to insert at the workflow process graph.
     */
    protected void afterImporting(boolean importUserProperties) {
        // checking if package is made by our PE, and depending on
        // that information, collects InlineBlock, Loop and main
        // graph information, and sorts them properly
        boolean isMine = myPackage.isMadeByBPD();

        // remove all internally used ext. attribs
        Set easToRemove = new HashSet();

        if (isMine) {
            Iterator it = refExtendedAttributes.toCollection().iterator();
            String nm = "";
            String val = "";
            while (it.hasNext()) {
                ExtendedAttribute ea = (ExtendedAttribute) it.next();
                nm = ea.get("Name").toValue().toString();
                val = ea.get("Value").toValue().toString();
                if (nm.equalsIgnoreCase("ParticipantVisualOrder") && visuallySortedParticipantIDs.length() == 0) {
                    visuallySortedParticipantIDs = val;
                    easToRemove.add(ea);
                    continue;
                }
                if (nm.equalsIgnoreCase("StartOfWorkflow")) {
                    if (XMLUtil.howManyStringsWithinString(val, ";") == 4) {
                        startDescriptions.add(val);
                        easToRemove.add(ea);
                        continue;
                    }
                }
                if (nm.equalsIgnoreCase("EndOfWorkflow")) {
                    String[] ends = Utils.tokenize(val, WorkflowProcess.ENDOFWORKFLOW_SEPARATE);
                    for (int i = 0; i < ends.length; i++) {
                        String endValue = ends[i];
                        String[] values = Utils.tokenize(endValue, ";");
                        if (values != null && values.length == 5) {
                            String[] acts = Utils.tokenize(values[1], WorkflowProcess.ENDOFWORKFLOWACT_SEPARATE);
                            if (acts != null && acts.length > 0) {
                                for (int j = 0; j < acts.length; j++) {
                                    String value = values[0] + ";" + acts[j] + ";" + values[2] + ";" + values[3] + ";" + values[4];
                                    endDescriptions.add(value);
                                }
                            }
                        }
                    }
                    easToRemove.add(ea);
                    continue;
                }
                // 把XPDL文件中流程扩展属性存入流程对象
                if (nm.equalsIgnoreCase(PluginType.Classification.getType())) {
                    attrClassification.setValue(val);
                    attrClassification.refreshDisplayValue();

                    continue;
                }
                if (nm.equalsIgnoreCase("SystemCode")) {
                    attrSystemCode.setValue(val);
                    // attrSystemCode.setChoices(new String[]{val});
                    attrSystemCode.refreshDisplayValue();
                    continue;
                }
                if (nm.equalsIgnoreCase("VersionId")) {
                    attrVersionId.setValue(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("Description")) {
                    versionDesc.setValue(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("ActiveTime")) {
                    activeTime.setValue(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("FreezeTime")) {
                    freezeTime.setValue(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("CreatorName")) {
                    creatorName.setValue(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("ModifierId")) {
                    modifierId.setValue(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("ModifierName")) {
                    modifierName.setValue(val);
                    continue;
                }
                if (nm.equalsIgnoreCase("ModifyTime")) {
                    modifyTime.setValue(val);
                    continue;
                }
            }
            // // 下载应用配置文件
            WFApplication wfApp = new WFApplication();
            String appName = attrSystemCode.toValue().toString();
            String[][] apps = AppConfigManager.getInstance().getApps();
            if (apps != null && apps.length > 0) {
                XMLAttribute newattrSystemCode = new XMLAttribute("SystemCode", apps, 0);
                // attrSystemCode.setReadOnly(true);
                newattrSystemCode.setLabelName(ResourceManager.getLanguageDependentString("Process.General.SystemCode.display"));
                int index = getIndex("SystemCode");
                if (index != -1) {
                    complexStructure.set(index, attrSystemCode);
                } else {
                    complexStructure.add(attrSystemCode);
                }
                attrSystemCode.setValue(appName);
                attrSystemCode.setRequired(false);
                attrSystemCode.setReadOnly(true);
                // this.attrClassification.setReadOnly(true);
                // attrSystemCode.getOldPanel().updatePanel(new XMLComboPanel(newattrSystemCode, XMLPanel.BOX_LAYOUT,
                // true));

            }

            // 设置流程类型

            // if (!this.isSubFlow()) {
            // AppConfigManager.getInstance().downloadConfigFile(appName,this.getClassifications());
            // //setClassifications(wfApp, appName);
            // }

            try {
                for (Iterator iter = plugins.entrySet().iterator(); iter.hasNext(); ) {
                    Map.Entry entry = (Map.Entry) iter.next();
                    ((PluginElement) entry.getValue()).afterImporting();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        // 设置流程类型

        // 监听器设置
        listeners.afterImporting();
        saveUserInfo();
        // removing internally used ext. attribs - otherwise, it would
        // be shown within ea list
        refExtendedAttributes.toCollection().removeAll(easToRemove);

        // Setting the responsibles
        refRedefinableHeader.afterImporting();
        // Adjusting neccessary activities
        refActivitySets.afterImporting(importUserProperties);
        refActivities.afterImporting(importUserProperties);
        refTransitions.afterImporting();
        refActivities.fillOutgoingTransitions();

    }

    /**
     * Returns the sorted set of participants for given object. The object can be block activity or workflow process.
     */
    private LinkedHashSet gatherParticipants(Object forObject, Collection ownedActivities, boolean isMine) {

        LinkedHashSet gatherInto = new LinkedHashSet();

        String vsIDs = "";
        String[] vIDs = null;

        if (isMine) {
            String delimiterSign = ";";
            // if this is a block activity
            if (forObject instanceof Activity) {
                Activity block = (Activity) forObject;
                vsIDs = block.getVisuallySortedParticipantIDs();
                // it is a main graph of workflow process
            } else {
                vsIDs = getVisuallySortedParticipantIDs();
            }
            vIDs = XMLUtil.tokenize(vsIDs, delimiterSign);
            // case when importing XML from other vendors
        } else {
            if (ownedActivities.size() > 0) {
                Set partIDs = new HashSet();
                Iterator it = ownedActivities.iterator();
                Activity a;

                String ID;
                while (it.hasNext()) {
                    Object nextObj = it.next();
                    if (nextObj instanceof Activity) {
                        a = (Activity) nextObj;
                        Object p = a.get("Performer").toValue();
                        if (p != null) {
                            if (p instanceof Participant) {
                                ID = ((Participant) p).getID();
                            } else {
                                ID = p.toString();
                            }
                            partIDs.add(ID);
                        }
                    }
                }
                if (partIDs.size() > 0) {
                    vIDs = new String[partIDs.size()];
                    partIDs.toArray(vIDs);
                }
            }
        }

        // inserting participants in ordered set
        if (vIDs != null && vIDs.length > 0) {
            Participant defaultP = Participant.getFreeTextExpressionParticipant();
            for (int i = 0; i < vIDs.length; i++) {
                String pID = vIDs[i];
                Participant p = refParticipants.getParticipant(pID);
                if (p != null) {
                    gatherInto.add(p);
                } else {
                    if (!gatherInto.contains(defaultP)) {
                        gatherInto.add(defaultP);
                    }
                }
            }
        }
        // if there is no known participant and it should be, add the
        // default participant 当新建流程时 活动及可能为0 m bu wenzhang 2018 1/30
        // if (gatherInto.size() == 0 && ownedActivities.size() > 0) {
        if (gatherInto.size() == 0) {
            gatherInto.add(Participant.getFreeTextExpressionParticipant());
        }

        return gatherInto;
    }

    /**
     * Overrides super-class method to retreive the value of this class "Name" attribute, or if it does not exist, the
     * value of "Id" attribute. This is used when displaying instance of this class within dialog.
     *
     * @return The "Name" attribute value of this class.
     */
    public String toString() {
        String disp = attrName.toString();
        if (disp.trim().length() == 0) {
            disp = attrId.toString();
        }
        return disp;
    }

    /**
     * Prepares the one of the group panels that contains some of this element editable fields.
     *
     * @param no The ordinal number of group panel to be shown.
     * @return XMLPanel to be shown.
     */
    public XMLPanel getPanel(int no) {
        XMLPanel p;
        switch (no) {
            // 流程一般属性
            case 1:
                p = new XMLGroupPanel(this, new XMLElement[]{attrId, attrName, attrClassification, attrSystemCode, attrAccessLevel, desc}, ResourceManager.getLanguageDependentString("Process.General.display"));
                break;
            // 流程版本相关属性
            case 2:
                p = new XMLGroupPanel(this, new XMLElement[]{attrVersionId, version, publicationStatus, durationUnit, limit, activeTime, freezeTime, creatorName, created, modifierName, modifyTime, versionDesc},
                        ResourceManager.getLanguageDependentString("Process.Version.display"));
                break;
            // 流程权限属性
            case 3:
                p = new XMLGroupPanel(this, new XMLElement[]{responsibles, rightGroups}, ResourceManager.getLanguageDependentString("Process.Right.display"));
                break;
            // 流程监听器属性
            case 4:
                p = listeners.getPanel();
                break;
            default:
                p = new XMLPanel();
        }
        return p;
    }

    /**
     * Prepares the tabbed panel to show editable fields of WorkflowProcess. Panel consists of seven tabs that logically
     * comprises the WorkflowProcesses elements to be edited.
     * <p>
     * NOTE: This method is never used, panels are retrieved one by one calling the method with the same name but with
     * ordinal number of wanted panel as an argument.
     *
     * @return XMLPanel to be shown.
     */
    public XMLPanel getPanel() {
        List panels = new ArrayList();
        for (int i = 0; i < 4; i++) {
            panels.add(getPanel(i + 1));
        }
        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            panels.add(((PluginElement) entry.getValue()).getPanel());
        }
        XMLTabbedPanel tp = new XMLTabbedPanel(this, (XMLPanel[]) panels.toArray(new XMLPanel[]{}));

        return tp;
    }

    // 得到流程属性页面所有的Panel
    public XMLPanel[] getPanels() {
        XMLPanel[] p = new XMLPanel[4];
        for (int i = 0; i < 4; i++) {
            p[i] = getPanel(i + 1);
        }
        return p;
    }

    /**
     * Sets proper ID prefix for all Id generators (XMLCollection class instances).
     */
    protected void setIDPrefixForCollections() {
        String colPref = getID() + WorkflowProcess.ID_DELIMITER;
        refActivitySets.setIDPrefix(colPref + "Ase");
        refActivities.setIDPrefix(colPref + "Act");
        refParticipants.setIDPrefix(colPref + "Par");
        refTransitions.setIDPrefix(colPref + "Tra");
    }

    public void fromXML(Node node) {
        // 清空原有值
        attrAccessLevel.setValue("");

        // clearing redefinable header that is filled during creation of
        // object with intention to inherit properties from package
        refRedefinableHeader.set("Author", "");
        refRedefinableHeader.set("Version", "");
        refRedefinableHeader.set("Codepage", "");
        refRedefinableHeader.set("Countrykey", "");
        XMLAttribute ps = (XMLAttribute) refRedefinableHeader.get("PublicationStatus");
        try {
            ps.setValue(ps.getChoices()[0]);
        } catch (Exception ex) {
        }
        Responsibles rsp = (Responsibles) refRedefinableHeader.get("Responsibles");
        rsp.clear();

        processAttributes(node);

        setIDPrefixForCollections();

        ((WorkflowProcesses) myCollection).updateID(getID());

        ProcessDef processDef = (ProcessDef) BPD.getInstance().getRemoteProcessMap().get(this.getID());
        try {
            this.setClassifications(this.getSystemCode(), processDef.getClassification());
            this.attrClassification.setValue(processDef.getClassification());
        } catch (Exception e) {
            // e.printStackTrace();
        }

        loadPlugins();
        fillPlugins();

        processElements(node);

    }

    public void readFromXML(Node node) {
        // clearing redefinable header that is filled during creation of
        // object with intention to inherit properties from package
        refRedefinableHeader.set("Author", "");
        refRedefinableHeader.set("Version", "");
        refRedefinableHeader.set("Codepage", "");
        refRedefinableHeader.set("Countrykey", "");
        XMLAttribute ps = (XMLAttribute) refRedefinableHeader.get("PublicationStatus");
        try {
            ps.setValue(ps.getChoices()[0]);
        } catch (Exception ex) {
        }
        Responsibles rsp = (Responsibles) refRedefinableHeader.get("Responsibles");
        rsp.clear();
        super.fromXML(node);
    }

    /**
     * Checks if an ID entered by the user is unique. 检查流程名称是否唯一
     */
    public boolean isIDUniqueAndValid(XMLPanel p) {
        XMLGroupPanel groupPanel;
        if (p instanceof XMLTabbedPanel) {
            groupPanel = (XMLGroupPanel) ((XMLTabbedPanel) p).getTabbedPanel(0);
        } else {
            groupPanel = (XMLGroupPanel) p;
        }
        XMLTextPanel tp = (XMLTextPanel) groupPanel.getPanel(1);
        String NameToCheck = tp.getText().trim();
        // if there is an element with given ID, return false
        XMLComplexElement wp = getCollection().getCollectionElement(NameToCheck);
        boolean isOK = true;
        String message = null;
        String dialogTitle = null;
        if (wp != null && wp != this && !(((WorkflowProcess) wp).getID()).equals(getID())) {
            message = ResourceManager.getLanguageDependentString("ErrorIDMustBeUnique");
            dialogTitle = ResourceManager.getLanguageDependentString("DialogIDIsNotUnique");
            isOK = false;
        } else if (!XMLCollection.isIdValid(NameToCheck)) {
            message = ResourceManager.getLanguageDependentString("ErrorIDMustBeValid");
            dialogTitle = ResourceManager.getLanguageDependentString("DialogIDIsNotValid");
            isOK = false;
        }
        if (!isOK) {
            XMLPanel.errorMessage(groupPanel.getDialog(), dialogTitle, "", message);
            ((JTextField) tp.getComponent(2)).requestFocus();
        }
        return isOK;
    }

    /**
     * 检查流程属性框输入值是否合法
     */
    public boolean isValidEnter(XMLPanel p) {

        return refProcessHeader.isValidEnter(((XMLTabbedPanel) p).getTabbedPanel(1));
    }

    public void setWFName(String Name) {
        this.attrName.setValue(Name);
    }

    public void setSubFlow(boolean SubFlow) {
        if (SubFlow) {
            attrAccessLevel.setValue(ProcessDefAccess.Private.getType());
        } else {
            attrAccessLevel.setValue(ProcessDefAccess.Public.getType());
        }
    }

    /**
     * 判断该工作流是否为子流程O
     *
     * @return true为子流程，否则为false
     */
    public boolean isSubFlow() {
        if (attrAccessLevel.toValue().toString().equals(ProcessDefAccess.Private.getType())) {
            return true;
        } else {
            return false;
        }
    }

    public Activities getActivities() {
        return this.refActivities;
    }

    public boolean isNew() {
        return bNew;
    }

    public void setNew(boolean bNew) {
        this.bNew = bNew;
    }

    /**
     * 得到所有的子流程
     *
     * @return
     */
    public List getSubProcessList() {
        List subProcessList = new ArrayList();
        ;
        // subFlowList=this.getSubFlow();
        Object[] actArr = this.refActivities.toCollection().toArray();
        for (int i = 0; actArr.length > i; i++) {
            Activity act = (Activity) actArr[i];
            SubFlow subFlow = act.getSubflow();
            if (subFlow != null && subFlow.get("Id") != null) {
                // subFlowList.add(subFlow);
                String processId = (String) subFlow.get("Id").toString();
                WorkflowProcess wp = this.getPackage().getWorkflowProcess(processId);
                subProcessList.add(wp);

            }
        }
        return subProcessList;

    }

    /**
     * 得到所有的块
     *
     * @return
     */
    public Activity getBlockActivity(String activitySetId) {

        Object[] actArr = this.refActivities.toCollection().toArray();
        for (int i = 0; actArr.length > i; i++) {
            Activity act = (Activity) actArr[i];
            BlockActivity blockFlow = act.getBlockActivity();
            if (blockFlow != null) {
                // subFlowList.add(subFlow);
                String bockflowId = (String) blockFlow.get("Id").toString();
                if (bockflowId.equals(activitySetId)) {
                    return act;
                }
                ;

            }
        }
        return null;

    }

    /**
     * 得到所有的子流程
     *
     * @return
     */
    public Activity getOutflowActivity(String activitySetId) {

        Object[] actArr = this.refActivities.toCollection().toArray();
        for (int i = 0; actArr.length > i; i++) {
            Activity act = (Activity) actArr[i];
            OutFlow outFlow = act.getOutflow();
            if (outFlow != null) {
                // subFlowList.add(subFlow);
                String bockflowId = (String) outFlow.get("Id").toString();
                if (bockflowId.equals(activitySetId)) {
                    return act;
                }
                ;

            }
        }
        return null;

    }

    // 设置创建者和修改者信息
    public void saveUserInfo() {
        // 得到BPD登录用户信息
        UserInfo user = BPD.getInstance().getUserInfo();
        if (user != null) {
            if (isNew() || BPD.getInstance().getActivedProcessEditor() == null || BPD.getInstance().getActivedProcessEditor().getProcessFlag() == null) {
                creatorId.setValue(user.getId());
                creatorName.setValue(user.getName());
            } else {
                modifierId.setValue(user.getId());
                modifierName.setValue(user.getName());
            }
        }
    }

    // 取得工作流的应用名称
    public String getAppName() {

        return attrSystemCode.toValue().toString();
    }

    // 设置工作流的应用名称
    public void setAppName(String appName) {
        attrSystemCode.setValue(appName);
    }

    // 得到流程监听器集
    public List getProcessListeners() {
        if (listenerManager == null || !getAppName().equals(listenerManager.getAppName()) || processListeners == null || processListeners.size() == 0) {
            listenerManager = ListenerManager.getInstance(getAppName(), getClassifications());
            processListeners = listenerManager.getProcessListeners();
        }
        return processListeners;
    }

    // 得到活动监听器集
    public List getActivityListeners() {
        if (listenerManager == null || !getAppName().equals(listenerManager.getAppName()) || actListeners == null || actListeners.size() == 0) {
            listenerManager = ListenerManager.getInstance(getAppName(), getClassifications());
            actListeners = listenerManager.getActivityListeners();
        }
        return actListeners;
    }

    // 得到活动监听器集
    public List getActivityCommandListeners() {
        if (listenerManager == null || !getAppName().equals(listenerManager.getAppName()) || commandListeners == null || commandListeners.size() == 0) {
            listenerManager = ListenerManager.getInstance(getAppName(), getClassifications());
            commandListeners = listenerManager.getActivityCommandListeners();
        }
        return commandListeners;
    }

    // 得到活动监听器集
    public List getTransitionListeners() {
        if (listenerManager == null || !getAppName().equals(listenerManager.getAppName()) || traListeners == null || traListeners.size() == 0) {
            listenerManager = ListenerManager.getInstance(getAppName(), getClassifications());
            traListeners = listenerManager.getActivityListeners();
        }
        return traListeners;
    }

    // 根据key取得内部资源
    public Object getProperty(String key) {
        return properties.get(key);
    }

    // 设置内部资源
    public void setProperty(String key, Object obj) {
        properties.put(key, obj);
    }

    // 增加流程版本号
    public void addVersion() {
        version.setValue(String.valueOf(XML.registerWorkflowVersion(getID())));
    }

    // 设置流程版本号
    public void addVersion(int num) {
        version.setValue(String.valueOf(num));
    }

    // 得到流程的版本ID
    public String getVersionID() {
        return attrVersionId.toValue().toString();
    }

    public String getName() {
        return this.attrName.toValue().toString();
    }

    // 得到流程的版本号

    public Activity getActivity(String id) {
        Activity ret = refActivities.getActivity(id);
        if (ret == null) {
            Iterator ass = refActivitySets.toCollection().iterator();
            while (ass.hasNext()) {
                ActivitySet as = (ActivitySet) ass.next();
                ret = ((Activities) as.get("Activities")).getActivity(id);
                if (ret != null) {
                    break;
                }
            }
        }
        return ret;
    }

    public String getVersionNumber() {
        return version.toValue().toString();
    }

    public long getNextActivityId() {
        return (++nextActivityId);
    }

    public long getCurrentActivityId() {
        return nextActivityId;
    }

    public void setCurrentActivityId(long curId) {
        nextActivityId = curId;
    }

    public void decrementActivityId() {
        nextActivityId--;
    }

    public void resetActivityId() {
        nextActivityId = 0;
    }

    private void loadPlugins() {
        // 读取流程插件
        try {
            if (plugins != null && manager.getAppName() == getAppName()) {
                return;
            }
            manager = PluginManager.getInstance(getAppName(), this.getClassifications());
            plugins = manager.getPlugins(PluginType.Process, null);
            for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
                Map.Entry entry = (Map.Entry) it.next();
                PluginElement pe = (PluginElement) entry.getValue();
                pe.setType(PluginType.Process);
                pe.setProperty("Process", this);
                pe.setProperty("WorkflowProcess", this);
                BPDProjectConfig classification = AppConfigManager.getInstance().getApplicationMap().get(getAppName()).getBPDProjectConfigMap().get(getClassifications());
                pe.setProperty("classifications", classification);
                pe.setBpdElement(manager.getBPDElement((String) entry.getKey()));
                Map params = manager.getPluginParams((String) entry.getKey());
                for (Iterator paramIt = params.entrySet().iterator(); paramIt.hasNext(); ) {
                    Map.Entry param = (Map.Entry) paramIt.next();
                    pe.setProperty((String) param.getKey(), ((CParameter) param.getValue()).getParameterValue());
                }
                pe.loadProperties();
                // plugins.put((String) entry.getKey(), pe);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setCreator(UserInfo user) {
        if (user != null) {
            creatorId.setValue(user.getId());
            creatorName.setValue(user.getName());
            created.setValue(XMLUtil.getCurrentDateAndTime());
        } else {
            creatorId.setValue("");
            creatorName.setValue("");
        }
    }

    public void setModifier(UserInfo user) {
        if (user != null) {
            modifierId.setValue(user.getId());
            modifierName.setValue(user.getName());
            modifyTime.setValue(XMLUtil.getCurrentDateAndTime());
        } else {
            modifierId.setValue("");
            modifierName.setValue("");
            modifyTime.setValue("");
        }
    }

    public void reConfigApplication(WFApplication wfApp, String appName) {
        // 把应用配置文件下载到本地
        // AppConfigManager.getInstance().downloadConfigFile(appName,this.getClassifications());
        setAppName(appName);
        // setClassifications(appName);
        // 刷新流程插件信息
        loadPlugins();
        fillPlugins();
        // 刷新活动插件信息
        Activities acts = (Activities) get("Activities");
        for (Iterator it = acts.toCollection().iterator(); it.hasNext(); ) {
            Activity act = (Activity) it.next();
            act.refreshPlugins();
        }
    }

    // 实现clone方法
    public Object clone() {
        WorkflowProcess wp = (WorkflowProcess) super.clone();
        wp.attrName = (XMLAttribute) this.attrName.clone();
        wp.attrAccessLevel = (XMLAttribute) this.attrAccessLevel.clone();
        wp.refProcessHeader = (ProcessHeader) this.refProcessHeader.clone();
        wp.refRedefinableHeader = (RedefinableHeader) this.refRedefinableHeader.clone();
        wp.refParticipants = (Participants) this.refParticipants.clone();
        wp.refActivitySets = (ActivitySets) this.refActivitySets.clone();
        wp.refActivities = (Activities) this.refActivities.clone();
        wp.refTransitions = (Transitions) this.refTransitions.clone();
        wp.refExtendedAttributes = (ExtendedAttributes) this.refExtendedAttributes.clone();
        wp.refExtendedAttributes.clear();
        wp.attrClassification = (XMLAttribute) this.attrClassification.clone();
        wp.attrSystemCode = (XMLAttribute) this.attrSystemCode.clone();
        wp.attrVersionId = (XMLAttribute) this.attrVersionId.clone();
        wp.attrVersionId.setValue(UUID.randomUUID().toString());
        wp.versionDesc = (Description) this.versionDesc.clone();
        wp.activeTime = (XMLAttribute) this.activeTime.clone();
        wp.activeTime.setValue("");
        wp.freezeTime = (XMLAttribute) this.freezeTime.clone();
        wp.freezeTime.setValue("");
        wp.creatorName = (XMLAttribute) this.creatorName.clone();
        wp.creatorName.setValue("");
        wp.modifierId = (XMLAttribute) this.modifierId.clone();
        wp.modifierId.setValue("");
        wp.modifierName = (XMLAttribute) this.modifierName.clone();
        wp.modifierName.setValue("");
        wp.modifyTime = (XMLAttribute) this.modifyTime.clone();
        wp.modifyTime.setValue("");
        wp.publicationStatus = (XMLAttribute) wp.refRedefinableHeader.get("PublicationStatus");
        wp.version = wp.refRedefinableHeader.get("Version");
        wp.desc = (Description) wp.refProcessHeader.get("Description");
        wp.limit = wp.refProcessHeader.get("Limit");
        wp.durationUnit = (XMLAttribute) wp.refProcessHeader.get("DurationUnit");

        // 监听器的clone
        wp.listeners = (Listeners) this.listeners.clone();
        // 流程权限组的clone
        wp.rightGroups = (RightGroups) this.rightGroups.clone();
        wp.fillStructure();
        // 设置clone后Activity的WorkflowProcess
        Activities acts = (Activities) wp.get("Activities");
        acts.setOwner(wp);
        for (Iterator it = acts.toCollection().iterator(); it.hasNext(); ) {
            Activity act = (Activity) it.next();
            act.setCollection(acts);
            act.setWorkflowProcess(wp);
        }
        // 设置clone后Transition的WorkflowProcess
        Transitions ts = (Transitions) wp.get("Transitions");
        ts.setOwner(wp);
        for (Iterator it = ts.toCollection().iterator(); it.hasNext(); ) {
            Transition t = (Transition) it.next();
            t.setCollection(ts);
            t.setWorkflowProcess(wp);
        }
        Map actMap = BPD.getInstance().getActMap();
        // clone开始节点的路由
        Set tmpSet = new HashSet(startDescriptions);
        startDescriptions.clear();
        for (Iterator it = tmpSet.iterator(); it.hasNext(); ) {
            String startDesc = (String) it.next();
            String actId = startDesc.substring(startDesc.indexOf(";") + 1, startDesc.indexOf(";") + 1 + startDesc.indexOf(";", startDesc.indexOf(";")));
            Activity act = (Activity) actMap.get(actId);
            if (act != null) {
                startDesc = StringUtility.replace(startDesc, actId, act.getID());
            }
            startDescriptions.add(startDesc);
        }
        // clone结束节点的路由
        tmpSet = new HashSet(endDescriptions);
        endDescriptions.clear();
        for (Iterator it = tmpSet.iterator(); it.hasNext(); ) {
            String endDesc = (String) it.next();
            String[] ends = Utils.tokenize(endDesc, WorkflowProcess.ENDOFWORKFLOW_SEPARATE);
            for (int i = 0; i < ends.length; i++) {
                String end = ends[i];
                String[] values = Utils.tokenize(end, ";");
                String[] endActs = Utils.tokenize(values[1], WorkflowProcess.ENDOFWORKFLOWACT_SEPARATE);
                for (int j = 0; j < endActs.length; j++) {
                    Activity act = (Activity) actMap.get(endActs[j]);
                    if (act != null) {
                        endDesc = StringUtility.replace(endDesc, endActs[j], act.getID());
                    }
                }
                endDescriptions.add(endDesc);
            }
        }

        wp.saveUserInfo();

        // clone插件
        wp = clonePlugins(wp);

        return wp;
    }

    public ActivitySets getActivitySets() {
        return this.refActivitySets;
    }

    // 插件的clone方法
    public WorkflowProcess clonePlugins(WorkflowProcess wp) {
        wp.plugins = new HashMap();
        for (Iterator it = plugins.entrySet().iterator(); it.hasNext(); ) {
            Map.Entry entry = (Map.Entry) it.next();
            String name = (String) entry.getKey();
            Object val = entry.getValue();
            Object cloneVal = ((PluginElement) val).clone();
            wp.complexStructure.add(cloneVal);
            wp.plugins.put(name, cloneVal);
        }
        return wp;
    }

    // 设置流程的包
    public void setPackage(Package p) {
        this.myPackage = p;
    }

    // 实现equals方法
    public boolean equals(Object o) {
        if (o == null || !(o instanceof WorkflowProcess)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        WorkflowProcess tmp = (WorkflowProcess) o;
        return tmp.getVersionID().equals(this.getVersionID());
    }

    /**
     * 设置流程版本状态
     *
     * @param publicationStatus
     */
    public void setPublicationStatus(ProcessDefVersionStatus publicationStatus) {
        this.publicationStatus.setValue(publicationStatus.getType());
        this.publicationStatus.refreshDisplayValue();
    }

    /**
     * 设置版本激活时间
     *
     * @param activeTime
     */
    public void setActiveTime(String activeTime) {
        this.activeTime.setValue(activeTime);
    }

    /**
     * 设置版本冻结时间
     *
     * @param freezeTime
     */
    public void setFreezeTime(String freezeTime) {
        this.freezeTime.setValue(freezeTime);
    }

    public Transitions getRefTransitions() {
        return refTransitions;
    }

    public void setRefTransitions(Transitions refTransitions) {
        this.refTransitions = refTransitions;
    }

}
