
package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.BPDConstants;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.config.AppConfigManager;
import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.panels.XMLComboPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.enums.process.ProcessDefEnums;
import com.ds.common.logging.Log;
import com.ds.common.logging.LogFactory;
import com.ds.config.PluginType;
import com.ds.config.BPDProjectConfig;
import com.ds.enums.EnumsUtil;
import com.ds.iot.json.UserInfo;

import java.util.List;


public class WFApplication extends XMLComplexElement {

    private static transient Log logger = LogFactory.getLog(BPDConstants.APPLICATION_NAME, WFApplication.class);

    // 应用属性
    private XMLAttribute attrSystemCode;

    private XMLAttribute attrAccessLevel = new XMLAttribute(EnumsUtil.getAttribute(ProcessDefEnums.AccessLevel));

    private XMLAttribute attrClassification = null;// new XMLAttribute("Classification");
    // private XMLAttribute attrClassification = new XMLAttribute("Classification");

    private AppConfigManager manager = AppConfigManager.getInstance();

    public WFApplication(String systemCode, String classificationCode) {
        String[][] apps = manager.getApps();
        if (apps != null && apps.length > 0) {
            attrSystemCode = new XMLAttribute("SystemCode", apps, 0) {
                public void itemChanged(Object o) {
                    XMLSelectOption selectOption = (XMLSelectOption) o;
                    setClassifications(selectOption.getName());

                }
            };
        } else {
            attrSystemCode.setReadOnly(true);
        }

        attrSystemCode.setLabelName(ResourceManager.getLanguageDependentString("Process.General.SystemCode.display"));
        attrAccessLevel.setLabelName(ResourceManager.getLanguageDependentString("Process.General.AccessLevel.display"));
        attrAccessLevel.setVisible(false);
        setClassifications(apps[0][1]);
        if (attrClassification != null) {
            attrClassification.setLabelName(ResourceManager.getLanguageDependentString("Process.General.Classification.display"));

        }
        fillStructure();

        if (systemCode != null) {
            this.attrSystemCode.setValue(systemCode);
        }
        if (classificationCode != null) {
            this.attrClassification.setValue(classificationCode);
        }

    }

    public WFApplication() {

        this(null, null);

    }

    protected void fillStructure() {
        complexStructure.add(attrSystemCode);
        complexStructure.add(attrAccessLevel);
        complexStructure.add(attrClassification);
    }

    // 设置可配置的流程类型
    public void setClassifications(String appName) {
        UserInfo user = BPD.getInstance().getUserInfo();
        if (user != null) {
            List<BPDProjectConfig> classifications = AppConfigManager.getInstance().getProcessClassifications(appName, user.getId());
            if (classifications != null && classifications.size() > 0) {

                String[][] flowArr = new String[classifications.size()][2];
                int i = 0;
                for (BPDProjectConfig classification : classifications) {
                    flowArr[i] = new String[]{classification.getName(), classification.getCode()};
                    i = i + 1;
                }
                if (attrClassification == null) {
                    attrClassification = new XMLAttribute(PluginType.Classification.getType(), flowArr, 0);
                } else {
                    XMLAttribute newattrClassification = new XMLAttribute(PluginType.Classification.getType(), flowArr, 0);
                    int index = getIndex(PluginType.Classification.getType());
                    if (index != -1) {
                        complexStructure.set(index, attrClassification);
                    } else {
                        complexStructure.add(attrClassification);
                    }
                    attrClassification.setRequired(false);
                    attrClassification.getOldPanel().updatePanel(new XMLComboPanel(newattrClassification, XMLPanel.BOX_LAYOUT, true));
                }

            }
            if (attrClassification != null) {
                attrClassification.setLabelName(ResourceManager.getLanguageDependentString("Process.General.Classification.display"));
            }

        }
    }

    public void setVisible(String name, boolean flag) {
        XMLElement e = get(name);
        if (e != null) {
            e.setVisible(flag);
        }
    }

    public String getSystemCode() {

        return attrSystemCode.toValue().toString();
    }

    public String getClassificationCode() {
        return attrClassification.toValue().toString();
    }

    // 实现clone方法
    public Object clone() {
        WFApplication wf = (WFApplication) super.clone();
        wf.attrAccessLevel = (XMLAttribute) this.attrAccessLevel.clone();
        wf.attrSystemCode = (XMLAttribute) this.attrSystemCode.clone();
        wf.attrClassification = (XMLAttribute) this.attrClassification.clone();
        wf.fillStructure();
        return wf;
    }
}
