/* TransitionRestrictions.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>TransitionRestrictions</b> instances.
 * 
 * @see XML
 */
public class TransitionRestrictions extends XMLCollection {

	public TransitionRestrictions(Activity act) {
		super(act);
	}

	// min=0, max=unbounded
	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		TransitionRestriction tr = new TransitionRestriction();
		tr.setRequired(true);
		return tr;
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		TransitionRestrictions t = (TransitionRestrictions) super.clone();
		return t;
	}

	public boolean isEmpty() {
		if (!super.isEmpty()) {
			TransitionRestriction tr = (TransitionRestriction) refCollectionElements.get(0);
			if (tr.isEmpty() && size() == 1) {
				return true;
			}
		}
		return false;
	}

}
