/* Script.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLAttribute;
import com.ds.bpm.bpd.xml.XMLComplexElement;

/**
 * Represents a WfMC DTD element that has the similar name.
 */
public class Script extends XMLComplexElement {
	private XMLAttribute attrType = new XMLAttribute("Type"); // required

	private XMLAttribute attrVersion = new XMLAttribute("Version"); // required

	private XMLAttribute attrGrammar = new XMLAttribute("Grammar", 1); // required

	/**
	 * Creates a new instance of the class.
	 */
	public Script() {
		super();

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		attrType.setRequired(true);
		complexStructure.add(attrType);
		attributes.add(attrType);
		complexStructure.add(attrVersion);
		attributes.add(attrVersion);
		complexStructure.add(attrGrammar);
		attributes.add(attrGrammar);
	}

}
