/* Responsibles.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Iterator;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLListPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>Responsible</b> instances. 流程监控人组类
 * 
 * @see XML
 */
public class Responsibles extends XMLCollection {
	/**
	 * Creates a new instance of the class.
	 * 
	 * @param packageOrWProcess
	 *            The class instance which member is this class instance. Can be
	 *            Package or WorkflowProcess
	 */
	public Responsibles(XMLComplexElement packageOrWProcess) {
		super(packageOrWProcess);
	}

	/**
	 * Returns <tt>true</tt> if specified participant isn't referenced to be a
	 * responsible for some process or package.
	 */
	protected boolean canRemoveParticipant(Participant toRemove) {
		Responsible r;
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			r = (Responsible) it.next();
			if (r.toValue() == toRemove) {
				return false;
			}
		}
		return true;
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		Responsible r = new Responsible(myOwner, this);
		r.setRequired(true);
		return r;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLListPanel(this, "", false, false, true);
		controlPanel = new XMLListControlPanel(this, "", true, false, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	/**
	 * Called by Package object after importing of XML file to set the proper
	 * Participant objects for Responsibles of Package or WorkflowProcess,
	 * depending on that who owns Responsibles. Participants are set according
	 * to it's ID's read from XML.
	 */
	protected void afterImporting() {
		/*
		 * Participants ps = (Participants) myOwner.get("Participants");
		 * Iterator it = refCollectionElements.iterator(); while (it.hasNext()) {
		 * Responsible r = (Responsible) it.next();
		 * r.setValue(ps.getParticipant(r.toValue().toString())); }
		 */
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Responsibles r = (Responsibles) super.clone();
		return r;
	}
}
