/*
 * Created on 2004-3-28
 *
 * The itjds Software License, Version 1.0
 * 
 * Copyright (c) 2004 The itjds Software Foundation.  All rights
 * reserved.
 */

package com.ds.bpm.bpd.xml.elements;

import javax.swing.ListSelectionModel;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.formula.org.XMLRightOrgPanel;

/**
 * <p>
 * Title: 工作流设计工具（BPD）
 * </p>
 * <p>
 * Description: 流程授权类
 * </p>
 * <p>
 * Copyright: Copyright (c) 2004
 * </p>
 * <p>
 * Company: itjds
 * </p>
 * 
 * @author Huchm 2004-3-28 16:35:22
 * @version 1.0
 */
public class ProcessCommission extends XMLCollectionElement {

	/**
	 * Constructs a ProcessCommission instance.
	 * 
	 * @param myCollection
	 */
	public ProcessCommission(XMLCollection myCollection) {
		super(myCollection);
		setLabelName(ResourceManager
				.getLanguageDependentString("ProcessCommission."
						+ myCollection.toName() + ".display"));
	}

	public XMLPanel getPanel() {
		return new XMLRightOrgPanel(this, getCollection(), toLabel(), true,
				true, ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
	}

	public String toString() {
		if (toValue() instanceof XMLSelectOption) {
			return ((XMLSelectOption) toValue()).getName();
		} else {
			return "";
		}
	}

}
