
package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.alibaba.fastjson.JSONArray;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLSelectOption;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTabbedPanel;
import com.ds.bpm.enums.right.CommissionEnums;
import com.ds.common.JDSException;
import com.ds.org.Person;

/**
 * 
 * @author wenzhang
 *
 */
public class ProcessCfgCommission extends XMLComplexElement {

    private List<ProcessCommissions> commissions = new ArrayList<ProcessCommissions>();

    private WorkflowProcess wp;

    /**
     * Constructs a ProcessCfgCommission instance.
     */
    public ProcessCfgCommission() {
	super();
    }

    public ProcessCfgCommission(WorkflowProcess wp) {
	this.wp = wp;
	setLabelName(ResourceManager.getLanguageDependentString("ProcessCommission.display"));
	CommissionEnums[] groups = CommissionEnums.values();
	for (CommissionEnums group : groups) {
	    ProcessCommissions pcs = new ProcessCommissions(this, group);
	    commissions.add(pcs);
	}
    }

    public ProcessCommissions getProcessCommissionsByGroup(CommissionEnums group) {

	for (ProcessCommissions processCommission : commissions) {
	    if (processCommission.getGroup().equals(group)) {
		return processCommission;
	    }
	}
	ProcessCommissions processCommission=new ProcessCommissions(this, group);
	commissions.add(processCommission);
	return processCommission;

    }

    public XMLPanel getPanel() {
	List<XMLPanel> panels = new ArrayList<XMLPanel>();
	for (ProcessCommissions elem : commissions) {
	    panels.add(elem.getPanel());
	}
	return new XMLTabbedPanel(this, (XMLPanel[]) panels.toArray(new XMLPanel[panels.size()]));
    }

    // 保存流程授权信息到服务器
    public boolean toServer() {
	boolean flag = true;
	for (ProcessCommissions pcs : commissions) {
	    String rightCode = pcs.toName();
	    Collection<XMLCollectionElement> pcsCollection = pcs.toCollection();

	    List<String> personIds = new ArrayList<String>();
	    if (pcsCollection.size() > 0) {

		for (XMLCollectionElement elem : pcsCollection) {

		    XMLSelectOption val = (XMLSelectOption) elem.toValue();

		    personIds.add(val.getText());
		}
	    }
	    String wpId = wp.getID();

	    try {

		BPD.getInstance().getBPDService().saveCommission(wpId, rightCode, JSONArray.toJSONString(personIds));
	    } catch (JDSException e) {
		BPD.getInstance().getBPDService().handleWebServiceException(e);
	    }
	}

	return flag;
    }

    // 从服务器获取流程授权信息
    public boolean fromServer() {
	boolean flag = true;

	CommissionEnums[] groups = CommissionEnums.values();
	try {
	    for (CommissionEnums group : groups) {
		ProcessCommissions pcs = this.getProcessCommissionsByGroup(group);
		List<Person> persons = new ArrayList<Person>();
		persons = BPD.getInstance().getBPDService().getCommissions(wp.getID(), group.getType());
		if (persons != null) {
		    for (Person person : persons) {
			XMLElement pc = pcs.generateNewElement();
			pc.setValue(new String[] { person.getID(), person.getName() });
		    }

		}
		// commissions.add(pcs);

	    }
	} catch (JDSException e) {
	    flag = false;
	    BPD.getInstance().getBPDService().handleWebServiceException(e);
	}

	return flag;
    }

}
