/* ExtendedAttributes.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * Helper class.
 */
public class Namespaces extends XMLCollection {
	/**
	 * Creates a new instance of the class.
	 */
	public Namespaces(Package owner) {
		super(owner);
	}

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		Namespace ns = new Namespace();
		ns.setRequired(true);
		return ns;
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Namespaces nss = (Namespaces) super.clone();
		nss.myOwner = this.myOwner;
		return nss;
	}

	// First, the controlled panel must be created, and then the control panel
	public XMLPanel getPanel() {
		controlledPanel = new XMLTablePanel(this, "", false, false, true);
		controlPanel = new XMLTableControlPanel(this, "", true, false);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

}
