/* ExternalPackages.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Iterator;

import javax.swing.JOptionPane;

import com.ds.bpm.bpd.BPD;
import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.XMLUtil;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLListPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a
 * collection of class <b>ExternalPackage</b> instances.
 * 
 * @see XML
 */
public class ExternalPackages extends XMLCollection {
	/**
	 * Creates a new instance of the class.
	 * 
	 * @param myOwner
	 *            The package which member is this class instance.
	 */
	public ExternalPackages(Package myOwner) {
		super(myOwner);
	}

	/**
	 * Overrides super-class method to realize this class specific reading from
	 * XML file.
	 * 
	 * @param tagContent
	 *            The content retrieved from XML file, that represents tag for
	 *            this element.
	 */
	/*
	 * public void fromXML(Node node) { super.fromXML(node); // files that are
	 * not found Set toDelete=new HashSet(); // creating instances of PE for
	 * every external package (recursive // implementation of createLocalCopy
	 * method) Iterator it=refCollectionElements.iterator(); while
	 * (it.hasNext()) { ExternalPackage ep=(ExternalPackage)it.next(); String
	 * xmlFile = ep.toString(); if (!XML.doesPackageFileExists(xmlFile)) {
	 * toDelete.add(ep); XML.message(ep.toString()+": "+XML.getResourceString(
	 * "InformationErrorWhileOpeningFile"), JOptionPane.INFORMATION_MESSAGE);
	 * continue; } String ID=XML.getIDFromFile(xmlFile);
	 * System.out.println("EID="+ID); if (ID.length()==0) { toDelete.add(ep);
	 * XML.message(ep.toString()+": "+XML.getResourceString(
	 * "InformationErrorWhileOpeningFile"), JOptionPane.INFORMATION_MESSAGE); } }
	 * refCollectionElements.removeAll(toDelete); }
	 */

	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		ExternalPackage ep = new ExternalPackage(this);
		ep.setRequired(true);
		return ep;
	}

	public boolean canInsertElement(XMLElement el) {
		boolean canInsert = true;
		// set the user.dir to the original
		try {
			System.setProperty("user.dir", BPD.getInstance().getXMLInterface()
					.getParentDirectory((Package) myOwner));
		} catch (Exception ex) {
		}

		try {
			// get an ID of external package
			String extID = BPD.getInstance().getXMLInterface().getIDFromFile(el.toString());

			// check if has an valid ID (file must exist)
			if (extID.length() == 0) {
				canInsert = false;
			}

			// Check if it has the same ID as the main package file that we are
			// working at
			String myOwnerId = myOwner.get("Id").toString().trim();
			if (canInsert && myOwnerId.equals(extID)) {
				canInsert = false;
			}

			// check if package file has already been inserted (or if some file
			// with the same ID is inserted)
			if (canInsert) {
				Iterator it = refCollectionElements.iterator();
				while (it.hasNext()) {
					ExternalPackage ep = (ExternalPackage) it.next();
					String epId = BPD.getInstance().getXMLInterface().getExternalPackageByRelativeFilePath(
							ep.toString(), (Package) myOwner).get("Id")
							.toString();
					if (extID.equals(epId)) {
						canInsert = false;
						break;
					}
				}
			}

			// check if there are some packages referenced by this package
			// external packages which have identical Id and diferent URL,
			// and if so, do not insert this ext. pkg
			if (canInsert) {
				String cp = XMLUtil.getCanonicalPath(el.toString(), false);
				Iterator it = BPD.getInstance().getXMLInterface().getAllPackages().iterator();
				while (it.hasNext()) {
					Package p = (Package) it.next();
					String pId = p.get("Id").toString();
					if (extID.equals(pId)
							&& !BPD.getInstance().getXMLInterface().getAllPackageFilenames().contains(cp)) {
						canInsert = false;
						break;
					}
				}
			}

		} catch (Exception ex) {
			//
		}
		if (!canInsert) {
			XMLUtil
					.message(
							XMLUtil
									.getLanguageDependentString("InformationExternalPackageCannotBeInserted"),
							JOptionPane.INFORMATION_MESSAGE);
		}
		return canInsert;
	}

	// when some external package is referenced, insert their entities to the
	// package
	/**
	 * Overrides super-class method to implement class specific actions when
	 * element is inserted into this class collection.
	 * 
	 * @param el
	 *            Inserted element - in this case it must be instance of
	 *            ExternalPackage class.
	 */
	public void onElementInserted(XMLElement el) {
		ExternalPackage ep = (ExternalPackage) el;
		// the insertFromExternal method of main package is called to
		// process all newly added packages
		String xmlFile = XMLUtil.getCanonicalPath(ep.toString(), false);
		if (BPD.getInstance().getXMLInterface().doesPackageFileExists(xmlFile)
				&& BPD.getInstance().getXMLInterface().getIDFromFile(xmlFile).length() > 0) {
			((Package) myOwner).insertFromExternal(ep);
		} else {
			XMLUtil
					.message(
							XMLUtil
									.getLanguageDependentString("InformationErrorWhileOpeningFile"),
							JOptionPane.INFORMATION_MESSAGE);
			refCollectionElements.remove(ep);
		}
	}

	/**
	 * Overrides super-class method to implement class specific check wether
	 * specified element can be removed from this class collection or not.
	 * 
	 * @param el
	 *            Element that is checked for removal - in this case it must be
	 *            instance of ExternalPackage class.
	 * @return <tt>true</tt> if specified element can be removed,
	 *         <tt>false</tt> otherwise.
	 */
	public boolean canRemoveElement(XMLElement el) {
		return ((Package) myOwner)
				.canRemoveExternalPackage((ExternalPackage) el);
	}

	/**
	 * Overrides super-class method to implement class specific actions when
	 * element is removed from this class collection.
	 * 
	 * @param el
	 *            Removed element - in this case it must be instance of
	 *            ExternalPackage class.
	 */
	public void onElementRemoved(XMLElement el) {
		((Package) myOwner).removeExternal((ExternalPackage) el);

	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLListPanel(this, "", false, true, false);
		controlPanel = new XMLListControlPanel(this, "", true, false, true);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	public String getInUseMessageName(XMLComplexElement el) {
		return "ErrorCannotRemoveExternalPackage";
	}

}
