/* Deadlines.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Iterator;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.activity.Activity;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLListControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLListPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * This is not a real WfMC DTD element, but it is introduced to help. This class
 * is a collection of class <b>Deadline</b> instances.
 */
public class Deadlines extends XMLCollection {
	/**
	 * Creates a new instance of the class.
	 * 
	 * @param act
	 *            The activity that holds elements this element.
	 */
	public Deadlines(Activity act) {
		super(act);
	}

	// min=0, max=unbounded
	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		Deadline d = new Deadline();
		d.setRequired(true);
		return d;
	}

	/**
	 * Creates panel which allows user to manipulate with instances of classes
	 * that makes a collection that this class represents. The panel consists of
	 * two sections: XMLListPanel - shows collections' elements, and
	 * XMLListControlPanel - display buttons for manipulating with that
	 * elements.
	 * <p>
	 * NOTE: The order of creation is relevant, first, the controlled panel must
	 * be created, and then the control panel
	 * 
	 * @return DTDPanel to be shown
	 */
	public XMLPanel getPanel() {
		controlledPanel = new XMLListPanel(this, "", false, true, false);
		controlPanel = new XMLListControlPanel(this, "", true, false, true);
		return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel,
				controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
	}

	/**
	 * Overrides super-class method to realize this class specific writting to
	 * XML file.
	 * <p>
	 * NOTE: This element doesn't exist in WfMC DTD and it is among other
	 * things, also introduced to gather Deadline definitions and write it int
	 * XML.
	 */
	public void toXML(Node parent) throws DOMException {
		if (refCollectionElements.size() > 0) {
			for (Iterator it = refCollectionElements.iterator(); it.hasNext();) {
				((XMLElement) it.next()).toXML(parent);
			}
		}
	}

	/*
	 * public int[] getInvisibleTableFieldOrdinals () { int[] itfo=new int[4];
	 * itfo[0]=0; itfo[1]=3; itfo[2]=4; itfo[3]=5; return itfo; }
	 */

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Deadlines d = (Deadlines) super.clone();
		return d;
	}

	/**
	 * Decrements an ID. Used when the temporary element is created. This avoids
	 * unnecessary incrementation of IDs.
	 */
	protected void decrementID() {
		super.decrementID();
	}

}
