/* DataTypes.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

import com.ds.bpm.bpd.xml.XMLComplexChoice;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.elements.specialpanels.XMLDataTypesPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

import org.w3c.dom.Node;

public class DataTypes extends XMLComplexChoice {
	private BasicType basicType;

	private DeclaredType declaredType;

	private SchemaType schemaType;

	private ExternalReference externalReference;

	private RecordType recordType;

	private UnionType unionType;

	private EnumerationType enumerationType;

	private ArrayType arrayType;

	private ListType listType;

	private XMLComplexElement myOwner = null;

	private transient Package myPackage = null;

	Set invisibles = new HashSet();

	int choosenIndex = 0;

	public DataTypes(XMLComplexElement myOwner, Package p,
			int[] invisibleTypes, int choosenIndex) {

		super("Type", null, 0);

		this.myOwner = myOwner;
		myPackage = p;

		if (invisibleTypes != null && invisibleTypes.length > 0) {
			for (int i = 0; i < invisibleTypes.length; i++) {
				invisibles.add(new Integer(invisibleTypes[i]));
			}
		}

		this.choosenIndex = choosenIndex;
	}

	public void setValue(Object v) {
		super.setValue(v);
		// "kill" other types
		if (!(v instanceof BasicType)) {
			basicType = null;
		}
		if (!(v instanceof DeclaredType)) {
			declaredType = null;
		}
		if (!(v instanceof SchemaType)) {
			schemaType = null;
		}
		if (!(v instanceof ExternalReference)) {
			externalReference = null;
		}
		if (!(v instanceof RecordType)) {
			recordType = null;
		}
		if (!(v instanceof UnionType)) {
			unionType = null;
		}
		if (!(v instanceof EnumerationType)) {
			enumerationType = null;
		}
		if (!(v instanceof ArrayType)) {
			arrayType = null;
		}
		if (!(v instanceof ListType)) {
			listType = null;
		}
	}

	public XMLPanel getPanel() {
		return new XMLDataTypesPanel(this, toLabel());
	}

	public Object[] getChoices() {
		ArrayList chs = new ArrayList();
		if (!invisibles.contains(new Integer(0))) {
			if (basicType == null) {
				basicType = new BasicType();
			}
			chs.add(basicType);
		}
		if (!invisibles.contains(new Integer(1))) {
			if (declaredType == null) {
				declaredType = new DeclaredType(myPackage);
			}
			chs.add(declaredType);
		}
		if (!invisibles.contains(new Integer(2))) {
			if (schemaType == null) {
				schemaType = new SchemaType();
			}
			chs.add(schemaType);
		}
		if (!invisibles.contains(new Integer(3))) {
			if (externalReference == null) {
				externalReference = new ExternalReference();
			}
			chs.add(externalReference);
		}
		if (!invisibles.contains(new Integer(4))) {
			if (recordType == null) {
				recordType = new RecordType(myPackage);
			}
			chs.add(recordType);
		}
		if (!invisibles.contains(new Integer(5))) {
			if (unionType == null) {
				unionType = new UnionType(myPackage);
			}
			chs.add(unionType);
		}
		if (!invisibles.contains(new Integer(6))) {
			if (enumerationType == null) {
				enumerationType = new EnumerationType();
			}
			chs.add(enumerationType);
		}
		if (!invisibles.contains(new Integer(7))) {
			if (arrayType == null) {
				arrayType = new ArrayType(this, myPackage);
			}
			chs.add(arrayType);
		}
		if (!invisibles.contains(new Integer(8))) {
			if (listType == null) {
				listType = new ListType(this, myPackage);
			}
			chs.add(listType);
		}
		if (choosen == null) {
			choosen = chs.get(choosenIndex);
		}
		choices = chs.toArray();
		return choices;
	}

	public XMLComplexElement getOwner() {
		return myOwner;
	}

	/**
	 * Overrides super-class method to retrieve the defined condition.
	 * 
	 * @return The condition of transition.
	 */
	public String toString() {
		if (choosen != null) {
			return ((XMLElement) choosen).toString();
		} else {
			return "";
		}
	}

	public void fromXML(String choosen, Node node) {
		// gets choices first - creating objects
		getChoices();
		super.fromXML(choosen, node);
	}

}
