/* DataType.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import com.ds.bpm.bpd.xml.XML;
import com.ds.bpm.bpd.xml.XMLComplexElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;

/**
 * Represents a WfMC DTD element that has the similar name.
 * 
 * @see XML
 */
public class DataType extends XMLComplexElement {
	private DataTypes refDataTypes;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param p
	 *            The package which elements holds instance of of this class.
	 */
	public DataType(Package p) {
		super();

		refDataTypes = new DataTypes(this, p, null, 0);

		fillStructure();
	}

	/**
	 * Defines the super-class method. Read the explanation for this method
	 * within XMLComplexElement class.
	 */
	protected void fillStructure() {
		refDataTypes.setRequired(true);
		complexStructure.add(refDataTypes);
	}

	/**
	 * Returns the value of choosen type.
	 * 
	 * @return The value of choosen data type.
	 */
	public Object toValue() {
		return refDataTypes.toValue();
	}

	/**
	 * Prepares the panel with a combo box to choose the one of allowed data
	 * types.
	 * 
	 * @return XMLPanel to be shown.
	 */
	public XMLPanel getPanel() {
		return refDataTypes.getPanel();
	}
}
