/* ActivitySets.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml.elements;

import java.util.Iterator;
import java.util.UUID;

import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLCollectionElement;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLGroupPanel;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTableControlPanel;
import com.ds.bpm.bpd.xml.panels.XMLTablePanel;

/**
 * Represents a WfMC DTD element that has the similar name. This class is a collection of class {@link ActivitySet}
 * instances.
 */
public class ActivitySets extends XMLCollection {

    /**
     * Creates a new instance of the class.
     * 
     * @param myWorkflow
     *            WorkflowProcess class that holds ActivitySets class.
     */
    public ActivitySets(WorkflowProcess myWorkflow) {
	super(myWorkflow);
    }

    /**
     * Generates a new element of the class which instances are members of collection of this class. return The
     * generated instance of class that makes collection.
     */
    public XMLElement generateNewElement() {
	ActivitySet as = new ActivitySet(this, (WorkflowProcess) myOwner);
	as.setVersionId(UUID.randomUUID().toString());
	as.setRequired(true);
	return as;
    }

    /**
     * Returns an ActivitySet specified by given ID.
     * 
     * @param ID
     *            The ID attribute of wanted ActivitySet.
     * @return An instance of ActivitySet class that has specified ID. If collection of activity sets does not contain
     *         wanted ActivitySet, the <tt>null</tt> is returned.
     */
    public ActivitySet getActivitySet(String ID) {
	return (ActivitySet) super.getCollectionElement(ID);
    }

    protected void addPropertyToAllActivities(UserProperty up) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ((ActivitySet) it.next()).addPropertyToAllActivities(up);
	}
    }

    protected void removePropertyFromAllActivities(UserProperty up) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ((ActivitySet) it.next()).removePropertyFromAllActivities(up);
	}
    }

    protected void refreshMandatories(UserProperty up) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ((ActivitySet) it.next()).refreshMandatories(up);
	}
    }

    /**
     * Returns <tt>true</tt> if specified workflow process isn't referenced from any activity of subflow type.
     */
    protected boolean canRemoveWorkflow(WorkflowProcess toRemove) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ActivitySet as = (ActivitySet) it.next();
	    boolean cr = as.canRemoveWorkflow(toRemove);
	    if (cr == false) {
		return false;
	    }
	}
	return true;
    }

    /**
     * Returns <tt>true</tt> if specified participant isn't referenced to be a performer of activity.
     */
    protected boolean canRemoveParticipant(Participant toRemove) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ActivitySet as = (ActivitySet) it.next();
	    boolean cr = as.canRemoveParticipant(toRemove);
	    if (cr == false) {
		return false;
	    }
	}
	return true;
    }

    /**
     * Returns <tt>true</tt> if specified application isn't used as a tool of activity which type is Tool.
     */
    protected boolean canRemoveApplication(Application toRemove) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ActivitySet as = (ActivitySet) it.next();
	    boolean cr = as.canRemoveApplication(toRemove);
	    if (cr == false) {
		return false;
	    }
	}
	return true;
    }

    /**
     * Returns <tt>true</tt> if specified data field isn't used as actual parameter of activity which type is Tool or
     * Subflow.
     */
    public boolean canRemoveDataFieldOrFormalParameter(XMLCollectionElement toRemove) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ActivitySet as = (ActivitySet) it.next();
	    boolean cr = as.canRemoveDataFieldOrFormalParameter(toRemove);
	    if (cr == false) {
		return false;
	    }
	}
	return true;
    }

    /**
     * Returns <tt>true</tt> if specified data field or formal parameter is used in transition condition expression of
     * any transition within every activity set transitions.
     */
    public boolean isDataFieldOrFormalParameterUsedWithinTransitionConditions(XMLCollectionElement toRemove) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ActivitySet as = (ActivitySet) it.next();
	    boolean inUse = as.isDataFieldOrFormalParameterUsedWithinTransitionConditions(toRemove);
	    if (inUse == true) {
		return true;
	    }
	}
	return false;
    }

    /**
     * Called by owner object after importing of XML file to do neccessary things on activities after importing of XML.
     */
    protected void afterImporting(boolean importUserProperties) {
	Iterator it = refCollectionElements.iterator();
	while (it.hasNext()) {
	    ActivitySet as = (ActivitySet) it.next();
	    as.afterImporting(importUserProperties);
	}
    }

    // First, the controlled panel must be created, and then the control panel
    public XMLPanel getPanel() {
	isReadOnly = true;
	controlledPanel = new XMLTablePanel(this, "", false, false);
	controlPanel = new XMLTableControlPanel(this, "", true, false);
	return new XMLGroupPanel(this, new XMLPanel[] { controlledPanel, controlPanel }, toLabel(), XMLPanel.BOX_LAYOUT, false, true);
    }

    /**
     * Overrides parent method to be accessible within WorkflowManager.
     */
    public void decrementID() {
	super.decrementID();
    }

    /**
     * Overrides parent method to be accessible within ActivitySet.
     */
    protected void updateID(String someID) {
	super.updateID(someID);
    }

    // 实现clone方法
    public Object clone() {
	ActivitySets ass = (ActivitySets) super.clone();
	return ass;
    }
}
