/* Tools.java
 *
 * Title : BPM工作流图形定义工具BPD
 * Class Desription：XML元素的自动活动集合类
 * Authors： wenzhang
 * Company： 基督山BPM
 * CreatedTime：2005-12-6
 *
 */

package com.ds.bpm.bpd.xml.activity;

import java.util.Iterator;

import com.ds.bpm.bpd.ResourceManager;
import com.ds.bpm.bpd.xml.XMLCollection;
import com.ds.bpm.bpd.xml.XMLElement;
import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.common.util.XMLUtility;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

/**
 * This is not a real WfMC DTD element, but it is introduced to help. This class
 * is a collection of class <b>Tool</b> instances.
 */
public class Services extends XMLCollection {

	private Service service;

	/**
	 * Creates a new instance of the class.
	 * 
	 * @param act
	 *            The activity which owns this tools.
	 */
	public Services(Activity act) {
		super(act);
		setLabelName(ResourceManager
				.getLanguageDependentString("Activity.General.Type.Service.value"));
		service = (Service) generateNewElement();
		add(service);
	}

	// min=0, max=unbounded
	/**
	 * Generates a new element of the class which instances are members of
	 * collection of this class. return The generated instance of class that
	 * makes collection.
	 */
	public XMLElement generateNewElement() {
		Service t = new Service(this, ((Activity) myOwner).getOwnerProcess());
		t.setRequired(true);
		return t;
	}

	/**
	 * Overrides super-class method to realize this class specific writting to
	 * XML file.
	 * <p>
	 * NOTE: This element doesn't exist in WfMC DTD and it is among other
	 * things, also introduced to gather Tool definitions and write it int XML.
	 */
	public void toXML(Node parent) throws DOMException {
		if (refCollectionElements.size() > 0) {
			for (Iterator it = refCollectionElements.iterator(); it.hasNext();) {
				((XMLElement) it.next()).toXML(parent);
			}
		}
	}

	/**
	 * Called after importing of XML file to set the contained tools properly.
	 */
	protected void afterImporting() {
		Iterator it = refCollectionElements.iterator();
		while (it.hasNext()) {
			Service t = (Service) it.next();
			t.afterImporting();
		}
	}

	public int[] getInvisibleTableFieldOrdinals() {
		int[] itfo = new int[4];
		itfo[0] = 0;
		itfo[1] = 3;
		itfo[2] = 4;
		itfo[3] = 5;
		return itfo;
	}

	/**
	 * Used to create exact copy of instance of this class. The newly created
	 * instance will have all the properties same as the copied one.
	 * 
	 * @return The newly created instance of this class.
	 */
	public Object clone() {
		Services t = (Services) super.clone();
		return t;
	}

	public XMLPanel getPanel() {
		return service.getPanel();
	}

	public void fromXML(Node node) {
		service.fromXML(XMLUtility.getFirstChild(node, "Service"));
	}
}

/* End of Tools.java */
