/* XMLSimpleElement.java
 *
 * Authors:
 * Stefanovic Nenad  chupo@iis.ns.ac.yu
 * Bojanic Sasa      sasaboy@neobee.net
 * Puskas Vladimir   vpuskas@eunet.yu
 * Pilipovic Goran   zboniek@uns.ac.yu
 *
 */

package com.ds.bpm.bpd.xml;

import com.ds.bpm.bpd.xml.panels.XMLPanel;
import com.ds.bpm.bpd.xml.panels.XMLTextPanel;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSimpleElement extends XMLElement {

    public XMLSimpleElement() {
	super();
    }

    public void toXML(Node parent) throws DOMException {

	if (parent != null) {
	    Node node = null;

	    if (parent.getOwnerDocument() == null) {
		node = ((Document) parent).createElement(name);
	    } else {

		NodeList limitList = ((Element) parent).getElementsByTagName(name);

		if (limitList.getLength() > 0) {
		    node = limitList.item(0);

		} else {
		    node = (parent.getOwnerDocument()).createElement(name);
		    node.appendChild(parent.getOwnerDocument().createTextNode(toString().trim()));
		}

	    }

	    parent.appendChild(node);
	}

    }

    public XMLPanel getPanel() {
	return new XMLTextPanel(this);
    }

}

/* End of XMLSimpleElement.java */
